/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.impl;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.cluster.DiscoveryGroup;
import org.hornetq.core.cluster.impl.DiscoveryGroupImpl;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.cluster.Bridge;
import org.hornetq.core.server.cluster.BridgeConfiguration;
import org.hornetq.core.server.cluster.BroadcastGroup;
import org.hornetq.core.server.cluster.BroadcastGroupConfiguration;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.ClusterConnectionConfiguration;
import org.hornetq.core.server.cluster.ClusterManager;
import org.hornetq.core.server.cluster.DiscoveryGroupConfiguration;
import org.hornetq.core.server.cluster.Transformer;
import org.hornetq.core.server.cluster.impl.BridgeImpl;
import org.hornetq.core.server.cluster.impl.BroadcastGroupImpl;
import org.hornetq.core.server.cluster.impl.ClusterConnectionImpl;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterManagerImpl
implements ClusterManager {
    private static final Logger log = Logger.getLogger(ClusterManagerImpl.class);
    private final Map<String, BroadcastGroup> broadcastGroups = new HashMap<String, BroadcastGroup>();
    private final Map<String, DiscoveryGroup> discoveryGroups = new HashMap<String, DiscoveryGroup>();
    private final Map<String, Bridge> bridges = new HashMap<String, Bridge>();
    private final Map<String, ClusterConnection> clusters = new HashMap<String, ClusterConnection>();
    private final ExecutorFactory executorFactory;
    private final HornetQServer server;
    private final PostOffice postOffice;
    private final ScheduledExecutorService scheduledExecutor;
    private final ManagementService managementService;
    private final Configuration configuration;
    private final UUID nodeUUID;
    private volatile boolean started;
    private boolean backup;
    private final boolean clustered;

    public ClusterManagerImpl(ExecutorFactory executorFactory, HornetQServer server, PostOffice postOffice, ScheduledExecutorService scheduledExecutor, ManagementService managementService, Configuration configuration, UUID nodeUUID, boolean backup, boolean clustered) {
        if (nodeUUID == null) {
            throw new IllegalArgumentException("Node uuid is null");
        }
        this.executorFactory = executorFactory;
        this.server = server;
        this.postOffice = postOffice;
        this.scheduledExecutor = scheduledExecutor;
        this.managementService = managementService;
        this.configuration = configuration;
        this.nodeUUID = nodeUUID;
        this.backup = backup;
        this.clustered = clustered;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        if (this.clustered) {
            for (BroadcastGroupConfiguration broadcastGroupConfiguration : this.configuration.getBroadcastGroupConfigurations()) {
                this.deployBroadcastGroup(broadcastGroupConfiguration);
            }
            for (DiscoveryGroupConfiguration discoveryGroupConfiguration : this.configuration.getDiscoveryGroupConfigurations().values()) {
                this.deployDiscoveryGroup(discoveryGroupConfiguration);
            }
            for (ClusterConnectionConfiguration clusterConnectionConfiguration : this.configuration.getClusterConfigurations()) {
                this.deployClusterConnection(clusterConnectionConfiguration);
            }
        }
        for (BridgeConfiguration bridgeConfiguration : this.configuration.getBridgeConfigurations()) {
            this.deployBridge(bridgeConfiguration);
        }
        this.started = true;
    }

    @Override
    public synchronized void stop() throws Exception {
        if (!this.started) {
            return;
        }
        if (this.clustered) {
            for (BroadcastGroup broadcastGroup : this.broadcastGroups.values()) {
                broadcastGroup.stop();
                this.managementService.unregisterBroadcastGroup(broadcastGroup.getName());
            }
            for (DiscoveryGroup discoveryGroup : this.discoveryGroups.values()) {
                discoveryGroup.stop();
                this.managementService.unregisterDiscoveryGroup(discoveryGroup.getName());
            }
            for (ClusterConnection clusterConnection : this.clusters.values()) {
                clusterConnection.stop();
                this.managementService.unregisterCluster(clusterConnection.getName().toString());
            }
            this.broadcastGroups.clear();
            this.discoveryGroups.clear();
        }
        for (Bridge bridge : this.bridges.values()) {
            bridge.stop();
            this.managementService.unregisterBridge(bridge.getName().toString());
        }
        this.bridges.clear();
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public Map<String, Bridge> getBridges() {
        return new HashMap<String, Bridge>(this.bridges);
    }

    @Override
    public Set<ClusterConnection> getClusterConnections() {
        return new HashSet<ClusterConnection>(this.clusters.values());
    }

    @Override
    public Set<BroadcastGroup> getBroadcastGroups() {
        return new HashSet<BroadcastGroup>(this.broadcastGroups.values());
    }

    @Override
    public ClusterConnection getClusterConnection(SimpleString name) {
        return this.clusters.get(name.toString());
    }

    @Override
    public synchronized void activate() {
        for (BroadcastGroup bg : this.broadcastGroups.values()) {
            bg.activate();
        }
        for (Bridge bridge : this.bridges.values()) {
            bridge.activate();
        }
        for (ClusterConnection cc : this.clusters.values()) {
            cc.activate();
        }
        this.backup = false;
    }

    private synchronized void deployBroadcastGroup(BroadcastGroupConfiguration config) throws Exception {
        if (this.broadcastGroups.containsKey(config.getName())) {
            log.warn("There is already a broadcast-group with name " + config.getName() + " deployed. This one will not be deployed.");
            return;
        }
        InetAddress localAddress = null;
        if (config.getLocalBindAddress() != null) {
            localAddress = InetAddress.getByName(config.getLocalBindAddress());
        }
        InetAddress groupAddress = InetAddress.getByName(config.getGroupAddress());
        BroadcastGroupImpl group = new BroadcastGroupImpl(this.nodeUUID.toString(), config.getName(), localAddress, config.getLocalBindPort(), groupAddress, config.getGroupPort(), !this.backup);
        for (Pair<String, String> connectorInfo : config.getConnectorInfos()) {
            TransportConfiguration connector = this.configuration.getConnectorConfigurations().get(connectorInfo.a);
            if (connector == null) {
                this.logWarnNoConnector(config.getName(), (String)connectorInfo.a);
                return;
            }
            TransportConfiguration backupConnector = null;
            if (connectorInfo.b != null) {
                backupConnector = this.configuration.getConnectorConfigurations().get(connectorInfo.b);
                if (connector == null) {
                    this.logWarnNoConnector(config.getName(), (String)connectorInfo.b);
                    return;
                }
            }
            group.addConnectorPair(new Pair<TransportConfiguration, Object>(connector, backupConnector));
        }
        ScheduledFuture<?> future = this.scheduledExecutor.scheduleWithFixedDelay(group, 0L, config.getBroadcastPeriod(), TimeUnit.MILLISECONDS);
        group.setScheduledFuture(future);
        this.broadcastGroups.put(config.getName(), group);
        this.managementService.registerBroadcastGroup(group, config);
        group.start();
    }

    private void logWarnNoConnector(String connectorName, String bgName) {
        log.warn("There is no connector deployed with name '" + connectorName + "'. The broadcast group with name '" + bgName + "' will not be deployed.");
    }

    private synchronized void deployDiscoveryGroup(DiscoveryGroupConfiguration config) throws Exception {
        if (this.discoveryGroups.containsKey(config.getName())) {
            log.warn("There is already a discovery-group with name " + config.getName() + " deployed. This one will not be deployed.");
            return;
        }
        InetAddress groupAddress = InetAddress.getByName(config.getGroupAddress());
        DiscoveryGroupImpl group = new DiscoveryGroupImpl(this.nodeUUID.toString(), config.getName(), groupAddress, config.getGroupPort(), config.getRefreshTimeout());
        this.discoveryGroups.put(config.getName(), group);
        this.managementService.registerDiscoveryGroup(group, config);
        group.start();
    }

    private synchronized void deployBridge(BridgeConfiguration config) throws Exception {
        if (config.getName() == null) {
            log.warn("Must specify a unique name for each bridge. This one will not be deployed.");
            return;
        }
        if (config.getQueueName() == null) {
            log.warn("Must specify a queue name for each bridge. This one will not be deployed.");
            return;
        }
        if (config.getForwardingAddress() == null) {
            log.warn("Must specify an forwarding address each bridge. This one will not be deployed.");
            return;
        }
        if (this.bridges.containsKey(config.getName())) {
            log.warn("There is already a bridge with name " + config.getName() + " deployed. This one will not be deployed.");
            return;
        }
        Transformer transformer = this.instantiateTransformer(config.getTransformerClassName());
        Pair<String, String> connectorNamePair = config.getConnectorPair();
        Binding binding = this.postOffice.getBinding(new SimpleString(config.getQueueName()));
        if (binding == null) {
            log.warn("No queue found with name " + config.getQueueName() + " bridge will not be deployed.");
            return;
        }
        Queue queue = (Queue)binding.getBindable();
        BridgeImpl bridge = null;
        if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration discoveryGroupConfiguration = this.configuration.getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
            if (discoveryGroupConfiguration == null) {
                log.warn("No discovery group configured with name '" + config.getDiscoveryGroupName() + "'. The bridge will not be deployed.");
                return;
            }
            bridge = new BridgeImpl(this.nodeUUID, new SimpleString(config.getName()), queue, discoveryGroupConfiguration.getGroupAddress(), discoveryGroupConfiguration.getGroupPort(), null, this.executorFactory.getExecutor(), SimpleString.toSimpleString(config.getFilterString()), new SimpleString(config.getForwardingAddress()), this.scheduledExecutor, transformer, config.getRetryInterval(), config.getRetryIntervalMultiplier(), config.getReconnectAttempts(), config.isFailoverOnServerShutdown(), config.isUseDuplicateDetection(), config.getConfirmationWindowSize(), this.managementService.getManagementAddress(), this.managementService.getManagementNotificationAddress(), config.getUser(), config.getPassword(), null, !this.backup, this.server.getStorageManager());
        } else {
            TransportConfiguration connector = this.configuration.getConnectorConfigurations().get(connectorNamePair.a);
            if (connector == null) {
                log.warn("No connector defined with name '" + (String)connectorNamePair.a + "'. The bridge will not be deployed.");
                return;
            }
            TransportConfiguration backupConnector = null;
            if (connectorNamePair.b != null && (backupConnector = this.configuration.getConnectorConfigurations().get(connectorNamePair.b)) == null) {
                log.warn("No connector defined with name '" + (String)connectorNamePair.b + "'. The bridge will not be deployed.");
                return;
            }
            Pair<TransportConfiguration, Object> pair = new Pair<TransportConfiguration, Object>(connector, backupConnector);
            bridge = new BridgeImpl(this.nodeUUID, new SimpleString(config.getName()), queue, null, -1, pair, this.executorFactory.getExecutor(), SimpleString.toSimpleString(config.getFilterString()), new SimpleString(config.getForwardingAddress()), this.scheduledExecutor, transformer, config.getRetryInterval(), config.getRetryIntervalMultiplier(), config.getReconnectAttempts(), config.isFailoverOnServerShutdown(), config.isUseDuplicateDetection(), config.getConfirmationWindowSize(), this.managementService.getManagementAddress(), this.managementService.getManagementNotificationAddress(), this.server.getConfiguration().getClusterUser(), this.server.getConfiguration().getClusterPassword(), null, !this.backup, this.server.getStorageManager());
        }
        this.bridges.put(config.getName(), bridge);
        this.managementService.registerBridge(bridge, config);
        bridge.start();
    }

    private synchronized void deployClusterConnection(ClusterConnectionConfiguration config) throws Exception {
        ClusterConnectionImpl clusterConnection;
        if (config.getName() == null) {
            log.warn("Must specify a unique name for each cluster. This one will not be deployed.");
            return;
        }
        if (config.getAddress() == null) {
            log.warn("Must specify an address for each cluster connection. This one will not be deployed.");
            return;
        }
        ArrayList<Pair<TransportConfiguration, TransportConfiguration>> connectors = new ArrayList<Pair<TransportConfiguration, TransportConfiguration>>();
        if (config.getStaticConnectorNamePairs() != null) {
            for (Pair<String, String> connectorNamePair : config.getStaticConnectorNamePairs()) {
                TransportConfiguration connector = this.configuration.getConnectorConfigurations().get(connectorNamePair.a);
                if (connector == null) {
                    log.warn("No connector defined with name '" + (String)connectorNamePair.a + "'. The cluster connection will not be deployed.");
                    return;
                }
                TransportConfiguration backupConnector = null;
                if (connectorNamePair.b != null && (backupConnector = this.configuration.getConnectorConfigurations().get(connectorNamePair.b)) == null) {
                    log.warn("No connector defined with name '" + (String)connectorNamePair.b + "'. The cluster connection will not be deployed.");
                    return;
                }
                Pair<TransportConfiguration, Object> pair = new Pair<TransportConfiguration, Object>(connector, backupConnector);
                connectors.add(pair);
            }
            clusterConnection = new ClusterConnectionImpl(new SimpleString(config.getName()), new SimpleString(config.getAddress()), config.getRetryInterval(), config.isDuplicateDetection(), config.isForwardWhenNoConsumers(), config.getConfirmationWindowSize(), this.executorFactory, this.server, this.postOffice, this.managementService, this.scheduledExecutor, connectors, config.getMaxHops(), this.nodeUUID, this.backup, this.server.getConfiguration().getClusterUser(), this.server.getConfiguration().getClusterPassword());
        } else {
            DiscoveryGroup dg = this.discoveryGroups.get(config.getDiscoveryGroupName());
            if (dg == null) {
                log.warn("No discovery group with name '" + config.getDiscoveryGroupName() + "'. The cluster connection will not be deployed.");
            }
            clusterConnection = new ClusterConnectionImpl(new SimpleString(config.getName()), new SimpleString(config.getAddress()), config.getRetryInterval(), config.isDuplicateDetection(), config.isForwardWhenNoConsumers(), config.getConfirmationWindowSize(), this.executorFactory, this.server, this.postOffice, this.managementService, this.scheduledExecutor, dg, config.getMaxHops(), this.nodeUUID, this.backup, this.server.getConfiguration().getClusterUser(), this.server.getConfiguration().getClusterPassword());
        }
        this.managementService.registerCluster(clusterConnection, config);
        this.clusters.put(config.getName(), clusterConnection);
        clusterConnection.start();
    }

    private Transformer instantiateTransformer(String transformerClassName) {
        Transformer transformer = null;
        if (transformerClassName != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clz = loader.loadClass(transformerClassName);
                transformer = (Transformer)clz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error instantiating transformer class \"" + transformerClassName + "\"", e);
            }
        }
        return transformer;
    }
}

