/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.impl.MessageImpl;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.impl.MessageReferenceImpl;
import org.hornetq.utils.MemorySize;

public class ServerMessageImpl
extends MessageImpl
implements ServerMessage {
    private static final Logger log = Logger.getLogger(ServerMessageImpl.class);
    private final AtomicInteger durableRefCount = new AtomicInteger(0);
    private final AtomicInteger refCount = new AtomicInteger(0);
    private PagingStore pagingStore;
    private static final int memoryOffset = MemorySize.is64bitArch() ? 352 : 232;
    private volatile int memoryEstimate = -1;

    public ServerMessageImpl() {
    }

    public ServerMessageImpl(long messageID, int initialMessageBufferSize) {
        super(initialMessageBufferSize);
        this.messageID = messageID;
    }

    protected ServerMessageImpl(int initialMessageBufferSize) {
        super(initialMessageBufferSize);
    }

    protected ServerMessageImpl(ServerMessageImpl other) {
        super(other);
    }

    public void setMessageID(long id) {
        this.messageID = id;
    }

    public MessageReference createReference(Queue queue) {
        MessageReferenceImpl ref = new MessageReferenceImpl(this, queue);
        return ref;
    }

    public int incrementRefCount(MessageReference reference) throws Exception {
        int count = this.refCount.incrementAndGet();
        if (this.pagingStore != null) {
            if (count == 1) {
                this.pagingStore.addSize(this, true);
            }
            this.pagingStore.addSize(reference, true);
        }
        return count;
    }

    public int decrementRefCount(MessageReference reference) throws Exception {
        int count = this.refCount.decrementAndGet();
        if (this.pagingStore != null) {
            if (count == 0) {
                this.pagingStore.addSize(this, false);
            }
            this.pagingStore.addSize(reference, false);
        }
        return count;
    }

    public int incrementDurableRefCount() {
        return this.durableRefCount.incrementAndGet();
    }

    public int decrementDurableRefCount() {
        return this.durableRefCount.decrementAndGet();
    }

    public int getRefCount() {
        return this.refCount.get();
    }

    public boolean isLargeMessage() {
        return false;
    }

    public int getMemoryEstimate() {
        if (this.memoryEstimate == -1) {
            this.memoryEstimate = memoryOffset + this.buffer.capacity() + this.properties.getMemoryOffset();
        }
        return this.memoryEstimate;
    }

    public ServerMessage copy(long newID) {
        ServerMessageImpl m = new ServerMessageImpl(this);
        m.setMessageID(newID);
        return m;
    }

    public ServerMessage copy() {
        return new ServerMessageImpl(this);
    }

    public ServerMessage makeCopyForExpiryOrDLA(long newID, boolean expiry) throws Exception {
        ServerMessage copy = this.copy(newID);
        copy.setOriginalHeaders(this, expiry);
        return copy;
    }

    public void setOriginalHeaders(ServerMessage other, boolean expiry) {
        if (other.containsProperty(Message.HDR_ORIG_MESSAGE_ID)) {
            this.putStringProperty(Message.HDR_ORIGINAL_ADDRESS, other.getSimpleStringProperty(Message.HDR_ORIGINAL_ADDRESS));
            this.putLongProperty(Message.HDR_ORIG_MESSAGE_ID, (long)other.getLongProperty(Message.HDR_ORIG_MESSAGE_ID));
        } else {
            SimpleString originalQueue = other.getAddress();
            this.putStringProperty(Message.HDR_ORIGINAL_ADDRESS, originalQueue);
            this.putLongProperty(Message.HDR_ORIG_MESSAGE_ID, other.getMessageID());
        }
        this.setExpiration(0L);
        if (expiry) {
            long actualExpiryTime = System.currentTimeMillis();
            this.putLongProperty(Message.HDR_ACTUAL_EXPIRY_TIME, actualExpiryTime);
        }
        this.bufferValid = false;
    }

    public void setPagingStore(PagingStore pagingStore) {
        this.pagingStore = pagingStore;
        this.address = pagingStore.getAddress();
    }

    public PagingStore getPagingStore() {
        return this.pagingStore;
    }

    public boolean page(boolean duplicateDetection) throws Exception {
        if (this.pagingStore != null) {
            return this.pagingStore.page(this, duplicateDetection);
        }
        return false;
    }

    public boolean page(long transactionID, boolean duplicateDetection) throws Exception {
        if (this.pagingStore != null) {
            return this.pagingStore.page(this, transactionID, duplicateDetection);
        }
        return false;
    }

    public boolean storeIsPaging() {
        if (this.pagingStore != null) {
            return this.pagingStore.isPaging();
        }
        return false;
    }

    public String toString() {
        return "ServerMessage[messageID=" + this.messageID + ", durable=" + this.durable + ", address=" + this.getAddress() + "]";
    }

    public InputStream getBodyInputStream() {
        return null;
    }

    public void encodeMessageIDToBuffer() {
        this.buffer.setLong(this.buffer.getInt(13) + 4, this.messageID);
    }
}

