/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

public final class UUID {
    private static final String kHexChars = "0123456789abcdefABCDEF";
    public static final byte INDEX_CLOCK_HI = 6;
    public static final byte INDEX_CLOCK_MID = 4;
    public static final byte INDEX_CLOCK_LO = 0;
    public static final byte INDEX_TYPE = 6;
    public static final byte INDEX_CLOCK_SEQUENCE = 8;
    public static final byte INDEX_VARIATION = 8;
    public static final byte TYPE_NULL = 0;
    public static final byte TYPE_TIME_BASED = 1;
    public static final byte TYPE_DCE = 2;
    public static final byte TYPE_NAME_BASED = 3;
    public static final byte TYPE_RANDOM_BASED = 4;
    public static final String NAMESPACE_DNS = "6ba7b810-9dad-11d1-80b4-00c04fd430c8";
    public static final String NAMESPACE_URL = "6ba7b811-9dad-11d1-80b4-00c04fd430c8";
    public static final String NAMESPACE_OID = "6ba7b812-9dad-11d1-80b4-00c04fd430c8";
    public static final String NAMESPACE_X500 = "6ba7b814-9dad-11d1-80b4-00c04fd430c8";
    private static boolean sDescCaching = true;
    private final byte[] mId = new byte[16];
    private transient String mDesc = null;
    private transient int mHashCode = 0;
    private static final int[] kShifts = new int[]{3, 7, 17, 21, 29, 4, 9};

    public UUID(int type, byte[] data) {
        for (int i = 0; i < 16; ++i) {
            this.mId[i] = data[i];
        }
        this.mId[6] = (byte)(this.mId[6] & 0xF);
        this.mId[6] = (byte)(this.mId[6] | (byte)(type << 4));
        this.mId[8] = (byte)(this.mId[8] & 0x3F);
        this.mId[8] = (byte)(this.mId[8] | 0xFFFFFF80);
    }

    public final byte[] asBytes() {
        return this.mId;
    }

    public final int hashCode() {
        if (this.mHashCode == 0) {
            int result = this.mId[0] & 0xFF;
            result |= result << 16;
            result |= result << 8;
            for (int i = 1; i < 15; i += 2) {
                int curr = (this.mId[i] & 0xFF) << 8 | this.mId[i + 1] & 0xFF;
                int shift = kShifts[i >> 1];
                if (shift > 16) {
                    result ^= curr << shift | curr >>> 32 - shift;
                    continue;
                }
                result ^= curr << shift;
            }
            int last = this.mId[15] & 0xFF;
            result ^= last << 3;
            result ^= last << 13;
            this.mHashCode = (result ^= last << 27) == 0 ? -1 : result;
        }
        return this.mHashCode;
    }

    public final String toString() {
        if (this.mDesc == null) {
            StringBuffer b = new StringBuffer(36);
            for (int i = 0; i < 16; ++i) {
                switch (i) {
                    case 4: 
                    case 6: 
                    case 8: 
                    case 10: {
                        b.append('-');
                    }
                }
                int hex = this.mId[i] & 0xFF;
                b.append(kHexChars.charAt(hex >> 4));
                b.append(kHexChars.charAt(hex & 0xF));
            }
            if (!sDescCaching) {
                return b.toString();
            }
            this.mDesc = b.toString();
        }
        return this.mDesc;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof UUID)) {
            return false;
        }
        byte[] otherId = ((UUID)o).mId;
        byte[] thisId = this.mId;
        for (int i = 0; i < 16; ++i) {
            if (otherId[i] == thisId[i]) continue;
            return false;
        }
        return true;
    }
}

