/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.map;

import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionSynchronization;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.info.WorkItemInfo;
import org.drools.persistence.map.KnowledgeSessionStorage;
import org.drools.persistence.map.NonTransactionalPersistentSession;

public class ManualTransactionManager
implements TransactionManager {
    private NonTransactionalPersistentSession session;
    private KnowledgeSessionStorage storage;
    private TransactionSynchronization transactionSynchronization;

    public ManualTransactionManager(NonTransactionalPersistentSession session, KnowledgeSessionStorage storage) {
        this.session = session;
        this.storage = storage;
    }

    public int getStatus() {
        return 0;
    }

    public void begin() {
    }

    public void commit() {
        try {
            for (SessionInfo sessionInfo : this.session.getStoredKnowledgeSessions()) {
                sessionInfo.update();
                this.storage.saveOrUpdate(sessionInfo);
            }
            for (WorkItemInfo workItemInfo : this.session.getStoredWorkItems()) {
                workItemInfo.update();
                this.storage.saveOrUpdate(workItemInfo);
            }
            try {
                this.transactionSynchronization.afterCompletion(0);
            }
            catch (RuntimeException re) {}
        }
        catch (RuntimeException re) {
            this.transactionSynchronization.afterCompletion(1);
        }
    }

    public void rollback() {
    }

    public void registerTransactionSynchronization(TransactionSynchronization ts) {
        this.transactionSynchronization = ts;
    }
}

