/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import java.io.IOException;
import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.codegen.Target;
import org.antlr.misc.Utils;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.tool.Grammar;

public class ObjCTarget
extends Target {
    protected void genRecognizerHeaderFile(Tool tool, CodeGenerator generator, Grammar grammar, StringTemplate headerFileST, String extName) throws IOException {
        generator.write(headerFileST, grammar.name + Grammar.grammarTypeToFileNameSuffix[grammar.type] + extName);
    }

    public String getTargetCharLiteralFromANTLRCharLiteral(CodeGenerator generator, String literal) {
        if (literal.startsWith("'\\u")) {
            literal = "0x" + literal.substring(3, 7);
        } else {
            char c = literal.charAt(1);
            if (c < ' ' || c > '\u007f') {
                literal = "0x" + Integer.toHexString(c);
            }
        }
        return literal;
    }

    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator generator, String literal) {
        literal = Utils.replace(literal, "\"", "\\\"");
        StringBuffer buf = new StringBuffer(literal);
        buf.setCharAt(0, '\"');
        buf.setCharAt(literal.length() - 1, '\"');
        buf.insert(0, '@');
        return buf.toString();
    }

    public String getTokenTypeAsTargetLabel(CodeGenerator generator, int ttype) {
        String name = generator.grammar.getTokenDisplayName(ttype);
        if (name.charAt(0) == '\'') {
            return String.valueOf(ttype);
        }
        return name;
    }

    public String getTokenTextAndTypeAsTargetLabel(CodeGenerator generator, String text, int tokenType) {
        String textEquivalent;
        String name = generator.grammar.getTokenDisplayName(tokenType);
        if (name.charAt(0) == '\'') {
            return String.valueOf(tokenType);
        }
        String string = textEquivalent = text == null ? name : text;
        if (textEquivalent.charAt(0) >= '0' && textEquivalent.charAt(0) <= '9') {
            return textEquivalent;
        }
        return generator.grammar.name + Grammar.grammarTypeToFileNameSuffix[generator.grammar.type] + "_" + textEquivalent;
    }
}

