/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.finder.filters;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class PathFilter
extends WildcardFileFilter {
    private IOCase caseSensitivity;
    private String wildcard;

    public PathFilter(String wildcardmatcher, boolean ignoreCase) {
        super(wildcardmatcher, ignoreCase ? IOCase.INSENSITIVE : IOCase.SENSITIVE);
        this.caseSensitivity = ignoreCase ? IOCase.INSENSITIVE : IOCase.SENSITIVE;
        this.wildcard = wildcardmatcher;
    }

    public boolean accept(File dir, String name) {
        String path = new File(dir, name).toString();
        return FilenameUtils.wildcardMatch((String)path, (String)this.wildcard, (IOCase)this.caseSensitivity);
    }

    public boolean accept(File file) {
        String name = file.getPath();
        return FilenameUtils.wildcardMatch((String)name, (String)this.wildcard, (IOCase)this.caseSensitivity);
    }
}

