/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.util;

import java.util.Collection;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class FillUtil {
    public static ColorDefinition getDarkerColor(Fill fill) {
        if (fill instanceof ColorDefinition) {
            return ((ColorDefinition)fill).darker();
        }
        if (fill instanceof Gradient) {
            ColorDefinition cdStart = ((Gradient)fill).getStartColor();
            ColorDefinition cdEnd = ((Gradient)fill).getEndColor();
            return FillUtil.getSortedColors(false, cdStart, cdEnd).darker();
        }
        if (fill instanceof Image) {
            return ColorDefinitionImpl.create(128, 128, 128);
        }
        if (fill instanceof MultipleFill) {
            EList fills = ((MultipleFill)fill).getFills();
            ColorDefinition cd0 = (ColorDefinition)fills.get(0);
            ColorDefinition cd1 = (ColorDefinition)fills.get(1);
            return FillUtil.getSortedColors(false, cd0, cd1).darker();
        }
        return null;
    }

    public static Fill getDarkerFill(Fill fill) {
        if (fill instanceof Image) {
            return fill;
        }
        return FillUtil.getDarkerColor(fill);
    }

    public static ColorDefinition getBrighterColor(Fill fill) {
        if (fill instanceof ColorDefinition) {
            return ((ColorDefinition)fill).brighter();
        }
        if (fill instanceof Gradient) {
            ColorDefinition cdStart = ((Gradient)fill).getStartColor();
            ColorDefinition cdEnd = ((Gradient)fill).getEndColor();
            return FillUtil.getSortedColors(true, cdStart, cdEnd).brighter();
        }
        if (fill instanceof Image) {
            return ColorDefinitionImpl.create(192, 192, 192);
        }
        if (fill instanceof MultipleFill) {
            EList fills = ((MultipleFill)fill).getFills();
            ColorDefinition cd0 = (ColorDefinition)fills.get(0);
            ColorDefinition cd1 = (ColorDefinition)fills.get(1);
            return FillUtil.getSortedColors(true, cd0, cd1).brighter();
        }
        return null;
    }

    public static Fill changeBrightness(Fill fill, double brightness) {
        if (fill instanceof ColorDefinition) {
            ColorDefinition new_fill = ColorDefinitionImpl.copyInstance((ColorDefinition)fill);
            new_fill.eAdapters().addAll((Collection)fill.eAdapters());
            FillUtil.applyBrightness(new_fill, brightness);
            return new_fill;
        }
        return fill;
    }

    public static Fill getBrighterFill(Fill fill) {
        if (fill instanceof Image) {
            return fill;
        }
        return FillUtil.getBrighterColor(fill);
    }

    static ColorDefinition getSortedColors(boolean bBrighter, ColorDefinition cd1, ColorDefinition cd2) {
        int result = cd1.getRed() + cd1.getGreen() + cd1.getBlue() - (cd2.getRed() + cd2.getGreen() + cd2.getBlue());
        if (bBrighter) {
            return result > 0 ? cd1 : cd2;
        }
        return result > 0 ? cd2 : cd1;
    }

    public static Fill convertFillToGradient(Fill fill, boolean bTransposed) {
        Gradient grad = null;
        if (fill instanceof ColorDefinition) {
            grad = FillUtil.createDefaultGradient((ColorDefinition)fill);
        } else if (fill instanceof MultipleFill) {
            EList fills = ((MultipleFill)fill).getFills();
            grad = FillUtil.createDefaultGradient((ColorDefinition)fills.get(0));
        } else if (fill instanceof Gradient) {
            grad = (Gradient)fill;
        }
        if (grad != null) {
            if (bTransposed && !grad.isSetDirection()) {
                grad.setDirection(90.0);
            }
            return grad;
        }
        return fill;
    }

    private static void applyBrightness(ColorDefinition cdf, double brightness) {
        cdf.set((int)((double)cdf.getRed() * brightness), (int)((double)cdf.getGreen() * brightness), (int)((double)cdf.getBlue() * brightness), cdf.getTransparency());
    }

    public static Fill convertFillToGradient3D(Fill fill, boolean bTransposed) {
        if (fill instanceof ColorDefinition) {
            ColorDefinition color = (ColorDefinition)fill;
            if (color == null) {
                return null;
            }
            Gradient gradient = AttributeFactory.eINSTANCE.createGradient();
            ColorDefinition newStartColor = (ColorDefinition)FillUtil.changeBrightness(fill, 0.95);
            gradient.setStartColor(newStartColor);
            ColorDefinition newColor = (ColorDefinition)FillUtil.changeBrightness(fill, 0.65);
            gradient.setEndColor(newColor);
            return gradient;
        }
        return FillUtil.convertFillToGradient(fill, bTransposed);
    }

    public static Gradient createDefaultGradient(ColorDefinition color) {
        if (color == null) {
            return null;
        }
        Gradient gradient = AttributeFactory.eINSTANCE.createGradient();
        int currentLuminance = FillUtil.convertRGBToLuminance(color.getRed(), color.getGreen(), color.getBlue());
        if (currentLuminance < 200) {
            ColorDefinition newStartColor = (ColorDefinition)EcoreUtil.copy((EObject)color);
            newStartColor.eAdapters().addAll((Collection)color.eAdapters());
            gradient.setStartColor(newStartColor);
            ColorDefinition newColor = (ColorDefinition)EcoreUtil.copy((EObject)color);
            newColor.eAdapters().addAll((Collection)color.eAdapters());
            int lumDiff = 240 - currentLuminance;
            newColor.setRed(FillUtil.getNewColor(lumDiff, newColor.getRed(), 0.3));
            newColor.setGreen(FillUtil.getNewColor(lumDiff, newColor.getGreen(), 0.59));
            newColor.setBlue(FillUtil.getNewColor(lumDiff, newColor.getBlue(), 0.11));
            gradient.setEndColor(newColor);
        } else {
            ColorDefinition newEndColor = (ColorDefinition)EcoreUtil.copy((EObject)color);
            newEndColor.eAdapters().addAll((Collection)color.eAdapters());
            gradient.setEndColor(newEndColor);
            ColorDefinition newColor = (ColorDefinition)EcoreUtil.copy((EObject)color);
            newColor.eAdapters().addAll((Collection)color.eAdapters());
            int lumDiff = -100;
            newColor.setRed(FillUtil.getNewColor(lumDiff, newColor.getRed(), 0.3));
            newColor.setGreen(FillUtil.getNewColor(lumDiff, newColor.getGreen(), 0.59));
            newColor.setBlue(FillUtil.getNewColor(lumDiff, newColor.getBlue(), 0.11));
            gradient.setStartColor(newColor);
        }
        return gradient;
    }

    private static int convertRGBToLuminance(int red, int green, int blue) {
        return (int)(0.3 * (double)red + 0.59 * (double)green + 0.11 * (double)blue);
    }

    private static int getNewColor(int lumDiff, int oldColor, double coefficient) {
        int newColor = (int)((double)lumDiff * coefficient) + oldColor;
        if (newColor < 0) {
            return 0;
        }
        return newColor < 255 ? newColor : 255;
    }

    public static Fill copyOf(Fill src) {
        if (src instanceof ColorDefinition) {
            return ColorDefinitionImpl.copyInstance((ColorDefinition)src);
        }
        return (Fill)EcoreUtil.copy((EObject)src);
    }
}

