/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.slf4j.Marker;

public class BasicMarker
implements Marker {
    private static final long serialVersionUID = 1803952589649545191L;
    private final String name;
    private List children;
    private static String OPEN = "[ ";
    private static String CLOSE = " ]";
    private static String SEP = ", ";

    BasicMarker(String name) {
        if (name == null) {
            throw new IllegalArgumentException("A merker name cannot be null");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void add(Marker markerToAddAsChild) {
        if (markerToAddAsChild == null) {
            throw new IllegalArgumentException("A null value cannot be added to a Marker as child.");
        }
        if (this.contains(markerToAddAsChild)) {
            return;
        }
        if (markerToAddAsChild.contains(this)) {
            return;
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.add(markerToAddAsChild);
    }

    public synchronized boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public synchronized Iterator iterator() {
        if (this.children != null) {
            return this.children.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public synchronized boolean remove(Marker markerToRemove) {
        if (this.children == null) {
            return false;
        }
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            Marker m = (Marker)this.children.get(i);
            if (m != markerToRemove) continue;
            this.children.remove(i);
            return true;
        }
        return false;
    }

    public boolean contains(Marker other) {
        if (other == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this == other) {
            return true;
        }
        if (this.hasChildren()) {
            for (int i = 0; i < this.children.size(); ++i) {
                Marker child = (Marker)this.children.get(i);
                if (!child.contains(other)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this.name.equals(name)) {
            return true;
        }
        if (this.hasChildren()) {
            for (int i = 0; i < this.children.size(); ++i) {
                Marker child = (Marker)this.children.get(i);
                if (!child.contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Marker)) {
            return false;
        }
        Marker other = (Marker)obj;
        return this.name.equals(other.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        if (!this.hasChildren()) {
            return this.getName();
        }
        Iterator it = this.iterator();
        StringBuffer sb = new StringBuffer(this.getName());
        sb.append(' ').append(OPEN);
        while (it.hasNext()) {
            Marker child = (Marker)it.next();
            sb.append(child.getName());
            if (!it.hasNext()) continue;
            sb.append(SEP);
        }
        sb.append(CLOSE);
        return sb.toString();
    }
}

