/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JMXServerConfig {
    private MBeanServer mbeanServer = JMXServerConfig.getDefaultMBeanServer();

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public File getServerTempDir() {
        try {
            ObjectName oname = ObjectNameFactory.create("jboss.system:type=ServerConfig");
            File dir = (File)this.getMbeanServer().getAttribute(oname, "ServerTempDir");
            return dir;
        }
        catch (JMException e) {
            return null;
        }
    }

    public File getHomeDir() {
        try {
            ObjectName oname = ObjectNameFactory.create("jboss.system:type=ServerConfig");
            File dir = (File)this.getMbeanServer().getAttribute(oname, "HomeDir");
            return dir;
        }
        catch (JMException e) {
            return null;
        }
    }

    public File getServerDataDir() {
        try {
            ObjectName oname = ObjectNameFactory.create("jboss.system:type=ServerConfig");
            File dir = (File)this.getMbeanServer().getAttribute(oname, "ServerDataDir");
            return dir;
        }
        catch (JMException e) {
            return null;
        }
    }

    public static MBeanServer getDefaultMBeanServer() {
        return JMXServerConfig.findMBeanServer("jboss");
    }

    private static MBeanServer findMBeanServer(String agentId) {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers != null && servers.size() > 0) {
            for (Object e : servers) {
                MBeanServer server = (MBeanServer)e;
                if (!server.getDefaultDomain().equals(agentId)) continue;
                return server;
            }
        }
        return null;
    }

    public static class ObjectNameFactory {
        public static ObjectName create(String name) {
            try {
                return new ObjectName(name);
            }
            catch (MalformedObjectNameException e) {
                throw new Error("Invalid ObjectName: " + name + "; " + e);
            }
        }

        public static ObjectName create(String domain, String key, String value) {
            try {
                return new ObjectName(domain, key, value);
            }
            catch (MalformedObjectNameException e) {
                throw new Error("Invalid ObjectName: " + domain + "," + key + "," + value + "; " + e);
            }
        }

        public static ObjectName create(String domain, Hashtable table) {
            try {
                return new ObjectName(domain, table);
            }
            catch (MalformedObjectNameException e) {
                throw new Error("Invalid ObjectName: " + domain + "," + table + "; " + e);
            }
        }
    }
}

