/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUtil {
    private static String DEFAULT_PREFIX = "Res";
    protected static Logger logger = Logger.getLogger(FileUtil.class.getName());
    private static HashMap fileExtension = new HashMap();
    private static HashMap mimeType = new HashMap();

    static {
        fileExtension.put("image/bmp", ".bmp");
        fileExtension.put("image/gif", ".gif");
        fileExtension.put("image/jpeg", ".jpg");
        fileExtension.put("image/pcx", ".pcx");
        fileExtension.put("image/png", ".png");
        fileExtension.put("image/x-png", ".png");
        fileExtension.put("image/tif", ".tif");
        fileExtension.put("image/svg+xml", ".svg");
        mimeType.put(".bmp", "image/bmp");
        mimeType.put(".gif", "image/gif");
        mimeType.put(".jpg", "image/jpeg");
        mimeType.put(".pcx", "image/pcx");
        mimeType.put(".png", "image/png");
        mimeType.put(".png", "image/x-png");
        mimeType.put(".tif", "image/tif");
        mimeType.put(".svg", "image/svg+xml");
    }

    public static File createTempFile(String prefix, String suffix, String path) {
        File dir;
        assert (path != null);
        if (prefix == null || prefix.length() < 3) {
            prefix = DEFAULT_PREFIX;
        }
        if (!(dir = new File(path)).exists() && !dir.mkdirs()) {
            logger.log(Level.SEVERE, "[FileUtil] Cannot create directory.");
            return null;
        }
        try {
            File newFile = File.createTempFile(prefix, suffix, dir);
            return newFile;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static boolean copyFile(String srcUri, File tgtFile) {
        assert (srcUri != null && tgtFile != null);
        try {
            FileOutputStream fos = new FileOutputStream(tgtFile);
            URL srcUrl = new URL(srcUri);
            InputStream is = srcUrl.openStream();
            byte[] buffer = new byte[1024];
            while (is.read(buffer) > 0) {
                fos.write(buffer);
            }
            is.close();
            fos.close();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    public static String getExtFromFileName(String fileName) {
        String extName;
        int lastIndex;
        if (fileName != null && (lastIndex = fileName.lastIndexOf(46)) != -1 && (extName = fileName.substring(lastIndex)).indexOf(47) == -1 && extName.indexOf(92) == -1) {
            return extName;
        }
        return null;
    }

    public static boolean isLocalResource(String uri) {
        return uri != null && uri.length() > 0 && !uri.toLowerCase().startsWith("http");
    }

    public static String getAbsolutePath(String path, String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            file = new File(path, fileName);
        }
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public static String getURI(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return null;
        }
        File file = new File(fileName);
        if (file.exists() && file.length() > 0L) {
            return file.toURI().toString();
        }
        return null;
    }

    public static boolean saveFile(File targetFile, byte[] data) {
        if (targetFile == null) {
            return false;
        }
        try {
            FileOutputStream out = new FileOutputStream(targetFile);
            out.write(data);
            out.close();
            return true;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    public static String getExtFromType(String fileType) {
        return (String)fileExtension.get(fileType);
    }

    public static String getTypeFromExt(String imgExt) {
        return (String)mimeType.get(imgExt);
    }

    public static boolean isRelativePath(String fileName) {
        if (fileName == null || fileName.indexOf(58) > 0 || fileName.startsWith("\\\\")) {
            return false;
        }
        if (File.separatorChar == '/') {
            return !fileName.startsWith(File.separator);
        }
        if (File.separatorChar == '\\') {
            File file = new File(fileName);
            return !file.isAbsolute();
        }
        return false;
    }

    public static byte[] getFileContent(String fileName) {
        if (fileName == null) {
            return null;
        }
        try {
            int len;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileName));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot get the content of the file " + fileName, e);
            return null;
        }
    }

    public static void deleteDir(File file) {
        if (file.isDirectory()) {
            String[] list = file.list();
            int i = 0;
            while (i < list.length) {
                File f = new File(file, list[i]);
                FileUtil.deleteDir(f);
                ++i;
            }
            file.delete();
        }
        file.delete();
    }

    public static String getJavaTmpDir() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.io.tmpdir");
            }
        });
    }
}

