/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.elements.structures.IncludeScript;
import org.eclipse.birt.report.model.api.validators.MasterPageRequiredValidator;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetAdapter;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.elements.interfaces.IReportDesignModel;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.writer.DesignWriter;
import org.eclipse.birt.report.model.writer.ModuleWriter;

public class ReportDesign
extends Module
implements IReportDesignModel,
ICssStyleSheetOperation {
    private ICssStyleSheetOperation operation = null;

    public ReportDesign() {
        super((DesignSession)null);
        this.initSlots();
        this.onCreate();
    }

    public ReportDesign(DesignSession session) {
        super(session);
        this.initSlots();
        this.onCreate();
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitReportDesign(this);
    }

    public List validate(Module module) {
        List list = super.validate(module);
        list.addAll(MasterPageRequiredValidator.getInstance().validate(this, this));
        list.addAll(this.validateStructureList(module, "images"));
        list.addAll(this.validateStructureList(module, "colorPalette"));
        list.addAll(this.validateStructureList(module, "includeScripts"));
        list.addAll(this.validateStructureList(module, "libraries"));
        list.addAll(this.validateStructureList(module, "propertyBindings"));
        return list;
    }

    public String getElementName() {
        return "ReportDesign";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle();
    }

    public ReportDesignHandle handle() {
        if (this.handle == null) {
            this.handle = new ReportDesignHandle(this);
        }
        return (ReportDesignHandle)this.handle;
    }

    public IncludeScript findIncludeScript(String fileName) {
        ArrayList list = (ArrayList)this.getLocalProperty(null, "includeScripts");
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.size()) {
            IncludeScript script = (IncludeScript)list.get(i);
            if (script.getFileName() != null && script.getFileName().equals(fileName)) {
                return script;
            }
            ++i;
        }
        return null;
    }

    protected int getSlotCount() {
        return 10;
    }

    public ModuleWriter getWriter() {
        return new DesignWriter(this);
    }

    public List collectPropValues(int slotId, String propName) {
        ArrayList<Object> rtnList = new ArrayList<Object>();
        ContentIterator contents = new ContentIterator((Module)this, new ContainerContext((DesignElement)this, slotId));
        while (contents.hasNext()) {
            DesignElement ele = (DesignElement)contents.next();
            Object obj = ele.getProperty((Module)this, propName);
            if (obj == null) continue;
            rtnList.add(obj);
        }
        return rtnList;
    }

    public byte[] getThumbnail() {
        String data = this.getStringProperty(this, "thumbnail");
        if (data == null) {
            return null;
        }
        try {
            return data.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            return null;
        }
    }

    public ModuleOption getOptions() {
        return this.options;
    }

    public int dropCss(CssStyleSheet css) {
        if (this.operation == null) {
            return -1;
        }
        return this.operation.dropCss(css);
    }

    public void addCss(CssStyleSheet css) {
        if (this.operation == null) {
            this.operation = new CssStyleSheetAdapter();
        }
        this.operation.addCss(css);
    }

    public void insertCss(CssStyleSheet css, int index) {
        if (this.operation == null) {
            this.operation = new CssStyleSheetAdapter();
        }
        this.operation.insertCss(css, index);
    }

    public List getCsses() {
        if (this.operation == null) {
            return Collections.EMPTY_LIST;
        }
        return this.operation.getCsses();
    }
}

