/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class ChoicePropertyType
extends PropertyType {
    private static Logger logger = Logger.getLogger(ChoicePropertyType.class.getName());
    private static final String DISPLAY_NAME_KEY = "Property.choice";

    public ChoicePropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public Object validateValue(Module module, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            logger.log(Level.FINE, "Input choice property object is null");
            return null;
        }
        if (value instanceof String) {
            return this.validateInputString(module, defn, (String)value);
        }
        logger.log(Level.WARNING, "Invalid choice value type:" + value);
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", this.getTypeCode());
    }

    public Object validateXml(Module module, PropertyDefn defn, String value) throws PropertyValueException {
        if ((value = StringUtil.trimString(value)) == null) {
            logger.log(Level.FINE, "The choice value is null or blank");
            return null;
        }
        IChoiceSet allowedChoices = defn.getAllowedChoices();
        assert (allowedChoices != null);
        IChoice choice = allowedChoices.findChoice(value);
        if (choice != null) {
            logger.log(Level.FINE, "return internal name for choice " + value);
            return choice.getName();
        }
        IChoiceSet propChoices = defn.getChoices();
        if (propChoices.contains(value)) {
            logger.log(Level.WARNING, "Not allowed choice " + value);
            throw new PropertyValueException((Object)value, "Error.PropertyValueException.CHOICE_NOT_ALLOWED", this.getTypeCode());
        }
        logger.log(Level.WARNING, "Not found choice: " + value);
        throw new PropertyValueException((Object)value, "Error.PropertyValueException.CHOICE_NOT_FOUND", this.getTypeCode());
    }

    public int getTypeCode() {
        return 5;
    }

    public String getName() {
        return "choice";
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        IChoiceSet propChoices = defn.getChoices();
        assert (propChoices != null);
        if (value == null) {
            return null;
        }
        IChoice choice = propChoices.findChoice((String)value);
        if (choice != null) {
            return choice.getName();
        }
        return value.toString();
    }

    public String toDisplayString(Module module, PropertyDefn defn, Object name) {
        if (name == null) {
            return null;
        }
        IChoiceSet propChoices = defn.getChoices();
        assert (propChoices != null);
        IChoice choice = propChoices.findChoice(name.toString());
        if (choice != null) {
            logger.log(Level.FINE, "Returns a localized choice display name according to its internal name.");
            return choice.getDisplayName();
        }
        assert (false);
        return null;
    }

    public Object validateInputString(Module module, PropertyDefn defn, String name) throws PropertyValueException {
        if ((name = StringUtil.trimString(name)) == null) {
            logger.log(Level.FINE, "The choice name is null.");
            return null;
        }
        IChoiceSet allowedChoices = defn.getAllowedChoices();
        assert (allowedChoices != null);
        IChoice choice = allowedChoices.findChoice(name);
        if (choice != null) {
            logger.log(Level.FINE, "Return internal name of the choice " + name);
            return choice.getName();
        }
        choice = null;
        choice = !allowedChoices.isUserDefined() ? allowedChoices.findChoiceByDisplayName(name) : allowedChoices.findUserChoiceByDisplayName(module, name);
        if (choice != null) {
            logger.log(Level.FINE, "Return the internal name of the choice " + name);
            return choice.getName();
        }
        IChoiceSet propChoices = defn.getChoices();
        if (propChoices.contains(name)) {
            logger.log(Level.WARNING, "Not allowed choice " + name);
            throw new PropertyValueException((Object)name, "Error.PropertyValueException.CHOICE_NOT_ALLOWED", this.getTypeCode());
        }
        logger.log(Level.WARNING, "Invalid choice:" + name);
        throw new PropertyValueException((Object)name, "Error.PropertyValueException.CHOICE_NOT_FOUND", this.getTypeCode());
    }
}

