/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.Preconditions;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JsonSerializerExceptionWrapper<T>
implements JsonSerializer<T> {
    private final JsonSerializer<T> delegate;

    JsonSerializerExceptionWrapper(JsonSerializer<T> delegate) {
        Preconditions.checkNotNull(delegate);
        this.delegate = delegate;
    }

    @Override
    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        try {
            return this.delegate.serialize(src, typeOfSrc, context);
        }
        catch (JsonParseException e) {
            throw e;
        }
        catch (Exception e) {
            StringBuilder errorMsg = new StringBuilder().append("The JsonSerializer ").append(this.delegate).append(" failed to serialized object ").append(src).append(" given the type ").append(typeOfSrc);
            throw new JsonParseException(errorMsg.toString(), e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

