/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonElementVisitor;
import com.google.gson.JsonObject;
import java.util.Map;

final class JsonTreeNavigator {
    private final JsonElementVisitor visitor;
    private final boolean visitNulls;

    JsonTreeNavigator(JsonElementVisitor visitor, boolean visitNulls) {
        this.visitor = visitor;
        this.visitNulls = visitNulls;
    }

    public void navigate(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            this.visitor.visitNull();
        } else if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            this.visitor.startArray(array);
            boolean isFirst = true;
            for (JsonElement child : array) {
                this.visitChild(array, child, isFirst);
                if (!isFirst) continue;
                isFirst = false;
            }
            this.visitor.endArray(array);
        } else if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            this.visitor.startObject(object);
            boolean isFirst = true;
            for (Map.Entry<String, JsonElement> member : object.entrySet()) {
                this.visitChild(object, member.getKey(), member.getValue(), isFirst);
                if (!isFirst) continue;
                isFirst = false;
            }
            this.visitor.endObject(object);
        } else {
            this.visitor.visitPrimitive(element.getAsJsonPrimitive());
        }
    }

    private void visitChild(JsonObject parent, String childName, JsonElement child, boolean isFirst) {
        if (child != null) {
            if (child.isJsonNull()) {
                if (this.visitNulls) {
                    this.visitor.visitNullObjectMember(parent, childName, isFirst);
                    this.navigate(child.getAsJsonNull());
                }
            } else if (child.isJsonArray()) {
                JsonArray childAsArray = child.getAsJsonArray();
                this.visitor.visitObjectMember(parent, childName, childAsArray, isFirst);
                this.navigate(childAsArray);
            } else if (child.isJsonObject()) {
                JsonObject childAsObject = child.getAsJsonObject();
                this.visitor.visitObjectMember(parent, childName, childAsObject, isFirst);
                this.navigate(childAsObject);
            } else {
                this.visitor.visitObjectMember(parent, childName, child.getAsJsonPrimitive(), isFirst);
            }
        }
    }

    private void visitChild(JsonArray parent, JsonElement child, boolean isFirst) {
        if (child == null || child.isJsonNull()) {
            this.visitor.visitNullArrayMember(parent, isFirst);
            this.navigate(null);
        } else if (child.isJsonArray()) {
            JsonArray childAsArray = child.getAsJsonArray();
            this.visitor.visitArrayMember(parent, childAsArray, isFirst);
            this.navigate(childAsArray);
        } else if (child.isJsonObject()) {
            JsonObject childAsObject = child.getAsJsonObject();
            this.visitor.visitArrayMember(parent, childAsObject, isFirst);
            this.navigate(childAsObject);
        } else {
            this.visitor.visitArrayMember(parent, child.getAsJsonPrimitive(), isFirst);
        }
    }
}

