/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonParseException;
import com.google.gson.Primitives;
import com.google.gson.TypeAdapter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrimitiveTypeAdapter
implements TypeAdapter {
    PrimitiveTypeAdapter() {
    }

    @Override
    public <T> T adaptType(Object from, Class<T> to) {
        Class<T> aClass = Primitives.wrap(to);
        if (Primitives.isWrapperType(aClass)) {
            if (aClass == Character.class) {
                String value = from.toString();
                if (value.length() == 1) {
                    return (T)Character.valueOf(from.toString().charAt(0));
                }
                throw new JsonParseException("The value: " + value + " contains more than a character.");
            }
            try {
                Constructor<T> constructor = aClass.getConstructor(String.class);
                return constructor.newInstance(from.toString());
            }
            catch (NoSuchMethodException e) {
                throw new JsonParseException(e);
            }
            catch (IllegalAccessException e) {
                throw new JsonParseException(e);
            }
            catch (InvocationTargetException e) {
                throw new JsonParseException(e);
            }
            catch (InstantiationException e) {
                throw new JsonParseException(e);
            }
        }
        if (Enum.class.isAssignableFrom(to)) {
            try {
                Method valuesMethod = to.getMethod("valueOf", String.class);
                return (T)valuesMethod.invoke(null, from.toString());
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new JsonParseException("Can not adapt type " + from.getClass() + " to " + to);
    }
}

