/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.AbstractMutable;
import org.jboss.seam.core.Manager;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.persistence.PersistenceContextManager;
import org.jboss.seam.persistence.PersistenceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.persistence.persistenceContexts")
@Scope(value=ScopeType.CONVERSATION)
@BypassInterceptors
@Install(precedence=0)
public class PersistenceContexts
extends AbstractMutable
implements Serializable {
    private static final long serialVersionUID = -4897350516435283182L;
    private static final LogProvider log = Logging.getLogProvider(PersistenceContexts.class);
    private Set<String> set = new HashSet<String>();
    private FlushModeType flushMode;
    private FlushModeType realFlushMode;

    @Create
    public void create() {
        FlushModeType defaultFlushMode = Manager.instance().getDefaultFlushMode();
        this.flushMode = defaultFlushMode != null ? defaultFlushMode : FlushModeType.AUTO;
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public Set<String> getTouchedContexts() {
        return Collections.unmodifiableSet(this.set);
    }

    public void touch(String context) {
        if (this.set.add(context)) {
            this.setDirty();
        }
    }

    public void untouch(String context) {
        if (this.set.remove(context)) {
            this.setDirty();
        }
    }

    public static PersistenceContexts instance() {
        if (Contexts.isConversationContextActive()) {
            return (PersistenceContexts)Component.getInstance(PersistenceContexts.class);
        }
        return null;
    }

    public void changeFlushMode(FlushModeType flushMode) {
        this.changeFlushMode(flushMode, false);
    }

    public void changeFlushMode(FlushModeType flushMode, boolean temporary) {
        if (temporary) {
            this.realFlushMode = this.flushMode;
        }
        this.flushMode = flushMode;
        this.changeFlushModes();
    }

    public void restoreFlushMode() {
        if (this.realFlushMode != null && this.realFlushMode != this.flushMode) {
            this.flushMode = this.realFlushMode;
            this.realFlushMode = null;
            this.changeFlushModes();
        }
    }

    private void changeFlushModes() {
        for (String name : this.set) {
            PersistenceContextManager pcm = (PersistenceContextManager)Contexts.getConversationContext().get(name);
            if (pcm == null) continue;
            try {
                pcm.changeFlushMode(this.flushMode);
            }
            catch (UnsupportedOperationException uoe) {
                log.warn(uoe.getMessage());
            }
        }
    }

    public void beforeRender() {
        PersistenceProvider.instance().setRenderFlushMode();
    }

    public void afterRender() {
        this.restoreFlushMode();
    }
}

