/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.jms;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jbpm.task.service.BaseHandler;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.jms.BaseJMSHandler;
import org.jbpm.task.service.jms.JMSTaskClientHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSTaskClientConnector
implements TaskClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(JMSTaskClientConnector.class);
    protected QueueConnection connection;
    protected QueueSession session;
    protected Queue queue;
    protected Queue responseQueue;
    protected final BaseJMSHandler handler;
    protected final String name;
    protected AtomicInteger counter;
    private MessageProducer producer;
    private Properties connectionProperties;
    private Context context;
    private String selector;

    public JMSTaskClientConnector(String name, BaseJMSHandler handler, Properties connectionProperties, Context context) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        this.name = name;
        this.handler = handler;
        this.connectionProperties = connectionProperties;
        this.context = context;
        this.counter = new AtomicInteger();
    }

    public boolean connect(String address, int port) {
        return this.connect();
    }

    public boolean connect() {
        if (this.session != null) {
            return true;
        }
        try {
            String connFactoryName = this.connectionProperties.getProperty("JMSTaskClient.connectionFactory");
            String transactedQueueString = this.connectionProperties.getProperty("JMSTaskClient.transactedQueue");
            String acknowledgeModeString = this.connectionProperties.getProperty("JMSTaskClient.acknowledgeMode");
            String queueName = this.connectionProperties.getProperty("JMSTaskClient.queueName");
            String responseQueueName = this.connectionProperties.getProperty("JMSTaskClient.responseQueueName");
            boolean transactedQueue = Boolean.valueOf(transactedQueueString);
            int acknowledgeMode = 3;
            if ("AUTO_ACKNOWLEDGE".equals(acknowledgeModeString)) {
                acknowledgeMode = 1;
            } else if ("CLIENT_ACKNOWLEDGE".equals(acknowledgeModeString)) {
                acknowledgeMode = 2;
            }
            Context ctx = this.context;
            if (ctx == null) {
                ctx = new InitialContext();
            }
            QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup(connFactoryName);
            this.connection = factory.createQueueConnection();
            this.session = this.connection.createQueueSession(transactedQueue, acknowledgeMode);
            this.queue = this.session.createQueue(queueName);
            this.responseQueue = this.session.createQueue(responseQueueName);
            this.producer = this.session.createProducer((Destination)this.queue);
            this.connection.start();
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    private Object readMessage(ObjectMessage serverMessage) throws JMSException {
        return serverMessage.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (Exception e) {
            }
            finally {
                this.producer = null;
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception e) {
            }
            finally {
                this.session = null;
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.connection = null;
            }
        }
    }

    public void write(Object object) {
        try {
            ObjectMessage message = this.session.createObjectMessage();
            this.selector = UUID.randomUUID().toString();
            Thread responseThread = new Thread(new Responder(this.selector));
            responseThread.start();
            message.setStringProperty("taskClientId", this.selector);
            message.setObject((Serializable)object);
            this.producer.send((Message)message);
            this.session.commit();
        }
        catch (Throwable e) {
            throw new RuntimeException("Error creating message", e);
        }
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    public BaseHandler getHandler() {
        return this.handler;
    }

    public String getName() {
        return this.name;
    }

    protected class Responder
    implements Runnable {
        private final String selector;

        protected Responder(String selector) {
            this.selector = selector;
        }

        public void run() {
            MessageConsumer consumer = null;
            try {
                consumer = JMSTaskClientConnector.this.session.createConsumer((Destination)JMSTaskClientConnector.this.responseQueue, " taskClientId like '" + this.selector + "%' ");
                ObjectMessage serverMessage = (ObjectMessage)consumer.receive();
                if (serverMessage != null) {
                    ((JMSTaskClientHandler)JMSTaskClientConnector.this.handler).messageReceived((Session)JMSTaskClientConnector.this.session, JMSTaskClientConnector.this.readMessage(serverMessage), (Destination)JMSTaskClientConnector.this.responseQueue, this.selector);
                }
            }
            catch (JMSException e) {
                if (!"102".equals(e.getErrorCode())) {
                    throw new RuntimeException("No se pudo recibir respuesta JMS", e);
                }
                logger.info(e.getMessage());
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("Error inesperado recibiendo respuesta JMS", e);
            }
            finally {
                if (consumer != null) {
                    try {
                        consumer.close();
                    }
                    catch (Exception e) {
                        logger.info("No se pudo cerrar el consumer: " + e.getMessage());
                    }
                }
            }
        }
    }
}

