/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.client.impl.ClientConsumerInternal;
import org.hornetq.core.client.impl.ClientMessageInternal;
import org.hornetq.core.client.impl.LargeMessageBufferInternal;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.BodyEncoder;
import org.hornetq.core.message.impl.MessageImpl;

public class ClientMessageImpl
extends MessageImpl
implements ClientMessageInternal {
    private static final Logger log = Logger.getLogger(ClientMessageImpl.class);
    public static final SimpleString REPLYTO_HEADER_NAME = new SimpleString("JMSReplyTo");
    private int deliveryCount;
    private ClientConsumerInternal consumer;
    private boolean largeMessage;
    private int flowControlSize = -1;
    private InputStream bodyInputStream;

    public ClientMessageImpl() {
    }

    public ClientMessageImpl(byte type, boolean durable, long expiration, long timestamp, byte priority, int initialMessageBufferSize) {
        super(type, durable, expiration, timestamp, priority, initialMessageBufferSize);
    }

    public void onReceipt(ClientConsumerInternal consumer) {
        this.consumer = consumer;
    }

    public void setDeliveryCount(int deliveryCount) {
        this.deliveryCount = deliveryCount;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    public void acknowledge() throws HornetQException {
        if (this.consumer != null) {
            this.consumer.acknowledge(this);
        }
    }

    public int getFlowControlSize() {
        if (this.flowControlSize < 0) {
            throw new IllegalStateException("Flow Control hasn't been set");
        }
        return this.flowControlSize;
    }

    public void setFlowControlSize(int flowControlSize) {
        this.flowControlSize = flowControlSize;
    }

    public boolean isLargeMessage() {
        return this.largeMessage;
    }

    public void setLargeMessage(boolean largeMessage) {
        this.largeMessage = largeMessage;
    }

    public int getBodySize() {
        return this.buffer.writerIndex() - this.buffer.readerIndex();
    }

    public String toString() {
        return "ClientMessage[messageID=" + this.messageID + ", durable=" + this.durable + ", address=" + this.getAddress() + "]";
    }

    public void saveToOutputStream(OutputStream out) throws HornetQException {
        if (this.largeMessage) {
            ((LargeMessageBufferInternal)this.getWholeBuffer()).saveBuffer(out);
        } else {
            try {
                byte[] readBuffer = new byte[this.getBodySize()];
                this.getBodyBuffer().readBytes(readBuffer);
                out.write(readBuffer);
            }
            catch (IOException e) {
                throw new HornetQException(110, "Error saving the message body", e);
            }
        }
    }

    public void setOutputStream(OutputStream out) throws HornetQException {
        if (this.largeMessage) {
            ((LargeMessageBufferInternal)this.getWholeBuffer()).setOutputStream(out);
        } else {
            this.saveToOutputStream(out);
        }
    }

    public boolean waitOutputStreamCompletion(long timeMilliseconds) throws HornetQException {
        if (this.largeMessage) {
            return ((LargeMessageBufferInternal)this.getWholeBuffer()).waitCompletion(timeMilliseconds);
        }
        return true;
    }

    public void discardLargeBody() {
        if (this.largeMessage) {
            ((LargeMessageBufferInternal)this.getWholeBuffer()).discardUnusedPackets();
        }
    }

    public InputStream getBodyInputStream() {
        return this.bodyInputStream;
    }

    public void setBodyInputStream(InputStream bodyInputStream) {
        this.bodyInputStream = bodyInputStream;
    }

    public void setBuffer(HornetQBuffer buffer) {
        this.buffer = buffer;
        if (this.bodyBuffer != null) {
            this.bodyBuffer.setBuffer(buffer);
        }
    }

    public BodyEncoder getBodyEncoder() throws HornetQException {
        return new DecodingContext();
    }

    private final class DecodingContext
    implements BodyEncoder {
        public void open() {
        }

        public void close() {
        }

        public long getLargeBodySize() {
            return ClientMessageImpl.this.buffer.writerIndex();
        }

        public int encode(ByteBuffer bufferRead) throws HornetQException {
            HornetQBuffer buffer = HornetQBuffers.wrappedBuffer(bufferRead);
            return this.encode(buffer, bufferRead.capacity());
        }

        public int encode(HornetQBuffer bufferOut, int size) {
            byte[] bytes = new byte[size];
            ClientMessageImpl.this.getWholeBuffer().readBytes(bytes);
            bufferOut.writeBytes(bytes, 0, size);
            return size;
        }
    }
}

