/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.deployers.impl;

import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.impl.Validators;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.XmlDeployer;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressSettingsDeployer
extends XmlDeployer {
    private static final Logger log = Logger.getLogger(AddressSettingsDeployer.class);
    private static final String DEAD_LETTER_ADDRESS_NODE_NAME = "dead-letter-address";
    private static final String EXPIRY_ADDRESS_NODE_NAME = "expiry-address";
    private static final String REDELIVERY_DELAY_NODE_NAME = "redelivery-delay";
    private static final String MAX_DELIVERY_ATTEMPTS = "max-delivery-attempts";
    private static final String MAX_SIZE_BYTES_NODE_NAME = "max-size-bytes";
    private static final String ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME = "address-full-policy";
    private static final String PAGE_SIZE_BYTES_NODE_NAME = "page-size-bytes";
    private static final String MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME = "message-counter-history-day-limit";
    private static final String LVQ_NODE_NAME = "last-value-queue";
    private static final String REDISTRIBUTION_DELAY_NODE_NAME = "redistribution-delay";
    private static final String SEND_TO_DLA_ON_NO_ROUTE = "send-to-dla-on-no-route";
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;

    public AddressSettingsDeployer(DeploymentManager deploymentManager, HierarchicalRepository<AddressSettings> addressSettingsRepository) {
        super(deploymentManager);
        this.addressSettingsRepository = addressSettingsRepository;
    }

    @Override
    public String[] getElementTagName() {
        return new String[]{"address-setting"};
    }

    @Override
    public void validate(Node rootNode) throws Exception {
        XMLUtil.validate(rootNode, "schema/hornetq-configuration.xsd");
    }

    @Override
    public void deploy(Node node) throws Exception {
        String match = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
        NodeList children = node.getChildNodes();
        AddressSettings addressSettings = new AddressSettings();
        for (int i = 0; i < children.getLength(); ++i) {
            SimpleString queueName;
            Node child = children.item(i);
            if (DEAD_LETTER_ADDRESS_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                queueName = new SimpleString(child.getTextContent());
                addressSettings.setDeadLetterAddress(queueName);
                continue;
            }
            if (EXPIRY_ADDRESS_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                queueName = new SimpleString(child.getTextContent());
                addressSettings.setExpiryAddress(queueName);
                continue;
            }
            if (REDELIVERY_DELAY_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setRedeliveryDelay(Long.valueOf(child.getTextContent()));
                continue;
            }
            if (MAX_SIZE_BYTES_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setMaxSizeBytes(Integer.valueOf(child.getTextContent()).intValue());
                continue;
            }
            if (PAGE_SIZE_BYTES_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setPageSizeBytes(Integer.valueOf(child.getTextContent()));
                continue;
            }
            if (MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setMessageCounterHistoryDayLimit(Integer.valueOf(child.getTextContent()));
                continue;
            }
            if (ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                String value = child.getTextContent().trim();
                Validators.ADDRESS_FULL_MESSAGE_POLICY_TYPE.validate(ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME, value);
                AddressFullMessagePolicy policy = null;
                if (value.equals(AddressFullMessagePolicy.BLOCK.toString())) {
                    policy = AddressFullMessagePolicy.BLOCK;
                } else if (value.equals(AddressFullMessagePolicy.DROP.toString())) {
                    policy = AddressFullMessagePolicy.DROP;
                } else if (value.equals(AddressFullMessagePolicy.PAGE.toString())) {
                    policy = AddressFullMessagePolicy.PAGE;
                }
                addressSettings.setAddressFullMessagePolicy(policy);
                continue;
            }
            if (LVQ_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setLastValueQueue(Boolean.valueOf(child.getTextContent().trim()));
                continue;
            }
            if (MAX_DELIVERY_ATTEMPTS.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setMaxDeliveryAttempts(Integer.valueOf(child.getTextContent().trim()));
                continue;
            }
            if (REDISTRIBUTION_DELAY_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setRedistributionDelay(Long.valueOf(child.getTextContent().trim()));
                continue;
            }
            if (!SEND_TO_DLA_ON_NO_ROUTE.equalsIgnoreCase(child.getNodeName())) continue;
            addressSettings.setSendToDLAOnNoRoute(Boolean.valueOf(child.getTextContent().trim()));
        }
        this.addressSettingsRepository.addMatch(match, addressSettings);
    }

    @Override
    public String[] getDefaultConfigFileNames() {
        return new String[]{"hornetq-configuration.xml", "hornetq-queues.xml"};
    }

    @Override
    public void undeploy(Node node) throws Exception {
        String match = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
        this.addressSettingsRepository.removeMatch(match);
    }

    @Override
    public String getKeyAttribute() {
        return "match";
    }
}

