/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.filter.impl;

import java.util.HashMap;
import java.util.Map;
import org.hornetq.api.core.FilterConstants;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterParser;
import org.hornetq.core.filter.impl.Identifier;
import org.hornetq.core.filter.impl.Operator;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.server.ServerMessage;

public class FilterImpl
implements Filter {
    private static final Logger log = Logger.getLogger(FilterImpl.class);
    private final SimpleString sfilterString;
    private final Map<SimpleString, Identifier> identifiers = new HashMap<SimpleString, Identifier>();
    private final Operator operator;
    private final FilterParser parser = new FilterParser();

    public static Filter createFilter(String filterStr) throws HornetQException {
        return FilterImpl.createFilter(SimpleString.toSimpleString(filterStr));
    }

    public static Filter createFilter(SimpleString filterStr) throws HornetQException {
        if (filterStr == null || filterStr.length() == 0) {
            return null;
        }
        return new FilterImpl(filterStr);
    }

    private FilterImpl(SimpleString str) throws HornetQException {
        this.sfilterString = str;
        try {
            this.operator = (Operator)this.parser.parse(this.sfilterString, this.identifiers);
        }
        catch (Throwable e) {
            log.error("Invalid filter", e);
            throw new HornetQException(103, "Invalid filter: " + this.sfilterString);
        }
    }

    public SimpleString getFilterString() {
        return this.sfilterString;
    }

    public boolean match(ServerMessage message) {
        try {
            for (Identifier id : this.identifiers.values()) {
                Object val = null;
                if (id.getName().startsWith(FilterConstants.HORNETQ_PREFIX)) {
                    val = this.getHeaderFieldValue(message, id.getName());
                }
                if (val == null) {
                    val = message.getObjectProperty(id.getName());
                }
                id.setValue(val);
            }
            boolean res = (Boolean)this.operator.apply();
            return res;
        }
        catch (Exception e) {
            log.warn("Invalid filter string: " + this.sfilterString, e);
            return false;
        }
    }

    public String toString() {
        return "FilterImpl [sfilterString=" + this.sfilterString + "]";
    }

    private Object getHeaderFieldValue(ServerMessage msg, SimpleString fieldName) {
        if (FilterConstants.HORNETQ_PRIORITY.equals(fieldName)) {
            return new Integer(msg.getPriority());
        }
        if (FilterConstants.HORNETQ_TIMESTAMP.equals(fieldName)) {
            return msg.getTimestamp();
        }
        if (FilterConstants.HORNETQ_DURABLE.equals(fieldName)) {
            return msg.isDurable() ? FilterConstants.DURABLE : FilterConstants.NON_DURABLE;
        }
        if (FilterConstants.HORNETQ_EXPIRATION.equals(fieldName)) {
            return msg.getExpiration();
        }
        if (FilterConstants.HORNETQ_SIZE.equals(fieldName)) {
            return msg.getEncodeSize();
        }
        return null;
    }
}

