/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.impl.JournalFile;
import org.hornetq.core.logging.Logger;

public class JournalFileImpl
implements JournalFile {
    private static final Logger log = Logger.getLogger(JournalFileImpl.class);
    private final SequentialFile file;
    private final int fileID;
    private long offset;
    private final AtomicInteger posCount = new AtomicInteger(0);
    private final AtomicInteger liveBytes = new AtomicInteger(0);
    private boolean canReclaim;
    private boolean needCleanup;
    private final Map<JournalFile, AtomicInteger> negCounts = new ConcurrentHashMap<JournalFile, AtomicInteger>();

    public JournalFileImpl(SequentialFile file, int fileID) {
        this.file = file;
        this.fileID = fileID;
    }

    public void clearCounts() {
        this.negCounts.clear();
        this.posCount.set(0);
        this.liveBytes.set(0);
    }

    public int getPosCount() {
        return this.posCount.intValue();
    }

    public boolean isCanReclaim() {
        return this.canReclaim;
    }

    public boolean isNeedCleanup() {
        return this.needCleanup;
    }

    public void setNeedCleanup(boolean needCleanup) {
        this.needCleanup = needCleanup;
    }

    public void setCanReclaim(boolean canReclaim) {
        this.canReclaim = canReclaim;
    }

    public void incNegCount(JournalFile file) {
        this.getOrCreateNegCount(file).incrementAndGet();
    }

    public int getNegCount(JournalFile file) {
        AtomicInteger count = this.negCounts.get(file);
        if (count == null) {
            return 0;
        }
        return count.intValue();
    }

    public boolean resetNegCount(JournalFile file) {
        return this.negCounts.remove(file) != null;
    }

    public void incPosCount() {
        this.posCount.incrementAndGet();
    }

    public void decPosCount() {
        this.posCount.decrementAndGet();
    }

    public void extendOffset(int delta) {
        this.offset += (long)delta;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getFileID() {
        return this.fileID;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public SequentialFile getFile() {
        return this.file;
    }

    public String toString() {
        try {
            return "JournalFileImpl: " + this.file.getFileName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error:" + e.toString();
        }
    }

    public String debug() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<JournalFile, AtomicInteger> entry : this.negCounts.entrySet()) {
            builder.append(" file = " + entry.getKey() + " negcount value = " + entry.getValue() + "\n");
        }
        return builder.toString();
    }

    private synchronized AtomicInteger getOrCreateNegCount(JournalFile file) {
        AtomicInteger count = this.negCounts.get(file);
        if (count == null) {
            count = new AtomicInteger();
            this.negCounts.put(file, count);
        }
        return count;
    }

    public void addSize(int bytes) {
        this.liveBytes.addAndGet(bytes);
    }

    public void decSize(int bytes) {
        this.liveBytes.addAndGet(-bytes);
    }

    public int getLiveSize() {
        return this.liveBytes.get();
    }
}

