/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.Pair;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.IOCompletion;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.journal.LoaderCallback;
import org.hornetq.core.journal.PreparedTransactionInfo;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.TestableJournal;
import org.hornetq.core.journal.TransactionFailureCallback;
import org.hornetq.core.journal.impl.AbstractJournalUpdateTask;
import org.hornetq.core.journal.impl.DummyCallback;
import org.hornetq.core.journal.impl.JournalCleaner;
import org.hornetq.core.journal.impl.JournalCompactor;
import org.hornetq.core.journal.impl.JournalFile;
import org.hornetq.core.journal.impl.JournalFileImpl;
import org.hornetq.core.journal.impl.JournalReaderCallback;
import org.hornetq.core.journal.impl.JournalTransaction;
import org.hornetq.core.journal.impl.Reclaimer;
import org.hornetq.core.journal.impl.SimpleWaitIOCallback;
import org.hornetq.core.journal.impl.SyncIOCompletion;
import org.hornetq.core.journal.impl.TransactionCallback;
import org.hornetq.core.journal.impl.dataformat.ByteArrayEncoding;
import org.hornetq.core.journal.impl.dataformat.JournalAddRecord;
import org.hornetq.core.journal.impl.dataformat.JournalAddRecordTX;
import org.hornetq.core.journal.impl.dataformat.JournalCompleteRecordTX;
import org.hornetq.core.journal.impl.dataformat.JournalDeleteRecord;
import org.hornetq.core.journal.impl.dataformat.JournalDeleteRecordTX;
import org.hornetq.core.journal.impl.dataformat.JournalInternalRecord;
import org.hornetq.core.journal.impl.dataformat.JournalRollbackRecordTX;
import org.hornetq.core.logging.Logger;
import org.hornetq.utils.concurrent.LinkedBlockingDeque;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalImpl
implements TestableJournal {
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_LOADED = 2;
    private static final Logger log = Logger.getLogger(JournalImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final boolean LOAD_TRACE = false;
    public static final int MIN_FILE_SIZE = 1024;
    public static final int SIZE_HEADER = 4;
    public static final int BASIC_SIZE = 9;
    public static final int SIZE_ADD_RECORD = 22;
    public static final byte ADD_RECORD = 11;
    public static final byte UPDATE_RECORD = 12;
    public static final int SIZE_ADD_RECORD_TX = 30;
    public static final byte ADD_RECORD_TX = 13;
    public static final byte UPDATE_RECORD_TX = 14;
    public static final int SIZE_DELETE_RECORD_TX = 29;
    public static final byte DELETE_RECORD_TX = 15;
    public static final int SIZE_DELETE_RECORD = 17;
    public static final byte DELETE_RECORD = 16;
    public static final int SIZE_COMPLETE_TRANSACTION_RECORD = 21;
    public static final int SIZE_PREPARE_RECORD = 25;
    public static final byte PREPARE_RECORD = 17;
    public static final int SIZE_COMMIT_RECORD = 21;
    public static final byte COMMIT_RECORD = 18;
    public static final int SIZE_ROLLBACK_RECORD = 17;
    public static final byte ROLLBACK_RECORD = 19;
    public static final byte FILL_CHARACTER = 74;
    private volatile boolean autoReclaim = true;
    private final AtomicInteger nextFileID = new AtomicInteger(0);
    private final int maxAIO;
    private final int fileSize;
    private final int minFiles;
    private final float compactPercentage;
    private final int compactMinFiles;
    private final SequentialFileFactory fileFactory;
    public final String filePrefix;
    public final String fileExtension;
    private final LinkedBlockingDeque<JournalFile> dataFiles = new LinkedBlockingDeque();
    private final LinkedBlockingDeque<JournalFile> pendingCloseFiles = new LinkedBlockingDeque();
    private final Queue<JournalFile> freeFiles = new ConcurrentLinkedQueue<JournalFile>();
    private final BlockingQueue<JournalFile> openedFiles = new LinkedBlockingQueue<JournalFile>();
    private final ConcurrentMap<Long, JournalRecord> records = new ConcurrentHashMap<Long, JournalRecord>();
    private final ConcurrentMap<Long, JournalTransaction> transactions = new ConcurrentHashMap<Long, JournalTransaction>();
    private volatile JournalCompactor compactor;
    private final AtomicBoolean compactorRunning = new AtomicBoolean();
    private ExecutorService filesExecutor = null;
    private ExecutorService compactorExecutor = null;
    private final ReentrantLock lockAppend = new ReentrantLock();
    private final ReadWriteLock compactingLock = new ReentrantReadWriteLock();
    private volatile JournalFile currentFile;
    private volatile int state;
    private final Reclaimer reclaimer = new Reclaimer();

    private static final void trace(String message) {
        log.trace(message);
    }

    @Override
    public void runDirectJournalBlast() throws Exception {
        int numIts = 100000000;
        log.info("*** running direct journal blast: 100000000");
        final CountDownLatch latch = new CountDownLatch(200000000);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyIOAsyncTask
        implements IOCompletion {
            MyIOAsyncTask() {
            }

            @Override
            public void done() {
                latch.countDown();
            }

            @Override
            public void onError(int errorCode, String errorMessage) {
            }

            @Override
            public void storeLineUp() {
            }
        }
        MyIOAsyncTask task = new MyIOAsyncTask();
        int recordSize = 1024;
        final byte[] bytes = new byte[1024];
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyRecord
        implements EncodingSupport {
            MyRecord() {
            }

            @Override
            public void decode(HornetQBuffer buffer) {
            }

            @Override
            public void encode(HornetQBuffer buffer) {
                buffer.writeBytes(bytes);
            }

            @Override
            public int getEncodeSize() {
                return 1024;
            }
        }
        MyRecord record = new MyRecord();
        for (int i = 0; i < 100000000; ++i) {
            this.appendAddRecord((long)i, (byte)1, record, true, (IOCompletion)task);
            this.appendDeleteRecord(i, true, task);
        }
        latch.await();
    }

    public JournalImpl(int fileSize, int minFiles, int compactMinFiles, int compactPercentage, SequentialFileFactory fileFactory, String filePrefix, String fileExtension, int maxIO) {
        if (fileFactory == null) {
            throw new NullPointerException("fileFactory is null");
        }
        if (fileSize < 1024) {
            throw new IllegalArgumentException("File size cannot be less than 1024 bytes");
        }
        if (fileSize % fileFactory.getAlignment() != 0) {
            throw new IllegalArgumentException("Invalid journal-file-size " + fileSize + ", It should be multiple of " + fileFactory.getAlignment());
        }
        if (minFiles < 2) {
            throw new IllegalArgumentException("minFiles cannot be less than 2");
        }
        if (filePrefix == null) {
            throw new NullPointerException("filePrefix is null");
        }
        if (fileExtension == null) {
            throw new NullPointerException("fileExtension is null");
        }
        if (maxIO <= 0) {
            throw new IllegalStateException("maxAIO should aways be a positive number");
        }
        if (compactPercentage < 0 || compactPercentage > 100) {
            throw new IllegalArgumentException("Compact Percentage out of range");
        }
        this.compactPercentage = compactPercentage == 0 ? 0.0f : (float)compactPercentage / 100.0f;
        this.compactMinFiles = compactMinFiles;
        this.fileSize = fileSize;
        this.minFiles = minFiles;
        this.fileFactory = fileFactory;
        this.filePrefix = filePrefix;
        this.fileExtension = fileExtension;
        this.maxAIO = maxIO;
    }

    public Map<Long, JournalRecord> getRecords() {
        return this.records;
    }

    public JournalFile getCurrentFile() {
        return this.currentFile;
    }

    public JournalCompactor getCompactor() {
        return this.compactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readJournalFile(SequentialFileFactory fileFactory, JournalFile file, JournalReaderCallback reader) throws Exception {
        int n;
        block37: {
            file.getFile().open(1, false);
            ByteBuffer wholeFileBuffer = null;
            try {
                int filesize = (int)file.getFile().size();
                wholeFileBuffer = fileFactory.newBuffer(filesize);
                int journalFileSize = file.getFile().read(wholeFileBuffer);
                if (journalFileSize != filesize) {
                    throw new RuntimeException("Invalid read! The system couldn't read the entire file into memory");
                }
                wholeFileBuffer.position(4);
                int lastDataPos = 4;
                while (wholeFileBuffer.hasRemaining()) {
                    int recordSize;
                    int pos = wholeFileBuffer.position();
                    byte recordType = wholeFileBuffer.get();
                    if (recordType < 11 || recordType > 19) continue;
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 4)) {
                        reader.markAsDataFile(file);
                        wholeFileBuffer.position(pos + 1);
                        continue;
                    }
                    int readFileId = wholeFileBuffer.getInt();
                    long transactionID = 0L;
                    if (JournalImpl.isTransaction(recordType)) {
                        if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 8)) {
                            wholeFileBuffer.position(pos + 1);
                            reader.markAsDataFile(file);
                            continue;
                        }
                        transactionID = wholeFileBuffer.getLong();
                    }
                    long recordID = 0L;
                    if (!JournalImpl.isCompleteTransaction(recordType)) {
                        if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 8)) {
                            wholeFileBuffer.position(pos + 1);
                            reader.markAsDataFile(file);
                            continue;
                        }
                        recordID = wholeFileBuffer.getLong();
                    }
                    int variableSize = 0;
                    int preparedTransactionExtraDataSize = 0;
                    byte userRecordType = 0;
                    byte[] record = null;
                    if (JournalImpl.isContainsBody(recordType)) {
                        if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 4)) {
                            wholeFileBuffer.position(pos + 1);
                            reader.markAsDataFile(file);
                            continue;
                        }
                        variableSize = wholeFileBuffer.getInt();
                        if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), variableSize)) {
                            wholeFileBuffer.position(pos + 1);
                            continue;
                        }
                        if (recordType != 15) {
                            userRecordType = wholeFileBuffer.get();
                        }
                        record = new byte[variableSize];
                        wholeFileBuffer.get(record);
                    }
                    int transactionCheckNumberOfRecords = 0;
                    if (recordType == 17 || recordType == 18) {
                        if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 4)) {
                            wholeFileBuffer.position(pos + 1);
                            continue;
                        }
                        transactionCheckNumberOfRecords = wholeFileBuffer.getInt();
                        if (recordType == 17) {
                            if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 4)) {
                                wholeFileBuffer.position(pos + 1);
                                continue;
                            }
                            preparedTransactionExtraDataSize = wholeFileBuffer.getInt();
                        }
                        variableSize = 0;
                    }
                    if (JournalImpl.isInvalidSize(journalFileSize, pos, (recordSize = JournalImpl.getRecordSize(recordType)) + variableSize + preparedTransactionExtraDataSize)) {
                        JournalImpl.trace("Record at position " + pos + " recordType = " + recordType + " file:" + file.getFile().getFileName() + " recordSize: " + recordSize + " variableSize: " + variableSize + " preparedTransactionExtraDataSize: " + preparedTransactionExtraDataSize + " is corrupted and it is being ignored (II)");
                        reader.markAsDataFile(file);
                        wholeFileBuffer.position(pos + 1);
                        continue;
                    }
                    int oldPos = wholeFileBuffer.position();
                    wholeFileBuffer.position(pos + variableSize + recordSize + preparedTransactionExtraDataSize - 4);
                    int checkSize = wholeFileBuffer.getInt();
                    if (checkSize != variableSize + recordSize + preparedTransactionExtraDataSize) {
                        JournalImpl.trace("Record at position " + pos + " recordType = " + recordType + " file:" + file.getFile().getFileName() + " is corrupted and it is being ignored (III)");
                        reader.markAsDataFile(file);
                        wholeFileBuffer.position(pos + 1);
                        continue;
                    }
                    if (readFileId != file.getFileID()) {
                        reader.markAsDataFile(file);
                        continue;
                    }
                    wholeFileBuffer.position(oldPos);
                    switch (recordType) {
                        case 11: {
                            reader.onReadAddRecord(new RecordInfo(recordID, userRecordType, record, false));
                            break;
                        }
                        case 12: {
                            reader.onReadUpdateRecord(new RecordInfo(recordID, userRecordType, record, true));
                            break;
                        }
                        case 16: {
                            reader.onReadDeleteRecord(recordID);
                            break;
                        }
                        case 13: {
                            reader.onReadAddRecordTX(transactionID, new RecordInfo(recordID, userRecordType, record, false));
                            break;
                        }
                        case 14: {
                            reader.onReadUpdateRecordTX(transactionID, new RecordInfo(recordID, userRecordType, record, true));
                            break;
                        }
                        case 15: {
                            reader.onReadDeleteRecordTX(transactionID, new RecordInfo(recordID, 0, record, true));
                            break;
                        }
                        case 17: {
                            byte[] extraData = new byte[preparedTransactionExtraDataSize];
                            wholeFileBuffer.get(extraData);
                            reader.onReadPrepareRecord(transactionID, extraData, transactionCheckNumberOfRecords);
                            break;
                        }
                        case 18: {
                            reader.onReadCommitRecord(transactionID, transactionCheckNumberOfRecords);
                            break;
                        }
                        case 19: {
                            reader.onReadRollbackRecord(transactionID);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Journal " + file.getFile().getFileName() + " is corrupt, invalid record type " + recordType);
                        }
                    }
                    checkSize = wholeFileBuffer.getInt();
                    if (checkSize != variableSize + recordSize + preparedTransactionExtraDataSize) {
                        throw new IllegalStateException("Internal error on loading file. Position doesn't match with checkSize, file = " + file.getFile() + ", pos = " + pos);
                    }
                    lastDataPos = wholeFileBuffer.position();
                }
                n = lastDataPos;
                if (wholeFileBuffer == null) break block37;
                fileFactory.releaseBuffer(wholeFileBuffer);
            }
            catch (Throwable throwable) {
                if (wholeFileBuffer != null) {
                    fileFactory.releaseBuffer(wholeFileBuffer);
                }
                try {
                    file.getFile().close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            file.getFile().close();
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        return n;
    }

    @Override
    public void appendAddRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.appendAddRecord(id, recordType, new ByteArrayEncoding(record), sync);
    }

    @Override
    public void appendAddRecord(long id, byte recordType, byte[] record, boolean sync, IOCompletion callback) throws Exception {
        this.appendAddRecord(id, recordType, new ByteArrayEncoding(record), sync, callback);
    }

    @Override
    public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        SyncIOCompletion callback = this.getSyncCallback(sync);
        this.appendAddRecord(id, recordType, record, sync, (IOCompletion)callback);
        if (callback != null) {
            callback.waitCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion callback) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        try {
            JournalAddRecord addRecord = new JournalAddRecord(true, id, recordType, record);
            if (callback != null) {
                callback.storeLineUp();
            }
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(addRecord, false, sync, null, callback);
                this.records.put(id, new JournalRecord(usedFile, ((JournalInternalRecord)addRecord).getEncodeSize()));
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.appendUpdateRecord(id, recordType, new ByteArrayEncoding(record), sync);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, byte[] record, boolean sync, IOCompletion callback) throws Exception {
        this.appendUpdateRecord(id, recordType, new ByteArrayEncoding(record), sync, callback);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        SyncIOCompletion callback = this.getSyncCallback(sync);
        this.appendUpdateRecord(id, recordType, record, sync, (IOCompletion)callback);
        if (callback != null) {
            callback.waitCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion callback) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        try {
            JournalRecord jrnRecord = (JournalRecord)this.records.get(id);
            if (!(jrnRecord != null || this.compactor != null && this.compactor.lookupRecord(id))) {
                throw new IllegalStateException("Cannot find add info " + id);
            }
            JournalAddRecord updateRecord = new JournalAddRecord(false, id, recordType, record);
            if (callback != null) {
                callback.storeLineUp();
            }
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(updateRecord, false, sync, null, callback);
                if (jrnRecord == null) {
                    this.compactor.addCommandUpdate(id, usedFile, ((JournalInternalRecord)updateRecord).getEncodeSize());
                } else {
                    jrnRecord.addUpdateFile(usedFile, ((JournalInternalRecord)updateRecord).getEncodeSize());
                }
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void appendDeleteRecord(long id, boolean sync) throws Exception {
        SyncIOCompletion callback = this.getSyncCallback(sync);
        this.appendDeleteRecord(id, sync, callback);
        if (callback != null) {
            callback.waitCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendDeleteRecord(long id, boolean sync, IOCompletion callback) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        try {
            JournalRecord record = (JournalRecord)this.records.remove(id);
            if (!(record != null || this.compactor != null && this.compactor.lookupRecord(id))) {
                throw new IllegalStateException("Cannot find add info " + id);
            }
            JournalDeleteRecord deleteRecord = new JournalDeleteRecord(id);
            if (callback != null) {
                callback.storeLineUp();
            }
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(deleteRecord, false, sync, null, callback);
                if (record == null) {
                    this.compactor.addCommandDelete(id, usedFile);
                } else {
                    record.delete(usedFile);
                }
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void appendAddRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.appendAddRecordTransactional(txID, id, recordType, new ByteArrayEncoding(record));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendAddRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        try {
            JournalAddRecordTX addRecord = new JournalAddRecordTX(true, txID, id, recordType, record);
            JournalTransaction tx = this.getTransactionInfo(txID);
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(addRecord, false, false, tx, null);
                tx.addPositive(usedFile, id, ((JournalInternalRecord)addRecord).getEncodeSize());
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.appendUpdateRecordTransactional(txID, id, recordType, new ByteArrayEncoding(record));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        try {
            JournalAddRecordTX updateRecordTX = new JournalAddRecordTX(false, txID, id, recordType, record);
            JournalTransaction tx = this.getTransactionInfo(txID);
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(updateRecordTX, false, false, tx, null);
                tx.addPositive(usedFile, id, ((JournalInternalRecord)updateRecordTX).getEncodeSize());
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id, byte[] record) throws Exception {
        this.appendDeleteRecordTransactional(txID, id, new ByteArrayEncoding(record));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendDeleteRecordTransactional(long txID, long id, EncodingSupport record) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        try {
            JournalDeleteRecordTX deleteRecordTX = new JournalDeleteRecordTX(txID, id, record);
            JournalTransaction tx = this.getTransactionInfo(txID);
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(deleteRecordTX, false, false, tx, null);
                tx.addNegative(usedFile, id);
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id) throws Exception {
        this.appendDeleteRecordTransactional(txID, id, NullEncoding.instance);
    }

    @Override
    public void appendPrepareRecord(long txID, byte[] transactionData, boolean sync, IOCompletion completion) throws Exception {
        this.appendPrepareRecord(txID, new ByteArrayEncoding(transactionData), sync, completion);
    }

    @Override
    public void appendPrepareRecord(long txID, byte[] transactionData, boolean sync) throws Exception {
        this.appendPrepareRecord(txID, new ByteArrayEncoding(transactionData), sync);
    }

    @Override
    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync) throws Exception {
        SyncIOCompletion syncCompletion = this.getSyncCallback(sync);
        this.appendPrepareRecord(txID, transactionData, sync, (IOCompletion)syncCompletion);
        if (syncCompletion != null) {
            syncCompletion.waitCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync, IOCompletion callback) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        JournalTransaction tx = this.getTransactionInfo(txID);
        try {
            JournalCompleteRecordTX prepareRecord = new JournalCompleteRecordTX(false, txID, transactionData);
            if (callback != null) {
                callback.storeLineUp();
            }
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(prepareRecord, true, sync, tx, callback);
                tx.prepare(usedFile);
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync) throws Exception {
        SyncIOCompletion syncCompletion = this.getSyncCallback(sync);
        this.appendCommitRecord(txID, sync, syncCompletion);
        if (syncCompletion != null) {
            syncCompletion.waitCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        JournalTransaction tx = (JournalTransaction)this.transactions.remove(txID);
        try {
            if (tx == null) {
                throw new IllegalStateException("Cannot find tx with id " + txID);
            }
            JournalCompleteRecordTX commitRecord = new JournalCompleteRecordTX(true, txID, null);
            if (callback != null) {
                callback.storeLineUp();
            }
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(commitRecord, true, sync, tx, callback);
                tx.commit(usedFile);
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void appendRollbackRecord(long txID, boolean sync) throws Exception {
        SyncIOCompletion syncCompletion = this.getSyncCallback(sync);
        this.appendRollbackRecord(txID, sync, syncCompletion);
        if (syncCompletion != null) {
            syncCompletion.waitCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendRollbackRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        JournalTransaction tx = null;
        try {
            tx = (JournalTransaction)this.transactions.remove(txID);
            if (tx == null) {
                throw new IllegalStateException("Cannot find tx with id " + txID);
            }
            JournalRollbackRecordTX rollbackRecord = new JournalRollbackRecordTX(txID);
            if (callback != null) {
                callback.storeLineUp();
            }
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(rollbackRecord, false, sync, tx, callback);
                tx.rollback(usedFile);
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public int getAlignment() throws Exception {
        return this.fileFactory.getAlignment();
    }

    @Override
    public synchronized JournalLoadInformation loadInternalOnly() throws Exception {
        LoaderCallback dummyLoader = new LoaderCallback(){

            @Override
            public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
            }

            @Override
            public void updateRecord(RecordInfo info) {
            }

            @Override
            public void deleteRecord(long id) {
            }

            @Override
            public void addRecord(RecordInfo info) {
            }

            @Override
            public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
            }
        };
        return this.load(dummyLoader);
    }

    @Override
    public synchronized JournalLoadInformation load(List<RecordInfo> committedRecords, final List<PreparedTransactionInfo> preparedTransactions, final TransactionFailureCallback failureCallback) throws Exception {
        final HashSet recordsToDelete = new HashSet();
        final ArrayList records = new ArrayList();
        int DELETE_FLUSH = 20000;
        JournalLoadInformation info = this.load(new LoaderCallback(){

            @Override
            public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
                preparedTransactions.add(preparedTransaction);
            }

            @Override
            public void addRecord(RecordInfo info) {
                records.add(info);
            }

            @Override
            public void updateRecord(RecordInfo info) {
                records.add(info);
            }

            @Override
            public void deleteRecord(long id) {
                recordsToDelete.add(id);
                if (recordsToDelete.size() == 20000) {
                    Iterator iter = records.iterator();
                    while (iter.hasNext()) {
                        RecordInfo record = (RecordInfo)iter.next();
                        if (!recordsToDelete.contains(record.id)) continue;
                        iter.remove();
                    }
                    recordsToDelete.clear();
                }
            }

            @Override
            public void failedTransaction(long transactionID, List<RecordInfo> records2, List<RecordInfo> recordsToDelete2) {
                if (failureCallback != null) {
                    failureCallback.failedTransaction(transactionID, records2, recordsToDelete2);
                }
            }
        });
        for (RecordInfo record : records) {
            if (recordsToDelete.contains(record.id)) continue;
            committedRecords.add(record);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void compact() throws Exception {
        if (this.compactor != null) {
            throw new IllegalStateException("There is pending compacting operation");
        }
        ArrayList<JournalFile> dataFilesToProcess = new ArrayList<JournalFile>(this.dataFiles.size());
        boolean previousReclaimValue = this.autoReclaim;
        try {
            JournalImpl.trace("Starting compacting operation on journal");
            log.debug("Starting compacting operation on journal");
            this.compactingLock.writeLock().lock();
            try {
                if (this.state != 2) {
                    return;
                }
                this.autoReclaim = false;
                this.moveNextFile(true);
                dataFilesToProcess.addAll(this.dataFiles);
                for (JournalFile journalFile : this.pendingCloseFiles) {
                    journalFile.getFile().close();
                }
                dataFilesToProcess.addAll(this.pendingCloseFiles);
                this.pendingCloseFiles.clear();
                this.dataFiles.clear();
                if (dataFilesToProcess.size() == 0) {
                    return;
                }
                this.compactor = new JournalCompactor(this.fileFactory, this, this.records.keySet(), ((JournalFile)dataFilesToProcess.get(0)).getFileID());
                for (Map.Entry entry : this.transactions.entrySet()) {
                    this.compactor.addPendingTransaction((Long)entry.getKey(), ((JournalTransaction)entry.getValue()).getPositiveArray());
                    ((JournalTransaction)entry.getValue()).setCompacting();
                }
                this.records.clear();
            }
            finally {
                this.compactingLock.writeLock().unlock();
            }
            Collections.sort(dataFilesToProcess, new JournalFileComparator());
            for (JournalFile journalFile : dataFilesToProcess) {
                JournalImpl.readJournalFile(this.fileFactory, journalFile, this.compactor);
            }
            this.compactor.flush();
            this.onCompactDone();
            List<JournalFile> newDatafiles = null;
            JournalCompactor journalCompactor = this.compactor;
            SequentialFile controlFile = this.createControlFile(dataFilesToProcess, this.compactor.getNewDataFiles(), null);
            this.compactingLock.writeLock().lock();
            try {
                this.compactor = null;
                newDatafiles = journalCompactor.getNewDataFiles();
                for (Map.Entry<Long, JournalRecord> newRecordEntry : journalCompactor.getNewRecords().entrySet()) {
                    this.records.put(newRecordEntry.getKey(), newRecordEntry.getValue());
                }
                for (int i = newDatafiles.size() - 1; i >= 0; --i) {
                    JournalFile fileToAdd = newDatafiles.get(i);
                    if (trace) {
                        JournalImpl.trace("Adding file " + fileToAdd + " back as datafile");
                    }
                    this.dataFiles.addFirst(fileToAdd);
                }
                JournalImpl.trace("There are " + this.dataFiles.size() + " datafiles Now");
                journalCompactor.replayPendingCommands();
                for (JournalTransaction newTransaction : journalCompactor.getNewTransactions().values()) {
                    JournalTransaction liveTransaction;
                    if (trace) {
                        JournalImpl.trace("Merging pending transaction " + newTransaction + " after compacting the journal");
                    }
                    if ((liveTransaction = (JournalTransaction)this.transactions.get(newTransaction.getId())) == null) {
                        log.warn("Inconsistency: Can't merge transaction " + newTransaction.getId() + " back into JournalTransactions");
                        continue;
                    }
                    liveTransaction.merge(newTransaction);
                }
            }
            finally {
                this.compactingLock.writeLock().unlock();
            }
            this.renameFiles(dataFilesToProcess, newDatafiles);
            this.deleteControlFile(controlFile);
            log.debug("Finished compacting on journal");
            return;
        }
        finally {
            if (this.compactor != null) {
                try {
                    this.compactor.flush();
                }
                catch (Throwable ignored) {}
                this.compactor = null;
            }
            this.autoReclaim = previousReclaimValue;
        }
    }

    @Override
    public synchronized JournalLoadInformation load(final LoaderCallback loadManager) throws Exception {
        if (this.state != 1) {
            throw new IllegalStateException("Journal must be in started state");
        }
        this.checkControlFile();
        this.records.clear();
        this.dataFiles.clear();
        this.pendingCloseFiles.clear();
        this.freeFiles.clear();
        this.openedFiles.clear();
        this.transactions.clear();
        final LinkedHashMap loadTransactions = new LinkedHashMap();
        final List<JournalFile> orderedFiles = this.orderFiles();
        int lastDataPos = 4;
        final AtomicLong maxID = new AtomicLong(-1L);
        for (final JournalFile file : orderedFiles) {
            JournalImpl.trace("Loading file " + file.getFile().getFileName());
            final AtomicBoolean hasData = new AtomicBoolean(false);
            int resultLastPost = JournalImpl.readJournalFile(this.fileFactory, file, new JournalReaderCallback(){

                private void checkID(long id) {
                    if (id > maxID.longValue()) {
                        maxID.set(id);
                    }
                }

                public void onReadAddRecord(RecordInfo info) throws Exception {
                    if (trace) {
                        // empty if block
                    }
                    this.checkID(info.id);
                    hasData.set(true);
                    loadManager.addRecord(info);
                    JournalImpl.this.records.put(info.id, new JournalRecord(file, info.data.length + 22));
                }

                public void onReadUpdateRecord(RecordInfo info) throws Exception {
                    if (trace) {
                        // empty if block
                    }
                    this.checkID(info.id);
                    hasData.set(true);
                    loadManager.updateRecord(info);
                    JournalRecord posFiles = (JournalRecord)JournalImpl.this.records.get(info.id);
                    if (posFiles != null) {
                        posFiles.addUpdateFile(file, info.data.length + 22);
                    }
                }

                public void onReadDeleteRecord(long recordID) throws Exception {
                    if (trace) {
                        // empty if block
                    }
                    hasData.set(true);
                    loadManager.deleteRecord(recordID);
                    JournalRecord posFiles = (JournalRecord)JournalImpl.this.records.remove(recordID);
                    if (posFiles != null) {
                        posFiles.delete(file);
                    }
                }

                public void onReadUpdateRecordTX(long transactionID, RecordInfo info) throws Exception {
                    this.onReadAddRecordTX(transactionID, info);
                }

                public void onReadAddRecordTX(long transactionID, RecordInfo info) throws Exception {
                    if (trace) {
                        // empty if block
                    }
                    this.checkID(info.id);
                    hasData.set(true);
                    TransactionHolder tx = (TransactionHolder)loadTransactions.get(transactionID);
                    if (tx == null) {
                        tx = new TransactionHolder(transactionID);
                        loadTransactions.put(transactionID, tx);
                    }
                    tx.recordInfos.add(info);
                    JournalTransaction tnp = (JournalTransaction)JournalImpl.this.transactions.get(transactionID);
                    if (tnp == null) {
                        tnp = new JournalTransaction(info.id, JournalImpl.this);
                        JournalImpl.this.transactions.put(transactionID, tnp);
                    }
                    tnp.addPositive(file, info.id, info.data.length + 30);
                }

                public void onReadDeleteRecordTX(long transactionID, RecordInfo info) throws Exception {
                    if (trace) {
                        // empty if block
                    }
                    hasData.set(true);
                    TransactionHolder tx = (TransactionHolder)loadTransactions.get(transactionID);
                    if (tx == null) {
                        tx = new TransactionHolder(transactionID);
                        loadTransactions.put(transactionID, tx);
                    }
                    tx.recordsToDelete.add(info);
                    JournalTransaction tnp = (JournalTransaction)JournalImpl.this.transactions.get(transactionID);
                    if (tnp == null) {
                        tnp = new JournalTransaction(transactionID, JournalImpl.this);
                        JournalImpl.this.transactions.put(transactionID, tnp);
                    }
                    tnp.addNegative(file, info.id);
                }

                public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
                    boolean healthy;
                    if (trace) {
                        // empty if block
                    }
                    hasData.set(true);
                    TransactionHolder tx = (TransactionHolder)loadTransactions.get(transactionID);
                    if (tx == null) {
                        tx = new TransactionHolder(transactionID);
                        loadTransactions.put(transactionID, tx);
                    }
                    tx.prepared = true;
                    tx.extraData = extraData;
                    JournalTransaction journalTransaction = (JournalTransaction)JournalImpl.this.transactions.get(transactionID);
                    if (journalTransaction == null) {
                        journalTransaction = new JournalTransaction(transactionID, JournalImpl.this);
                        JournalImpl.this.transactions.put(transactionID, journalTransaction);
                    }
                    if (healthy = JournalImpl.this.checkTransactionHealth(file, journalTransaction, orderedFiles, numberOfRecords)) {
                        journalTransaction.prepare(file);
                    } else {
                        log.warn("Prepared transaction " + transactionID + " wasn't considered completed, it will be ignored");
                        tx.invalid = true;
                    }
                }

                public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
                    TransactionHolder tx;
                    if (trace) {
                        // empty if block
                    }
                    if ((tx = (TransactionHolder)loadTransactions.remove(transactionID)) != null) {
                        JournalTransaction journalTransaction = (JournalTransaction)JournalImpl.this.transactions.remove(transactionID);
                        if (journalTransaction == null) {
                            throw new IllegalStateException("Cannot find tx " + transactionID);
                        }
                        boolean healthy = JournalImpl.this.checkTransactionHealth(file, journalTransaction, orderedFiles, numberOfRecords);
                        if (healthy) {
                            for (RecordInfo txRecord : tx.recordInfos) {
                                if (txRecord.isUpdate) {
                                    loadManager.updateRecord(txRecord);
                                    continue;
                                }
                                loadManager.addRecord(txRecord);
                            }
                            for (RecordInfo deleteValue : tx.recordsToDelete) {
                                loadManager.deleteRecord(deleteValue.id);
                            }
                            journalTransaction.commit(file);
                        } else {
                            log.warn("Transaction " + transactionID + " is missing elements so the transaction is being ignored");
                            journalTransaction.forget();
                        }
                        hasData.set(true);
                    }
                }

                public void onReadRollbackRecord(long transactionID) throws Exception {
                    TransactionHolder tx;
                    if (trace) {
                        // empty if block
                    }
                    if ((tx = (TransactionHolder)loadTransactions.remove(transactionID)) != null) {
                        JournalTransaction tnp = (JournalTransaction)JournalImpl.this.transactions.remove(transactionID);
                        if (tnp == null) {
                            throw new IllegalStateException("Cannot find tx " + transactionID);
                        }
                        tnp.rollback(file);
                        hasData.set(true);
                    }
                }

                public void markAsDataFile(JournalFile file2) {
                    if (trace) {
                        // empty if block
                    }
                    hasData.set(true);
                }
            });
            if (hasData.get()) {
                lastDataPos = resultLastPost;
                this.dataFiles.add(file);
                continue;
            }
            this.freeFiles.add(file);
        }
        int filesToCreate = this.minFiles - (this.dataFiles.size() + this.freeFiles.size());
        if (filesToCreate > 0) {
            for (int i = 0; i < filesToCreate; ++i) {
                this.freeFiles.add(this.createFile(false, false, true, false));
            }
        }
        Iterator<JournalFile> iter = this.dataFiles.iterator();
        while (iter.hasNext()) {
            this.currentFile = iter.next();
            if (iter.hasNext()) continue;
            iter.remove();
        }
        if (this.currentFile != null) {
            this.currentFile.getFile().open();
            this.currentFile.getFile().position(this.currentFile.getFile().calculateBlockStart(lastDataPos));
        } else {
            this.currentFile = this.freeFiles.remove();
            this.openFile(this.currentFile, true);
        }
        this.fileFactory.activateBuffer(this.currentFile.getFile());
        this.pushOpenedFile();
        for (TransactionHolder transaction : loadTransactions.values()) {
            if (!transaction.prepared || transaction.invalid) {
                log.warn("Uncommitted transaction with id " + transaction.transactionID + " found and discarded");
                JournalTransaction transactionInfo = (JournalTransaction)this.transactions.get(transaction.transactionID);
                if (transactionInfo == null) {
                    throw new IllegalStateException("Cannot find tx " + transaction.transactionID);
                }
                transactionInfo.forget();
                this.transactions.remove(transaction.transactionID);
                loadManager.failedTransaction(transaction.transactionID, transaction.recordInfos, transaction.recordsToDelete);
                continue;
            }
            for (RecordInfo info : transaction.recordInfos) {
                if (info.id <= maxID.get()) continue;
                maxID.set(info.id);
            }
            PreparedTransactionInfo info = new PreparedTransactionInfo(transaction.transactionID, transaction.extraData);
            info.records.addAll(transaction.recordInfos);
            info.recordsToDelete.addAll(transaction.recordsToDelete);
            loadManager.addPreparedTransaction(info);
        }
        this.state = 2;
        this.checkReclaimStatus();
        return new JournalLoadInformation(this.records.size(), maxID.longValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkReclaimStatus() throws Exception {
        block10: {
            this.compactingLock.readLock().lock();
            try {
                this.reclaimer.scan(this.getDataFiles());
                for (JournalFile file : this.dataFiles) {
                    if (!file.isCanReclaim()) continue;
                    if (trace) {
                        JournalImpl.trace("Reclaiming file " + file);
                    }
                    if (!this.dataFiles.remove(file)) {
                        log.warn("Could not remove file " + file);
                    }
                    this.addFreeFile(file);
                }
                int nCleanup = 0;
                for (JournalFile file : this.dataFiles) {
                    if (!file.isNeedCleanup()) continue;
                    ++nCleanup;
                }
                if (this.compactMinFiles <= 0 || !((float)nCleanup > this.getMinCompact())) break block10;
                for (JournalFile file : this.dataFiles) {
                    if (!file.isNeedCleanup()) continue;
                    final JournalFile cleanupFile = file;
                    if (this.compactorRunning.compareAndSet(false, true)) {
                        this.compactorExecutor.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    JournalImpl.this.cleanUp(cleanupFile);
                                }
                                catch (Exception e) {
                                    log.warn(e.getMessage(), e);
                                }
                                finally {
                                    JournalImpl.this.compactorRunning.set(false);
                                    if (JournalImpl.this.autoReclaim) {
                                        JournalImpl.this.scheduleReclaim();
                                    }
                                }
                            }
                        });
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.compactingLock.readLock().unlock();
            }
        }
        return false;
    }

    private float getMinCompact() {
        return (float)this.compactMinFiles * this.compactPercentage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanUp(JournalFile file) throws Exception {
        if (this.state != 2) {
            return;
        }
        this.compactingLock.readLock().lock();
        try {
            JournalCleaner cleaner = null;
            ArrayList<JournalFile> dependencies = new ArrayList<JournalFile>();
            this.lockAppend.lock();
            try {
                if (trace) {
                    JournalImpl.trace("Cleaning up file " + file);
                }
                log.debug("Cleaning up file " + file);
                if (file.getPosCount() == 0) {
                    return;
                }
                file.incPosCount();
                for (JournalFile jrnFile : this.dataFiles) {
                    if (!jrnFile.resetNegCount(file)) continue;
                    dependencies.add(jrnFile);
                    jrnFile.incPosCount();
                }
                cleaner = new JournalCleaner(this.fileFactory, this, this.records.keySet(), file.getFileID());
            }
            finally {
                this.lockAppend.unlock();
            }
            JournalImpl.readJournalFile(this.fileFactory, file, cleaner);
            cleaner.flush();
            cleaner.fixDependencies(file, dependencies);
            for (JournalFile jrnfile : dependencies) {
                jrnfile.decPosCount();
            }
            file.decPosCount();
            SequentialFile tmpFile = cleaner.currentFile.getFile();
            String tmpFileName = tmpFile.getFileName();
            String cleanedFileName = file.getFile().getFileName();
            SequentialFile controlFile = this.createControlFile(null, null, new Pair<String, String>(tmpFileName, cleanedFileName));
            file.getFile().delete();
            tmpFile.renameTo(cleanedFileName);
            controlFile.delete();
        }
        finally {
            this.compactingLock.readLock().unlock();
            log.debug("Clean up on file " + file + " done");
        }
    }

    private void checkCompact() throws Exception {
        if (this.compactMinFiles == 0) {
            return;
        }
        JournalFile[] dataFiles = this.getDataFiles();
        long totalLiveSize = 0L;
        for (JournalFile file : dataFiles) {
            totalLiveSize += (long)file.getLiveSize();
        }
        long totalBytes = (long)dataFiles.length * (long)this.fileSize;
        long compactMargin = (long)((float)totalBytes * this.compactPercentage);
        if (totalLiveSize < compactMargin && !this.compactorRunning.get() && dataFiles.length > this.compactMinFiles) {
            if (!this.compactorRunning.compareAndSet(false, true)) {
                return;
            }
            this.compactorExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        JournalImpl.this.compact();
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), e);
                    }
                    finally {
                        JournalImpl.this.compactorRunning.set(false);
                    }
                }
            });
        }
    }

    @Override
    public void setAutoReclaim(boolean autoReclaim) {
        this.autoReclaim = autoReclaim;
    }

    @Override
    public boolean isAutoReclaim() {
        return this.autoReclaim;
    }

    @Override
    public String debug() throws Exception {
        this.reclaimer.scan(this.getDataFiles());
        StringBuilder builder = new StringBuilder();
        for (JournalFile file : this.dataFiles) {
            builder.append("DataFile:" + file + " posCounter = " + file.getPosCount() + " reclaimStatus = " + file.isCanReclaim() + " live size = " + file.getLiveSize() + "\n");
            if (!(file instanceof JournalFileImpl)) continue;
            builder.append(((JournalFileImpl)file).debug());
        }
        for (JournalFile file : this.freeFiles) {
            builder.append("FreeFile:" + file + "\n");
        }
        if (this.currentFile != null) {
            builder.append("CurrentFile:" + this.currentFile + " posCounter = " + this.currentFile.getPosCount() + "\n");
            if (this.currentFile instanceof JournalFileImpl) {
                builder.append(((JournalFileImpl)this.currentFile).debug());
            }
        } else {
            builder.append("CurrentFile: No current file at this point!");
        }
        builder.append("#Opened Files:" + this.openedFiles.size());
        return builder.toString();
    }

    @Override
    public void debugWait() throws Exception {
        this.fileFactory.flush();
        for (JournalTransaction tx : this.transactions.values()) {
            tx.waitCallbacks();
        }
        if (this.filesExecutor != null && !this.filesExecutor.isShutdown()) {
            final CountDownLatch latch = new CountDownLatch(1);
            this.filesExecutor.execute(new Runnable(){

                public void run() {
                    latch.countDown();
                }
            });
            latch.await();
        }
    }

    @Override
    public int getDataFilesCount() {
        return this.dataFiles.size();
    }

    @Override
    public JournalFile[] getDataFiles() {
        return this.dataFiles.toArray(new JournalFile[this.dataFiles.size()]);
    }

    @Override
    public int getFreeFilesCount() {
        return this.freeFiles.size();
    }

    @Override
    public int getOpenedFilesCount() {
        return this.openedFiles.size();
    }

    @Override
    public int getIDMapSize() {
        return this.records.size();
    }

    @Override
    public int getFileSize() {
        return this.fileSize;
    }

    @Override
    public int getMinFiles() {
        return this.minFiles;
    }

    @Override
    public String getFilePrefix() {
        return this.filePrefix;
    }

    @Override
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public int getMaxAIO() {
        return this.maxAIO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceMoveNextFile() throws Exception {
        this.compactingLock.readLock().lock();
        try {
            this.lockAppend.lock();
            try {
                this.moveNextFile(true);
                if (this.autoReclaim) {
                    this.checkReclaimStatus();
                }
                this.debugWait();
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void perfBlast(int pages) throws Exception {
        new PerfBlast(pages).start();
    }

    @Override
    public synchronized boolean isStarted() {
        return this.state != 0;
    }

    @Override
    public synchronized void start() {
        if (this.state != 0) {
            throw new IllegalStateException("Journal is not stopped");
        }
        this.filesExecutor = Executors.newSingleThreadExecutor();
        this.compactorExecutor = Executors.newCachedThreadPool();
        this.fileFactory.start();
        this.state = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() throws Exception {
        JournalImpl.trace("Stopping the journal");
        if (this.state == 0) {
            throw new IllegalStateException("Journal is already stopped");
        }
        this.lockAppend.lock();
        try {
            this.filesExecutor.shutdown();
            if (!this.filesExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                log.warn("Couldn't stop journal executor after 60 seconds");
            }
            this.fileFactory.deactivateBuffer();
            if (this.currentFile != null && this.currentFile.getFile().isOpen()) {
                this.currentFile.getFile().close();
            }
            for (JournalFile file : this.openedFiles) {
                file.getFile().close();
            }
            this.fileFactory.stop();
            this.currentFile = null;
            this.dataFiles.clear();
            this.freeFiles.clear();
            this.openedFiles.clear();
            this.state = 0;
        }
        finally {
            this.lockAppend.unlock();
        }
    }

    @Override
    public int getNumberOfRecords() {
        return this.records.size();
    }

    protected SequentialFile createControlFile(List<JournalFile> files, List<JournalFile> newFiles, Pair<String, String> cleanupRename) throws Exception {
        ArrayList<Pair<String, String>> cleanupList;
        if (cleanupRename == null) {
            cleanupList = null;
        } else {
            cleanupList = new ArrayList<Pair<String, String>>();
            cleanupList.add(cleanupRename);
        }
        return AbstractJournalUpdateTask.writeControlFile(this.fileFactory, files, newFiles, cleanupList);
    }

    protected void deleteControlFile(SequentialFile controlFile) throws Exception {
        controlFile.delete();
    }

    protected void renameFiles(List<JournalFile> oldFiles, List<JournalFile> newFiles) throws Exception {
        for (JournalFile file : oldFiles) {
            this.addFreeFile(file);
        }
        for (JournalFile file : newFiles) {
            String newName = file.getFile().getFileName();
            newName = newName.substring(0, newName.lastIndexOf(".cmp"));
            file.getFile().renameTo(newName);
        }
    }

    protected void onCompactDone() {
    }

    private void addFreeFile(JournalFile file) throws Exception {
        if (this.freeFiles.size() + this.dataFiles.size() + 1 + this.openedFiles.size() < this.minFiles) {
            JournalFile jf = this.reinitializeFile(file);
            this.freeFiles.add(jf);
        } else {
            file.getFile().delete();
        }
    }

    private JournalFile reinitializeFile(JournalFile file) throws Exception {
        int newFileID = this.generateFileID();
        SequentialFile sf = file.getFile();
        sf.open(1, false);
        sf.position(0L);
        ByteBuffer bb = this.fileFactory.newBuffer(4);
        bb.putInt(newFileID);
        bb.rewind();
        sf.writeDirect(bb, true);
        JournalFileImpl jf = new JournalFileImpl(sf, newFileID);
        sf.position(bb.limit());
        sf.close();
        return jf;
    }

    private boolean checkTransactionHealth(JournalFile currentFile, JournalTransaction journalTransaction, List<JournalFile> orderedFiles, int numberOfRecords) {
        return journalTransaction.getCounter(currentFile) == numberOfRecords;
    }

    private static boolean isTransaction(byte recordType) {
        return recordType == 13 || recordType == 14 || recordType == 15 || JournalImpl.isCompleteTransaction(recordType);
    }

    private static boolean isCompleteTransaction(byte recordType) {
        return recordType == 18 || recordType == 17 || recordType == 19;
    }

    private static boolean isContainsBody(byte recordType) {
        return recordType >= 11 && recordType <= 15;
    }

    private static int getRecordSize(byte recordType) {
        int recordSize = 0;
        switch (recordType) {
            case 11: {
                recordSize = 22;
                break;
            }
            case 12: {
                recordSize = 22;
                break;
            }
            case 13: {
                recordSize = 30;
                break;
            }
            case 14: {
                recordSize = 30;
                break;
            }
            case 16: {
                recordSize = 17;
                break;
            }
            case 15: {
                recordSize = 29;
                break;
            }
            case 17: {
                recordSize = 25;
                break;
            }
            case 18: {
                recordSize = 21;
                break;
            }
            case 19: {
                recordSize = 17;
                break;
            }
            default: {
                throw new IllegalStateException("Record other than expected");
            }
        }
        return recordSize;
    }

    private List<JournalFile> orderFiles() throws Exception {
        List<String> fileNames = this.fileFactory.listFiles(this.fileExtension);
        ArrayList<JournalFile> orderedFiles = new ArrayList<JournalFile>(fileNames.size());
        for (String fileName : fileNames) {
            SequentialFile file = this.fileFactory.createSequentialFile(fileName, this.maxAIO);
            file.open(1, false);
            ByteBuffer bb = this.fileFactory.newBuffer(4);
            file.read(bb);
            int fileID = bb.getInt();
            this.fileFactory.releaseBuffer(bb);
            bb = null;
            if (this.nextFileID.get() < fileID) {
                this.nextFileID.set(fileID);
            }
            int fileNameID = this.getFileNameID(fileName);
            if (this.nextFileID.get() < fileNameID) {
                this.nextFileID.set(fileNameID);
            }
            orderedFiles.add(new JournalFileImpl(file, fileID));
            file.close();
        }
        Collections.sort(orderedFiles, new JournalFileComparator());
        return orderedFiles;
    }

    private JournalFile appendRecord(JournalInternalRecord encoder, boolean completeTransaction, boolean sync, JournalTransaction tx, IOAsyncTask parameterCallback) throws Exception {
        IOAsyncTask callback;
        if (this.state != 2) {
            throw new IllegalStateException("The journal is not loaded " + this.state);
        }
        int size = encoder.getEncodeSize();
        if (size > this.fileSize - this.currentFile.getFile().calculateBlockStart(4)) {
            throw new IllegalArgumentException("Record is too large to store " + size);
        }
        if (!this.currentFile.getFile().fits(size)) {
            this.moveNextFile(false);
            if (!this.currentFile.getFile().fits(size)) {
                throw new IllegalStateException("Invalid logic on buffer allocation");
            }
        }
        if (this.currentFile == null) {
            throw new NullPointerException("Current file = null");
        }
        if (tx != null) {
            if (this.fileFactory.isSupportsCallbacks()) {
                TransactionCallback txcallback = tx.getCallback(this.currentFile);
                if (parameterCallback != null) {
                    txcallback.setDelegateCompletion(parameterCallback);
                }
                callback = txcallback;
            } else {
                callback = null;
            }
            if (sync) {
                tx.syncPreviousFiles(this.fileFactory.isSupportsCallbacks(), this.currentFile);
            }
            if (completeTransaction) {
                tx.fillNumberOfRecords(this.currentFile, encoder);
            }
        } else {
            callback = parameterCallback;
        }
        encoder.setFileID(this.currentFile.getFileID());
        if (callback != null) {
            this.currentFile.getFile().write(encoder, sync, callback);
        } else {
            this.currentFile.getFile().write(encoder, sync);
        }
        return this.currentFile;
    }

    private int getFileNameID(String fileName) {
        try {
            return Integer.parseInt(fileName.substring(this.filePrefix.length() + 1, fileName.indexOf(46)));
        }
        catch (Throwable e) {
            log.warn("Impossible to get the ID part of the file name " + fileName, e);
            return 0;
        }
    }

    private JournalFile createFile(boolean keepOpened, boolean multiAIO, boolean fill, boolean tmpCompact) throws Exception {
        int fileID = this.generateFileID();
        String fileName = tmpCompact ? this.filePrefix + "-" + fileID + "." + this.fileExtension + ".cmp" : this.filePrefix + "-" + fileID + "." + this.fileExtension;
        if (trace) {
            JournalImpl.trace("Creating file " + fileName);
        }
        String tmpFileName = fileName + ".tmp";
        SequentialFile sequentialFile = this.fileFactory.createSequentialFile(tmpFileName, this.maxAIO);
        sequentialFile.open(1, false);
        if (fill) {
            sequentialFile.fill(0, this.fileSize, (byte)74);
            ByteBuffer bb = this.fileFactory.newBuffer(4);
            bb.putInt(fileID);
            bb.rewind();
            sequentialFile.writeDirect(bb, true);
        }
        long position = sequentialFile.position();
        sequentialFile.close();
        sequentialFile.renameTo(fileName);
        if (keepOpened) {
            if (multiAIO) {
                sequentialFile.open();
            } else {
                sequentialFile.open(1, false);
            }
            sequentialFile.position(position);
        }
        return new JournalFileImpl(sequentialFile, fileID);
    }

    private void openFile(JournalFile file, boolean multiAIO) throws Exception {
        if (multiAIO) {
            file.getFile().open();
        } else {
            file.getFile().open(1, false);
        }
        file.getFile().position(file.getFile().calculateBlockStart(4));
    }

    private int generateFileID() {
        return this.nextFileID.incrementAndGet();
    }

    private void moveNextFile(boolean synchronous) throws InterruptedException {
        this.closeFile(this.currentFile, synchronous);
        this.currentFile = this.enqueueOpenFile(synchronous);
        if (trace) {
            JournalImpl.trace("moveNextFile: " + this.currentFile.getFile().getFileName() + " sync: " + synchronous);
        }
        this.fileFactory.activateBuffer(this.currentFile.getFile());
    }

    private JournalFile enqueueOpenFile(boolean synchronous) throws InterruptedException {
        if (trace) {
            JournalImpl.trace("enqueueOpenFile with openedFiles.size=" + this.openedFiles.size());
        }
        Runnable run = new Runnable(){

            public void run() {
                try {
                    JournalImpl.this.pushOpenedFile();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e);
                }
            }
        };
        if (synchronous) {
            run.run();
        } else {
            this.filesExecutor.execute(run);
        }
        if (this.autoReclaim && !synchronous) {
            this.scheduleReclaim();
        }
        JournalFile nextFile = null;
        while (nextFile == null) {
            nextFile = this.openedFiles.poll(60L, TimeUnit.SECONDS);
            if (nextFile != null) continue;
            log.warn("Couldn't open a file in 60 Seconds", new Exception("Warning: Couldn't open a file in 60 Seconds"));
        }
        return nextFile;
    }

    private void scheduleReclaim() {
        if (this.state != 2) {
            return;
        }
        this.filesExecutor.execute(new Runnable(){

            public void run() {
                try {
                    if (!JournalImpl.this.checkReclaimStatus()) {
                        JournalImpl.this.checkCompact();
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e);
                }
            }
        });
    }

    private void pushOpenedFile() throws Exception {
        JournalFile nextOpenedFile = this.getFile(true, true, true, false);
        this.openedFiles.offer(nextOpenedFile);
    }

    JournalFile getFile(boolean keepOpened, boolean multiAIO, boolean fill, boolean tmpCompactExtension) throws Exception {
        JournalFile nextOpenedFile = null;
        try {
            nextOpenedFile = this.freeFiles.remove();
            if (tmpCompactExtension) {
                SequentialFile sequentialFile = nextOpenedFile.getFile();
                sequentialFile.renameTo(sequentialFile.getFileName() + ".cmp");
            }
        }
        catch (NoSuchElementException ignored) {
            // empty catch block
        }
        if (nextOpenedFile == null) {
            nextOpenedFile = this.createFile(keepOpened, multiAIO, fill, tmpCompactExtension);
        } else if (keepOpened) {
            this.openFile(nextOpenedFile, multiAIO);
        }
        return nextOpenedFile;
    }

    private void closeFile(final JournalFile file, boolean synchronous) {
        this.fileFactory.deactivateBuffer();
        this.pendingCloseFiles.add(file);
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JournalImpl.this.compactingLock.readLock().lock();
                try {
                    if (JournalImpl.this.pendingCloseFiles.remove(file)) {
                        JournalImpl.this.dataFiles.add(file);
                        if (file.getFile().isOpen()) {
                            file.getFile().close();
                        }
                    }
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), e);
                }
                finally {
                    JournalImpl.this.compactingLock.readLock().unlock();
                }
            }
        };
        if (synchronous) {
            run.run();
        } else {
            this.filesExecutor.execute(run);
        }
    }

    private JournalTransaction getTransactionInfo(long txID) {
        JournalTransaction tx = (JournalTransaction)this.transactions.get(txID);
        if (tx == null) {
            tx = new JournalTransaction(txID, this);
            JournalTransaction trans = this.transactions.putIfAbsent(txID, tx);
            if (trans != null) {
                tx = trans;
            }
        }
        return tx;
    }

    private SyncIOCompletion getSyncCallback(boolean sync) {
        if (this.fileFactory.isSupportsCallbacks()) {
            if (sync) {
                return new SimpleWaitIOCallback();
            }
            return DummyCallback.getInstance();
        }
        return null;
    }

    private void checkControlFile() throws Exception {
        ArrayList<String> dataFiles = new ArrayList<String>();
        ArrayList<String> newFiles = new ArrayList<String>();
        ArrayList<Pair<String, String>> renames = new ArrayList<Pair<String, String>>();
        SequentialFile controlFile = JournalCompactor.readControlFile(this.fileFactory, dataFiles, newFiles, renames);
        if (controlFile != null) {
            SequentialFile file;
            for (String string : dataFiles) {
                file = this.fileFactory.createSequentialFile(string, 1);
                if (!file.exists()) continue;
                file.delete();
            }
            for (String string : newFiles) {
                file = this.fileFactory.createSequentialFile(string, 1);
                if (!file.exists()) continue;
                String originalName = file.getFileName();
                String newName = originalName.substring(0, originalName.lastIndexOf(".cmp"));
                file.renameTo(newName);
            }
            for (Pair pair : renames) {
                SequentialFile fileTmp = this.fileFactory.createSequentialFile((String)pair.a, 1);
                SequentialFile fileTo = this.fileFactory.createSequentialFile((String)pair.b, 1);
                if (!fileTmp.exists()) continue;
                fileTo.delete();
                fileTmp.renameTo((String)pair.b);
            }
            controlFile.delete();
        }
        this.cleanupTmpFiles(".cmp");
        this.cleanupTmpFiles(".tmp");
    }

    private void cleanupTmpFiles(String extension) throws Exception {
        List<String> leftFiles = this.fileFactory.listFiles(this.getFileExtension() + extension);
        if (leftFiles.size() > 0) {
            log.warn("Temporary files were left unnatended after a crash on journal directory, deleting invalid files now");
            for (String fileToDelete : leftFiles) {
                log.warn("Deleting unnatended file " + fileToDelete);
                SequentialFile file = this.fileFactory.createSequentialFile(fileToDelete, 1);
                file.delete();
            }
        }
    }

    private static boolean isInvalidSize(int fileSize, int bufferPos, int size) {
        if (size < 0) {
            return true;
        }
        int position = bufferPos + size;
        return position > fileSize || position < 0;
    }

    private HornetQBuffer newBuffer(int size) {
        return HornetQBuffers.fixedBuffer(size);
    }

    static /* synthetic */ void access$300(String x0) {
        JournalImpl.trace(x0);
    }

    private class PerfBlast
    extends Thread {
        private final int pages;

        private PerfBlast(int pages) {
            super("hornetq-perfblast-thread");
            this.pages = pages;
        }

        public void run() {
            try {
                JournalImpl.this.lockAppend.lock();
                final ByteArrayEncoding byteEncoder = new ByteArrayEncoding(new byte[131072]);
                JournalInternalRecord blastRecord = new JournalInternalRecord(){

                    public int getEncodeSize() {
                        return byteEncoder.getEncodeSize();
                    }

                    public void encode(HornetQBuffer buffer) {
                        byteEncoder.encode(buffer);
                    }
                };
                for (int i = 0; i < this.pages; ++i) {
                    JournalImpl.this.appendRecord(blastRecord, false, false, null, null);
                }
                JournalImpl.this.lockAppend.unlock();
            }
            catch (Exception e) {
                log.error("Failed to perf blast", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JournalFileComparator
    implements Comparator<JournalFile> {
        private JournalFileComparator() {
        }

        @Override
        public int compare(JournalFile f1, JournalFile f2) {
            int id2;
            int id1 = f1.getFileID();
            return id1 < (id2 = f2.getFileID()) ? -1 : (id1 == id2 ? 0 : 1);
        }
    }

    private static class TransactionHolder {
        public final long transactionID;
        public final List<RecordInfo> recordInfos = new ArrayList<RecordInfo>();
        public final List<RecordInfo> recordsToDelete = new ArrayList<RecordInfo>();
        public boolean prepared;
        public boolean invalid;
        public byte[] extraData;

        public TransactionHolder(long id) {
            this.transactionID = id;
        }
    }

    private static class NullEncoding
    implements EncodingSupport {
        private static NullEncoding instance = new NullEncoding();

        private NullEncoding() {
        }

        public static NullEncoding getInstance() {
            return instance;
        }

        public void decode(HornetQBuffer buffer) {
        }

        public void encode(HornetQBuffer buffer) {
        }

        public int getEncodeSize() {
            return 0;
        }
    }

    public static class JournalRecord {
        private final JournalFile addFile;
        private final int size;
        private List<Pair<JournalFile, Integer>> updateFiles;

        JournalRecord(JournalFile addFile, int size) {
            this.addFile = addFile;
            this.size = size;
            addFile.incPosCount();
            addFile.addSize(size);
        }

        void addUpdateFile(JournalFile updateFile, int size) {
            if (this.updateFiles == null) {
                this.updateFiles = new ArrayList<Pair<JournalFile, Integer>>();
            }
            this.updateFiles.add(new Pair<JournalFile, Integer>(updateFile, size));
            updateFile.incPosCount();
            updateFile.addSize(size);
        }

        void delete(JournalFile file) {
            file.incNegCount(this.addFile);
            this.addFile.decSize(this.size);
            if (this.updateFiles != null) {
                for (Pair<JournalFile, Integer> updFile : this.updateFiles) {
                    file.incNegCount((JournalFile)updFile.a);
                    ((JournalFile)updFile.a).decSize((Integer)updFile.b);
                }
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("JournalRecord(add=" + this.addFile.getFile().getFileName());
            if (this.updateFiles != null) {
                for (Pair<JournalFile, Integer> update : this.updateFiles) {
                    buffer.append(", update=" + ((JournalFile)update.a).getFile().getFileName());
                }
            }
            buffer.append(")");
            return buffer.toString();
        }
    }
}

