/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.nio.ByteBuffer;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.AbstractSequentialFileFactory;
import org.hornetq.core.journal.impl.NIOSequentialFile;
import org.hornetq.core.logging.Logger;

public class NIOSequentialFileFactory
extends AbstractSequentialFileFactory
implements SequentialFileFactory {
    private static final Logger log = Logger.getLogger(NIOSequentialFileFactory.class);

    public NIOSequentialFileFactory(String journalDir) {
        this(journalDir, false, 501760, 3333333, false);
    }

    public NIOSequentialFileFactory(String journalDir, boolean buffered) {
        this(journalDir, buffered, 501760, 3333333, false);
    }

    public NIOSequentialFileFactory(String journalDir, boolean buffered, int bufferSize, int bufferTimeout, boolean logRates) {
        super(journalDir, buffered, bufferSize, bufferTimeout, logRates);
    }

    public SequentialFile createSequentialFile(String fileName, int maxIO) {
        if (maxIO < 1) {
            maxIO = 1;
        }
        return new NIOSequentialFile(this, this.journalDir, fileName, maxIO, this.writeExecutor);
    }

    public boolean isSupportsCallbacks() {
        return this.timedBuffer != null;
    }

    public ByteBuffer newBuffer(int size) {
        return ByteBuffer.allocate(size);
    }

    public void clearBuffer(ByteBuffer buffer) {
        int limit = buffer.limit();
        buffer.rewind();
        for (int i = 0; i < limit; ++i) {
            buffer.put((byte)0);
        }
        buffer.rewind();
    }

    public ByteBuffer wrapBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    public int getAlignment() {
        return 1;
    }

    public int calculateBlockSize(int bytes) {
        return bytes;
    }
}

