/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.management.impl.HornetQServerControlImpl;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.remoting.Channel;
import org.hornetq.core.remoting.RemotingConnection;
import org.hornetq.core.remoting.impl.wireformat.CreateSessionResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.ReattachSessionResponseMessage;
import org.hornetq.core.remoting.server.RemotingService;
import org.hornetq.core.replication.ReplicationEndpoint;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.ActivateCallback;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.QueueFactory;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.cluster.ClusterManager;
import org.hornetq.core.server.group.GroupingHandler;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.core.version.Version;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.hornetq.utils.ExecutorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface HornetQServer
extends HornetQComponent {
    public Configuration getConfiguration();

    public RemotingService getRemotingService();

    public StorageManager getStorageManager();

    public ManagementService getManagementService();

    public HornetQSecurityManager getSecurityManager();

    public MBeanServer getMBeanServer();

    public Version getVersion();

    public HornetQServerControlImpl getHornetQServerControl();

    public void registerActivateCallback(ActivateCallback var1);

    public void unregisterActivateCallback(ActivateCallback var1);

    public ReattachSessionResponseMessage reattachSession(RemotingConnection var1, String var2, int var3) throws Exception;

    public ReplicationEndpoint connectToReplicationEndpoint(Channel var1) throws Exception;

    public CreateSessionResponseMessage createSession(String var1, long var2, String var4, String var5, int var6, int var7, RemotingConnection var8, boolean var9, boolean var10, boolean var11, boolean var12, int var13) throws Exception;

    public void removeSession(String var1) throws Exception;

    public ServerSession getSession(String var1);

    public Set<ServerSession> getSessions();

    @Override
    public boolean isStarted();

    public HierarchicalRepository<Set<Role>> getSecurityRepository();

    public HierarchicalRepository<AddressSettings> getAddressSettingsRepository();

    public int getConnectionCount();

    public PostOffice getPostOffice();

    public QueueFactory getQueueFactory();

    public ResourceManager getResourceManager();

    public List<ServerSession> getSessions(String var1);

    public ClusterManager getClusterManager();

    public SimpleString getNodeID();

    public boolean isInitialised();

    public Queue createQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5) throws Exception;

    public Queue deployQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5) throws Exception;

    public void destroyQueue(SimpleString var1, ServerSession var2) throws Exception;

    public ExecutorFactory getExecutorFactory();

    public void setGroupingHandler(GroupingHandler var1);

    public GroupingHandler getGroupingHandler();
}

