/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.list.PriorityLinkedList;
import org.hornetq.core.list.impl.PriorityLinkedListImpl;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.Bindings;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.Consumer;
import org.hornetq.core.server.HandleStatus;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.RoutingContext;
import org.hornetq.core.server.ScheduledDeliveryHandler;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.impl.Redistributor;
import org.hornetq.core.server.impl.ScheduledDeliveryHandlerImpl;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionOperation;
import org.hornetq.core.transaction.impl.TransactionImpl;
import org.hornetq.utils.ConcurrentHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueImpl
implements Queue {
    private static final Logger log = Logger.getLogger(QueueImpl.class);
    public static final int REDISTRIBUTOR_BATCH_SIZE = 100;
    public static final int NUM_PRIORITIES = 10;
    private final long id;
    private final SimpleString name;
    private volatile Filter filter;
    private final boolean durable;
    private final boolean temporary;
    private final PostOffice postOffice;
    private final PriorityLinkedList<MessageReference> messageReferences = new PriorityLinkedListImpl<MessageReference>(10);
    private final List<MessageHandler> handlers = new ArrayList<MessageHandler>();
    private final ScheduledDeliveryHandler scheduledDeliveryHandler;
    private boolean direct;
    private boolean promptDelivery;
    private final AtomicInteger messagesAdded = new AtomicInteger(0);
    protected final AtomicInteger deliveringCount = new AtomicInteger(0);
    private final AtomicBoolean waitingToDeliver = new AtomicBoolean(false);
    private boolean paused;
    private final Runnable deliverRunner = new DeliverRunner();
    private final StorageManager storageManager;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private final ScheduledExecutorService scheduledExecutor;
    private final SimpleString address;
    private Redistributor redistributor;
    private final Set<ScheduledFuture<?>> futures = new ConcurrentHashSet();
    private ScheduledFuture<?> future;
    private final Set<Consumer> consumerSet = new HashSet<Consumer>();
    private final ConcurrentMap<SimpleString, Consumer> groups = new ConcurrentHashMap<SimpleString, Consumer>();
    private volatile SimpleString expiryAddress;
    private int pos;
    private final Executor executor;

    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, boolean durable, boolean temporary, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, Executor executor) {
        this.id = id;
        this.address = address;
        this.name = name;
        this.filter = filter;
        this.durable = durable;
        this.temporary = temporary;
        this.postOffice = postOffice;
        this.storageManager = storageManager;
        this.addressSettingsRepository = addressSettingsRepository;
        this.scheduledExecutor = scheduledExecutor;
        this.direct = true;
        this.scheduledDeliveryHandler = new ScheduledDeliveryHandlerImpl(scheduledExecutor);
        this.expiryAddress = addressSettingsRepository != null ? addressSettingsRepository.getMatch(address.toString()).getExpiryAddress() : null;
        this.executor = executor;
    }

    public SimpleString getRoutingName() {
        return this.name;
    }

    public SimpleString getUniqueName() {
        return this.name;
    }

    public boolean isExclusive() {
        return false;
    }

    @Override
    public void route(ServerMessage message, RoutingContext context) throws Exception {
        context.addQueue(this);
    }

    @Override
    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void addLast(MessageReference ref) {
        this.add(ref, false);
    }

    @Override
    public void addFirst(MessageReference ref) {
        this.add(ref, true);
    }

    @Override
    public void deliverAsync() {
        if (this.waitingToDeliver.compareAndSet(false, true)) {
            this.executor.execute(this.deliverRunner);
        }
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    public synchronized void deliverNow() {
        this.deliverRunner.run();
    }

    @Override
    public synchronized void addConsumer(Consumer consumer) throws Exception {
        this.cancelRedistributor();
        MessageHandler handler = consumer.getFilter() != null ? new FilterMessageHandler(consumer, this.messageReferences.iterator()) : new NullFilterMessageHandler(consumer);
        this.handlers.add(handler);
        this.consumerSet.add(consumer);
    }

    @Override
    public synchronized boolean removeConsumer(Consumer consumer) throws Exception {
        boolean removed = this.removeHandlerGivenConsumer(consumer);
        if (this.handlers.isEmpty()) {
            this.promptDelivery = false;
        }
        this.consumerSet.remove(consumer);
        if (removed) {
            for (SimpleString groupID : this.groups.keySet()) {
                if (consumer != this.groups.get(groupID)) continue;
                this.groups.remove(groupID);
            }
        }
        return removed;
    }

    @Override
    public synchronized void addRedistributor(long delay) {
        if (this.future != null) {
            this.future.cancel(false);
            this.futures.remove(this.future);
        }
        if (this.redistributor != null) {
            this.deliverAsync();
        }
        if (delay > 0L) {
            if (this.consumerSet.isEmpty()) {
                DelayedAddRedistributor dar = new DelayedAddRedistributor(this.executor);
                this.future = this.scheduledExecutor.schedule(dar, delay, TimeUnit.MILLISECONDS);
                this.futures.add(this.future);
            }
        } else {
            this.internalAddRedistributor(this.executor);
        }
    }

    @Override
    public synchronized void cancelRedistributor() throws Exception {
        if (this.redistributor != null) {
            this.redistributor.stop();
            this.redistributor = null;
            this.removeHandlerGivenConsumer(this.redistributor);
        }
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
    }

    @Override
    public synchronized int getConsumerCount() {
        return this.consumerSet.size();
    }

    public synchronized Set<Consumer> getConsumers() {
        return this.consumerSet;
    }

    @Override
    public synchronized boolean hasMatchingConsumer(ServerMessage message) {
        for (MessageHandler handler : this.handlers) {
            Consumer consumer = handler.getConsumer();
            if (consumer instanceof Redistributor) continue;
            Filter filter = consumer.getFilter();
            if (filter == null) {
                return true;
            }
            if (!filter.match(message)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<MessageReference> iterator() {
        return new Iterator<MessageReference>(){
            private final Iterator<MessageReference> iterator;
            {
                this.iterator = QueueImpl.this.messageReferences.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public MessageReference next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("iterator is immutable");
            }
        };
    }

    @Override
    public MessageReference removeReferenceWithID(long id) throws Exception {
        Iterator<MessageReference> iterator = this.messageReferences.iterator();
        MessageReference removed = null;
        while (iterator.hasNext()) {
            MessageReference ref = iterator.next();
            if (ref.getMessage().getMessageID() != id) continue;
            iterator.remove();
            removed = ref;
            break;
        }
        if (removed == null) {
            removed = this.scheduledDeliveryHandler.removeReferenceWithID(id);
        }
        return removed;
    }

    @Override
    public synchronized MessageReference removeFirstReference(long id) throws Exception {
        MessageReference ref = this.messageReferences.peekFirst();
        if (ref != null && ref.getMessage().getMessageID() == id) {
            this.messageReferences.removeFirst();
            return ref;
        }
        ref = this.scheduledDeliveryHandler.removeReferenceWithID(id);
        return ref;
    }

    @Override
    public MessageReference getReference(long id) {
        for (MessageReference ref : this.messageReferences) {
            if (ref.getMessage().getMessageID() != id) continue;
            return ref;
        }
        return null;
    }

    @Override
    public synchronized int getMessageCount() {
        return this.messageReferences.size() + this.getScheduledCount() + this.getDeliveringCount();
    }

    @Override
    public synchronized int getScheduledCount() {
        return this.scheduledDeliveryHandler.getScheduledCount();
    }

    @Override
    public synchronized List<MessageReference> getScheduledMessages() {
        return this.scheduledDeliveryHandler.getScheduledReferences();
    }

    @Override
    public int getDeliveringCount() {
        return this.deliveringCount.get();
    }

    @Override
    public void acknowledge(MessageReference ref) throws Exception {
        boolean durableRef;
        ServerMessage message = ref.getMessage();
        boolean bl = durableRef = message.isDurable() && this.durable;
        if (durableRef) {
            this.storageManager.storeAcknowledge(this.id, message.getMessageID());
        }
        this.postAcknowledge(ref);
    }

    @Override
    public void acknowledge(Transaction tx, MessageReference ref) throws Exception {
        boolean durableRef;
        ServerMessage message = ref.getMessage();
        boolean bl = durableRef = message.isDurable() && this.durable;
        if (durableRef) {
            this.storageManager.storeAcknowledgeTransactional(tx.getID(), this.id, message.getMessageID());
            tx.setContainsPersistent();
        }
        this.getRefsOperation(tx).addAck(ref);
    }

    @Override
    public void reacknowledge(Transaction tx, MessageReference ref) throws Exception {
        ServerMessage message = ref.getMessage();
        if (message.isDurable() && this.durable) {
            tx.setContainsPersistent();
        }
        this.getRefsOperation(tx).addAck(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RefsOperation getRefsOperation(Transaction tx) {
        Transaction transaction = tx;
        synchronized (transaction) {
            RefsOperation oper = (RefsOperation)tx.getProperty(6);
            if (oper == null) {
                oper = new RefsOperation();
                tx.putProperty(6, oper);
                tx.addOperation(oper);
            }
            return oper;
        }
    }

    @Override
    public void cancel(Transaction tx, MessageReference reference) throws Exception {
        this.getRefsOperation(tx).addAck(reference);
    }

    @Override
    public synchronized void cancel(MessageReference reference) throws Exception {
        if (this.checkDLQ(reference) && !this.scheduledDeliveryHandler.checkAndSchedule(reference)) {
            this.messageReferences.addFirst(reference, reference.getMessage().getPriority());
        }
    }

    @Override
    public void expire(MessageReference ref) throws Exception {
        if (this.expiryAddress != null) {
            this.move(this.expiryAddress, ref, true);
        } else {
            this.acknowledge(ref);
        }
        this.storageManager.completeOperations();
    }

    @Override
    public void setExpiryAddress(SimpleString expiryAddress) {
        this.expiryAddress = expiryAddress;
    }

    @Override
    public void referenceHandled() {
        this.deliveringCount.incrementAndGet();
    }

    @Override
    public int getMessagesAdded() {
        return this.messagesAdded.get();
    }

    @Override
    public int deleteAllReferences() throws Exception {
        return this.deleteMatchingReferences(null);
    }

    @Override
    public int deleteMatchingReferences(Filter filter) throws Exception {
        int count = 0;
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        Iterator<MessageReference> iter = this.messageReferences.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (filter != null && !filter.match(ref.getMessage())) continue;
            this.deliveringCount.incrementAndGet();
            this.acknowledge(tx, ref);
            iter.remove();
            ++count;
        }
        List<MessageReference> cancelled = this.scheduledDeliveryHandler.cancel(filter);
        for (MessageReference messageReference : cancelled) {
            this.deliveringCount.incrementAndGet();
            this.acknowledge(tx, messageReference);
            ++count;
        }
        tx.commit();
        return count;
    }

    @Override
    public boolean deleteReference(long messageID) throws Exception {
        boolean deleted = false;
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        Iterator<MessageReference> iter = this.messageReferences.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (ref.getMessage().getMessageID() != messageID) continue;
            this.deliveringCount.incrementAndGet();
            this.acknowledge(tx, ref);
            iter.remove();
            deleted = true;
            break;
        }
        tx.commit();
        return deleted;
    }

    @Override
    public boolean expireReference(long messageID) throws Exception {
        Iterator<MessageReference> iter = this.messageReferences.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (ref.getMessage().getMessageID() != messageID) continue;
            this.deliveringCount.incrementAndGet();
            this.expire(ref);
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public int expireReferences(Filter filter) throws Exception {
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        int count = 0;
        Iterator<MessageReference> iter = this.messageReferences.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (filter != null && !filter.match(ref.getMessage())) continue;
            this.deliveringCount.incrementAndGet();
            this.expire(tx, ref);
            iter.remove();
            ++count;
        }
        tx.commit();
        return count;
    }

    @Override
    public void expireReferences() throws Exception {
        Iterator<MessageReference> iter = this.messageReferences.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (!ref.getMessage().isExpired()) continue;
            this.deliveringCount.incrementAndGet();
            this.expire(ref);
            iter.remove();
        }
    }

    @Override
    public boolean sendMessageToDeadLetterAddress(long messageID) throws Exception {
        Iterator<MessageReference> iter = this.messageReferences.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (ref.getMessage().getMessageID() != messageID) continue;
            this.deliveringCount.incrementAndGet();
            this.sendToDeadLetterAddress(ref);
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public int sendMessagesToDeadLetterAddress(Filter filter) throws Exception {
        int count = 0;
        Iterator<MessageReference> iter = this.messageReferences.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (filter != null && !filter.match(ref.getMessage())) continue;
            this.deliveringCount.incrementAndGet();
            this.sendToDeadLetterAddress(ref);
            iter.remove();
            ++count;
        }
        return count;
    }

    @Override
    public boolean moveReference(long messageID, SimpleString toAddress) throws Exception {
        Iterator<MessageReference> iter = this.messageReferences.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (ref.getMessage().getMessageID() != messageID) continue;
            iter.remove();
            this.deliveringCount.incrementAndGet();
            this.move(toAddress, ref);
            return true;
        }
        return false;
    }

    @Override
    public int moveReferences(Filter filter, SimpleString toAddress) throws Exception {
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        int count = 0;
        Iterator<MessageReference> iter = this.messageReferences.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (filter != null && !filter.match(ref.getMessage())) continue;
            this.deliveringCount.incrementAndGet();
            this.move(toAddress, tx, ref, false);
            iter.remove();
            ++count;
        }
        List<MessageReference> cancelled = this.scheduledDeliveryHandler.cancel(filter);
        for (MessageReference ref : cancelled) {
            this.deliveringCount.incrementAndGet();
            this.move(toAddress, tx, ref, false);
            this.acknowledge(tx, ref);
            ++count;
        }
        tx.commit();
        return count;
    }

    @Override
    public boolean changeReferencePriority(long messageID, byte newPriority) throws Exception {
        Iterator<MessageReference> iter = this.messageReferences.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (ref.getMessage().getMessageID() != messageID) continue;
            iter.remove();
            ref.getMessage().setPriority(newPriority);
            this.addLast(ref);
            return true;
        }
        return false;
    }

    @Override
    public int changeReferencesPriority(Filter filter, byte newPriority) throws Exception {
        Iterator<MessageReference> iter = this.messageReferences.iterator();
        int count = 0;
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (filter != null && !filter.match(ref.getMessage())) continue;
            ++count;
            iter.remove();
            ref.getMessage().setPriority(newPriority);
            this.addLast(ref);
        }
        return count;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        QueueImpl qother = (QueueImpl)other;
        return this.name.equals(qother.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "QueueImpl[name=" + this.name.toString() + "]@" + Integer.toHexString(System.identityHashCode(this));
    }

    private boolean removeHandlerGivenConsumer(Consumer consumer) {
        Iterator<MessageHandler> iter = this.handlers.iterator();
        boolean removed = false;
        while (iter.hasNext()) {
            MessageHandler handler = iter.next();
            if (handler.getConsumer() != consumer) continue;
            iter.remove();
            if (this.pos >= this.handlers.size()) {
                this.pos = 0;
            }
            removed = true;
            break;
        }
        return removed;
    }

    private void internalAddRedistributor(Executor executor) {
        if (this.consumerSet.isEmpty() && this.redistributor == null) {
            this.redistributor = new Redistributor(this, this.storageManager, this.postOffice, executor, 100);
            this.handlers.add(new NullFilterMessageHandler(this.redistributor));
            this.redistributor.start();
            this.deliverAsync();
        }
    }

    @Override
    public boolean checkDLQ(MessageReference reference) throws Exception {
        AddressSettings addressSettings;
        int maxDeliveries;
        ServerMessage message = reference.getMessage();
        if (message.isDurable() && this.durable) {
            this.storageManager.updateDeliveryCount(reference);
        }
        if ((maxDeliveries = (addressSettings = this.addressSettingsRepository.getMatch(this.address.toString())).getMaxDeliveryAttempts()) > 0 && reference.getDeliveryCount() >= maxDeliveries) {
            this.sendToDeadLetterAddress(reference);
            return false;
        }
        long redeliveryDelay = addressSettings.getRedeliveryDelay();
        if (redeliveryDelay > 0L) {
            reference.setScheduledDeliveryTime(System.currentTimeMillis() + redeliveryDelay);
            this.storageManager.updateScheduledDeliveryTime(reference);
        }
        this.deliveringCount.decrementAndGet();
        return true;
    }

    private void move(SimpleString toAddress, MessageReference ref) throws Exception {
        this.move(toAddress, ref, false);
    }

    private void move(SimpleString toAddress, Transaction tx, MessageReference ref, boolean expiry) throws Exception {
        ServerMessage copyMessage = this.makeCopy(ref, expiry);
        copyMessage.setAddress(toAddress);
        this.postOffice.route(copyMessage, tx);
        this.acknowledge(tx, ref);
    }

    private ServerMessage makeCopy(MessageReference ref, boolean expiry) throws Exception {
        ServerMessage message = ref.getMessage();
        long newID = this.storageManager.generateUniqueID();
        ServerMessage copy = message.makeCopyForExpiryOrDLA(newID, expiry);
        return copy;
    }

    private void expire(Transaction tx, MessageReference ref) throws Exception {
        SimpleString expiryAddress = this.addressSettingsRepository.getMatch(this.address.toString()).getExpiryAddress();
        if (expiryAddress != null) {
            Bindings bindingList = this.postOffice.getBindingsForAddress(expiryAddress);
            if (bindingList.getBindings().isEmpty()) {
                log.warn("Message has expired. No bindings for Expiry Address " + expiryAddress + " so dropping it");
            } else {
                this.move(expiryAddress, tx, ref, true);
            }
        } else {
            log.warn("Message has expired. No expiry queue configured for queue " + this.name + " so dropping it");
            this.acknowledge(tx, ref);
        }
    }

    private void sendToDeadLetterAddress(MessageReference ref) throws Exception {
        SimpleString deadLetterAddress = this.addressSettingsRepository.getMatch(this.address.toString()).getDeadLetterAddress();
        if (deadLetterAddress != null) {
            Bindings bindingList = this.postOffice.getBindingsForAddress(deadLetterAddress);
            if (bindingList.getBindings().isEmpty()) {
                log.warn("Message has exceeded max delivery attempts. No bindings for Dead Letter Address " + deadLetterAddress + " so dropping it");
            } else {
                log.warn("Message has reached maximum delivery attempts, sending it to Dead Letter Address " + deadLetterAddress + " from " + this.name);
                this.move(deadLetterAddress, ref, false);
            }
        } else {
            log.warn("Message has exceeded max delivery attempts. No Dead Letter Address configured for queue " + this.name + " so dropping it");
            this.acknowledge(ref);
        }
    }

    private void move(SimpleString address, MessageReference ref, boolean expiry) throws Exception {
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        ServerMessage copyMessage = this.makeCopy(ref, expiry);
        copyMessage.setAddress(address);
        this.postOffice.route(copyMessage, tx);
        this.acknowledge(tx, ref);
        tx.commit();
    }

    private MessageHandler getHandlerRoundRobin() {
        MessageHandler handler = this.handlers.get(this.pos);
        ++this.pos;
        if (this.pos == this.handlers.size()) {
            this.pos = 0;
        }
        return handler;
    }

    private boolean checkExpired(MessageReference reference) {
        if (reference.getMessage().isExpired()) {
            reference.handled();
            try {
                this.expire(reference);
            }
            catch (Exception e) {
                log.error("Failed to expire ref", e);
            }
            return true;
        }
        return false;
    }

    private synchronized void deliver() {
        if (this.paused || this.handlers.isEmpty()) {
            return;
        }
        this.direct = false;
        int startPos = this.pos;
        int totalCount = this.handlers.size();
        int nullCount = 0;
        int busyCount = 0;
        while (true) {
            Consumer consumer;
            MessageHandler handler;
            MessageReference reference;
            if ((reference = (handler = this.getHandlerRoundRobin()).peek(consumer = handler.getConsumer())) == null) {
                ++nullCount;
            } else if (this.checkExpired(reference)) {
                handler.remove();
            } else {
                Consumer groupConsumer;
                SimpleString groupID = reference.getMessage().getSimpleStringProperty(Message.HDR_GROUP_ID);
                boolean tryHandle = true;
                if (groupID != null && (groupConsumer = this.groups.putIfAbsent(groupID, consumer)) != null && groupConsumer != consumer) {
                    tryHandle = false;
                    ++busyCount;
                }
                if (tryHandle) {
                    HandleStatus status = this.handle(reference, consumer);
                    if (status == HandleStatus.HANDLED) {
                        handler.remove();
                    } else if (status == HandleStatus.BUSY) {
                        ++busyCount;
                        handler.reset();
                    } else if (status == HandleStatus.NO_MATCH && groupID != null) {
                        this.groups.remove(groupID);
                    }
                }
            }
            if (this.pos != startPos) continue;
            if (nullCount + busyCount == totalCount) {
                if (nullCount != totalCount) break;
                this.direct = true;
                this.promptDelivery = false;
                break;
            }
            busyCount = 0;
            nullCount = 0;
        }
    }

    private synchronized boolean directDeliver(MessageReference reference) {
        if (this.paused || this.handlers.isEmpty()) {
            return false;
        }
        if (this.checkExpired(reference)) {
            return true;
        }
        int startPos = this.pos;
        int busyCount = 0;
        boolean setPromptDelivery = false;
        do {
            Consumer groupConsumer;
            MessageHandler handler = this.getHandlerRoundRobin();
            Consumer consumer = handler.getConsumer();
            SimpleString groupID = reference.getMessage().getSimpleStringProperty(Message.HDR_GROUP_ID);
            boolean tryHandle = true;
            if (groupID != null && (groupConsumer = this.groups.putIfAbsent(groupID, consumer)) != null && groupConsumer != consumer) {
                tryHandle = false;
            }
            if (!tryHandle) continue;
            HandleStatus status = this.handle(reference, consumer);
            if (status == HandleStatus.HANDLED) {
                return true;
            }
            if (status == HandleStatus.BUSY) {
                ++busyCount;
                if (groupID == null) continue;
                return false;
            }
            if (status != HandleStatus.NO_MATCH) continue;
            if (groupID != null) {
                this.groups.remove(groupID);
            }
            setPromptDelivery = true;
        } while (this.pos != startPos);
        if (setPromptDelivery) {
            this.promptDelivery = true;
        }
        return false;
    }

    protected synchronized void add(MessageReference ref, boolean first) {
        if (!first) {
            this.messagesAdded.incrementAndGet();
        }
        if (this.scheduledDeliveryHandler.checkAndSchedule(ref)) {
            return;
        }
        boolean add = false;
        if (this.direct && !this.paused) {
            boolean delivered = this.directDeliver(ref);
            if (!delivered) {
                add = true;
                this.direct = false;
            }
        } else {
            add = true;
        }
        if (add) {
            if (first) {
                this.messageReferences.addFirst(ref, ref.getMessage().getPriority());
            } else {
                this.messageReferences.addLast(ref, ref.getMessage().getPriority());
            }
            if (!this.direct && this.promptDelivery) {
                this.deliverAsync();
            }
        }
    }

    private synchronized HandleStatus handle(MessageReference reference, Consumer consumer) {
        HandleStatus status;
        try {
            status = consumer.handle(reference);
        }
        catch (Throwable t) {
            log.warn("removing consumer which did not handle a message, consumer=" + consumer + ", message=" + reference, t);
            try {
                this.removeConsumer(consumer);
            }
            catch (Exception e) {
                log.error("Failed to remove consumer", e);
            }
            return HandleStatus.BUSY;
        }
        if (status == null) {
            throw new IllegalStateException("ClientConsumer.handle() should never return null");
        }
        return status;
    }

    private void postAcknowledge(MessageReference ref) throws Exception {
        int count;
        boolean durableRef;
        ServerMessage message = ref.getMessage();
        QueueImpl queue = (QueueImpl)ref.getQueue();
        boolean bl = durableRef = message.isDurable() && queue.durable;
        if (durableRef && (count = message.decrementDurableRefCount()) == 0) {
            try {
                this.storageManager.deleteMessage(message.getMessageID());
            }
            catch (Exception e) {
                log.warn("Unable to remove message id = " + message.getMessageID() + " please remove manually");
            }
        }
        queue.deliveringCount.decrementAndGet();
        message.decrementRefCount(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postRollback(LinkedList<MessageReference> refs) {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            this.direct = false;
            for (MessageReference ref : refs) {
                this.add(ref, true);
            }
            this.deliverAsync();
        }
    }

    @Override
    public synchronized void pause() {
        this.paused = true;
    }

    @Override
    public synchronized void resume() {
        this.paused = false;
        this.deliverAsync();
    }

    @Override
    public synchronized boolean isPaused() {
        return this.paused;
    }

    private class NullFilterMessageHandler
    implements MessageHandler {
        private final Consumer consumer;

        NullFilterMessageHandler(Consumer consumer) {
            this.consumer = consumer;
        }

        public MessageReference peek(Consumer consumer) {
            return (MessageReference)QueueImpl.this.messageReferences.peekFirst();
        }

        public void remove() {
            QueueImpl.this.messageReferences.removeFirst();
        }

        public void reset() {
        }

        public Consumer getConsumer() {
            return this.consumer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterMessageHandler
    implements MessageHandler {
        private final Consumer consumer;
        private Iterator<MessageReference> iterator;
        private MessageReference lastReference;
        private boolean resetting;

        public FilterMessageHandler(Consumer consumer, Iterator<MessageReference> iterator) {
            this.consumer = consumer;
            this.iterator = iterator;
        }

        @Override
        public MessageReference peek(Consumer consumer) {
            MessageReference reference;
            if (this.resetting) {
                this.resetting = false;
                return this.lastReference;
            }
            if (this.iterator.hasNext()) {
                reference = this.iterator.next();
            } else {
                reference = null;
                if (consumer.getFilter() != null) {
                    this.iterator = QueueImpl.this.messageReferences.iterator();
                }
            }
            this.lastReference = reference;
            return reference;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void reset() {
            this.resetting = true;
        }

        @Override
        public Consumer getConsumer() {
            return this.consumer;
        }
    }

    private static interface MessageHandler {
        public MessageReference peek(Consumer var1);

        public void remove();

        public void reset();

        public Consumer getConsumer();
    }

    private class DelayedAddRedistributor
    implements Runnable {
        private final Executor executor;

        DelayedAddRedistributor(Executor executor) {
            this.executor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                QueueImpl.this.internalAddRedistributor(this.executor);
                QueueImpl.this.futures.remove(this);
            }
        }
    }

    private final class RefsOperation
    implements TransactionOperation {
        List<MessageReference> refsToAck = new ArrayList<MessageReference>();

        private RefsOperation() {
        }

        synchronized void addAck(MessageReference ref) {
            this.refsToAck.add(ref);
        }

        public void beforeCommit(Transaction tx) throws Exception {
        }

        public void afterPrepare(Transaction tx) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterRollback(Transaction tx) {
            HashMap<QueueImpl, LinkedList<MessageReference>> queueMap = new HashMap<QueueImpl, LinkedList<MessageReference>>();
            for (MessageReference messageReference : this.refsToAck) {
                try {
                    if (!messageReference.getQueue().checkDLQ(messageReference)) continue;
                    LinkedList<MessageReference> toCancel = (LinkedList<MessageReference>)queueMap.get(messageReference.getQueue());
                    if (toCancel == null) {
                        toCancel = new LinkedList<MessageReference>();
                        queueMap.put((QueueImpl)messageReference.getQueue(), toCancel);
                    }
                    toCancel.addFirst(messageReference);
                }
                catch (Exception e) {
                    log.warn("Error on checkDLQ", e);
                }
            }
            for (Map.Entry entry : queueMap.entrySet()) {
                QueueImpl queue;
                LinkedList refs = (LinkedList)entry.getValue();
                QueueImpl queueImpl = queue = (QueueImpl)entry.getKey();
                synchronized (queueImpl) {
                    queue.postRollback(refs);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCommit(Transaction tx) throws Exception {
            for (MessageReference ref : this.refsToAck) {
                Queue queue = ref.getQueue();
                synchronized (queue) {
                    QueueImpl.this.postAcknowledge(ref);
                }
            }
        }

        public void beforePrepare(Transaction tx) throws Exception {
        }

        public void beforeRollback(Transaction tx) throws Exception {
        }
    }

    private class DeliverRunner
    implements Runnable {
        private DeliverRunner() {
        }

        public void run() {
            QueueImpl.this.waitingToDeliver.set(false);
            QueueImpl.this.deliver();
        }
    }
}

