/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.server.impl.CreditsAvailableRunnable;
import org.hornetq.core.server.impl.ServerProducerCreditManager;

public class ServerProducerCreditManagerImpl
implements ServerProducerCreditManager {
    private static final Logger log = Logger.getLogger(ServerProducerCreditManagerImpl.class);
    private final Queue<WaitingEntry> waiting = new ConcurrentLinkedQueue<WaitingEntry>();
    private final PagingStore pagingStore;

    public ServerProducerCreditManagerImpl(PagingStore pagingStore) {
        this.pagingStore = pagingStore;
    }

    public int creditsReleased(int credits) {
        WaitingEntry entry;
        int init = credits;
        while ((entry = this.waiting.peek()) != null) {
            boolean sent;
            if (entry.credits <= credits) {
                this.waiting.remove();
                sent = this.sendCredits(entry.waiting, entry.credits);
                if (!sent || entry.credits != (credits -= entry.credits)) continue;
                break;
            }
            entry.credits -= credits;
            sent = this.sendCredits(entry.waiting, credits);
            if (sent) {
                credits = 0;
                break;
            }
            this.waiting.remove();
        }
        return init - credits;
    }

    public int acquireCredits(int credits, CreditsAvailableRunnable runnable) {
        int available = this.pagingStore.getAvailableProducerCredits(credits);
        if (available < credits) {
            WaitingEntry entry = new WaitingEntry(runnable, credits - available);
            this.waiting.add(entry);
        }
        return available;
    }

    public int waitingEntries() {
        return this.waiting.size();
    }

    private boolean sendCredits(CreditsAvailableRunnable runnable, int credits) {
        return runnable.run(credits);
    }

    public PagingStore getStore() {
        return this.pagingStore;
    }

    private static final class WaitingEntry {
        final CreditsAvailableRunnable waiting;
        volatile int credits;
        volatile boolean closed;

        WaitingEntry(CreditsAvailableRunnable waiting, int credits) {
            this.waiting = waiting;
            this.credits = credits;
        }

        void close() {
            this.closed = true;
        }
    }
}

