/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import org.hornetq.core.logging.Logger;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.remoting.ChannelHandler;
import org.hornetq.core.remoting.Packet;
import org.hornetq.core.remoting.impl.wireformat.CreateQueueMessage;
import org.hornetq.core.remoting.impl.wireformat.RollbackMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionAcknowledgeMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionBindingQueryMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionConsumerCloseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionCreateConsumerMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionDeleteQueueMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionExpiredMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionForceConsumerDelivery;
import org.hornetq.core.remoting.impl.wireformat.SessionQueueQueryMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionRequestProducerCreditsMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionSendContinuationMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionSendLargeMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionSendMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXACommitMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAEndMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAForgetMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAJoinMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAPrepareMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAResumeMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXARollbackMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXASetTimeoutMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAStartMessage;
import org.hornetq.core.server.ServerSession;

public class ServerSessionPacketHandler
implements ChannelHandler {
    private static final Logger log = Logger.getLogger(ServerSessionPacketHandler.class);
    private final ServerSession session;
    private final OperationContext sessionContext;
    private final StorageManager storageManager;

    public ServerSessionPacketHandler(ServerSession session, OperationContext sessionContext, StorageManager storageManager) {
        this.session = session;
        this.storageManager = storageManager;
        this.sessionContext = sessionContext;
    }

    public long getID() {
        return this.session.getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handlePacket(Packet packet) {
        byte type = packet.getType();
        this.storageManager.setContext(this.sessionContext);
        try {
            switch (type) {
                case 40: {
                    SessionCreateConsumerMessage request = (SessionCreateConsumerMessage)packet;
                    this.session.handleCreateConsumer(request);
                    return;
                }
                case 34: {
                    CreateQueueMessage request = (CreateQueueMessage)packet;
                    this.session.handleCreateQueue(request);
                    return;
                }
                case 35: {
                    SessionDeleteQueueMessage request = (SessionDeleteQueueMessage)packet;
                    this.session.handleDeleteQueue(request);
                    return;
                }
                case 45: {
                    SessionQueueQueryMessage request = (SessionQueueQueryMessage)packet;
                    this.session.handleExecuteQueueQuery(request);
                    return;
                }
                case 49: {
                    SessionBindingQueryMessage request = (SessionBindingQueryMessage)packet;
                    this.session.handleExecuteBindingQuery(request);
                    return;
                }
                case 41: {
                    SessionAcknowledgeMessage message = (SessionAcknowledgeMessage)packet;
                    this.session.handleAcknowledge(message);
                    return;
                }
                case 42: {
                    SessionExpiredMessage message = (SessionExpiredMessage)packet;
                    this.session.handleExpired(message);
                    return;
                }
                case 43: {
                    this.session.handleCommit(packet);
                    return;
                }
                case 44: {
                    this.session.handleRollback((RollbackMessage)packet);
                    return;
                }
                case 53: {
                    SessionXACommitMessage message = (SessionXACommitMessage)packet;
                    this.session.handleXACommit(message);
                    return;
                }
                case 52: {
                    SessionXAEndMessage message = (SessionXAEndMessage)packet;
                    this.session.handleXAEnd(message);
                    return;
                }
                case 60: {
                    SessionXAForgetMessage message = (SessionXAForgetMessage)packet;
                    this.session.handleXAForget(message);
                    return;
                }
                case 57: {
                    SessionXAJoinMessage message = (SessionXAJoinMessage)packet;
                    this.session.handleXAJoin(message);
                    return;
                }
                case 59: {
                    SessionXAResumeMessage message = (SessionXAResumeMessage)packet;
                    this.session.handleXAResume(message);
                    return;
                }
                case 56: {
                    SessionXARollbackMessage message = (SessionXARollbackMessage)packet;
                    this.session.handleXARollback(message);
                    return;
                }
                case 51: {
                    SessionXAStartMessage message = (SessionXAStartMessage)packet;
                    this.session.handleXAStart(message);
                    return;
                }
                case 58: {
                    this.session.handleXASuspend(packet);
                    return;
                }
                case 54: {
                    SessionXAPrepareMessage message = (SessionXAPrepareMessage)packet;
                    this.session.handleXAPrepare(message);
                    return;
                }
                case 61: {
                    this.session.handleGetInDoubtXids(packet);
                    return;
                }
                case 65: {
                    this.session.handleGetXATimeout(packet);
                    return;
                }
                case 63: {
                    SessionXASetTimeoutMessage message = (SessionXASetTimeoutMessage)packet;
                    this.session.handleSetXATimeout(message);
                    return;
                }
                case 67: {
                    this.session.handleStart(packet);
                    return;
                }
                case 68: {
                    this.session.handleStop(packet);
                    return;
                }
                case 69: {
                    this.session.handleClose(packet);
                    return;
                }
                case 74: {
                    SessionConsumerCloseMessage message = (SessionConsumerCloseMessage)packet;
                    this.session.handleCloseConsumer(message);
                    return;
                }
                case 70: {
                    SessionConsumerFlowCreditMessage message = (SessionConsumerFlowCreditMessage)packet;
                    this.session.handleReceiveConsumerCredits(message);
                    return;
                }
                case 71: {
                    SessionSendMessage message = (SessionSendMessage)packet;
                    this.session.handleSend(message);
                    return;
                }
                case 72: {
                    SessionSendLargeMessage message = (SessionSendLargeMessage)packet;
                    this.session.handleSendLargeMessage(message);
                    return;
                }
                case 73: {
                    SessionSendContinuationMessage message = (SessionSendContinuationMessage)packet;
                    this.session.handleSendContinuations(message);
                    return;
                }
                case 78: {
                    SessionForceConsumerDelivery message = (SessionForceConsumerDelivery)packet;
                    this.session.handleForceConsumerDelivery(message);
                    return;
                }
                case 79: {
                    SessionRequestProducerCreditsMessage message = (SessionRequestProducerCreditsMessage)packet;
                    this.session.handleRequestProducerCredits(message);
                    return;
                }
            }
            return;
        }
        catch (Throwable t) {
            log.error("Caught unexpected exception", t);
            return;
        }
        finally {
            this.storageManager.completeOperations();
            this.storageManager.clearContext();
        }
    }
}

