/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.management.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.AcceptorControl;
import org.hornetq.api.core.management.BridgeControl;
import org.hornetq.api.core.management.BroadcastGroupControl;
import org.hornetq.api.core.management.ClusterConnectionControl;
import org.hornetq.api.core.management.DiscoveryGroupControl;
import org.hornetq.api.core.management.DivertControl;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.ObjectNameBuilder;
import org.hornetq.core.cluster.DiscoveryGroup;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.management.impl.AcceptorControlImpl;
import org.hornetq.core.management.impl.AddressControlImpl;
import org.hornetq.core.management.impl.BridgeControlImpl;
import org.hornetq.core.management.impl.BroadcastGroupControlImpl;
import org.hornetq.core.management.impl.ClusterConnectionControlImpl;
import org.hornetq.core.management.impl.DiscoveryGroupControlImpl;
import org.hornetq.core.management.impl.DivertControlImpl;
import org.hornetq.core.management.impl.HornetQServerControlImpl;
import org.hornetq.core.management.impl.QueueControlImpl;
import org.hornetq.core.messagecounter.MessageCounter;
import org.hornetq.core.messagecounter.MessageCounterManager;
import org.hornetq.core.messagecounter.impl.MessageCounterManagerImpl;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.remoting.server.RemotingService;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.Divert;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.QueueFactory;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.Bridge;
import org.hornetq.core.server.cluster.BridgeConfiguration;
import org.hornetq.core.server.cluster.BroadcastGroup;
import org.hornetq.core.server.cluster.BroadcastGroupConfiguration;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.ClusterConnectionConfiguration;
import org.hornetq.core.server.cluster.DiscoveryGroupConfiguration;
import org.hornetq.core.server.cluster.DivertConfiguration;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationListener;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.TypedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementServiceImpl
implements ManagementService {
    private static final Logger log = Logger.getLogger(ManagementServiceImpl.class);
    private final MBeanServer mbeanServer;
    private final boolean jmxManagementEnabled;
    private final Map<String, Object> registry;
    private final NotificationBroadcasterSupport broadcaster;
    private PostOffice postOffice;
    private PagingManager pagingManager;
    private StorageManager storageManager;
    private HornetQServer messagingServer;
    private HierarchicalRepository<Set<Role>> securityRepository;
    private HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private HornetQServerControlImpl messagingServerControl;
    private MessageCounterManager messageCounterManager;
    private final SimpleString managementNotificationAddress;
    private final SimpleString managementAddress;
    private boolean started = false;
    private final boolean messageCounterEnabled;
    private boolean notificationsEnabled;
    private final Set<NotificationListener> listeners = new ConcurrentHashSet<NotificationListener>();
    private final ObjectNameBuilder objectNameBuilder;
    private final Set<ObjectName> registeredNames = new HashSet<ObjectName>();

    public ManagementServiceImpl(MBeanServer mbeanServer, Configuration configuration) {
        this.mbeanServer = mbeanServer;
        this.jmxManagementEnabled = configuration.isJMXManagementEnabled();
        this.messageCounterEnabled = configuration.isMessageCounterEnabled();
        this.managementAddress = configuration.getManagementAddress();
        this.managementNotificationAddress = configuration.getManagementNotificationAddress();
        this.registry = new HashMap<String, Object>();
        this.broadcaster = new NotificationBroadcasterSupport();
        this.notificationsEnabled = true;
        this.objectNameBuilder = ObjectNameBuilder.create(configuration.getJMXDomain());
    }

    @Override
    public ObjectNameBuilder getObjectNameBuilder() {
        return this.objectNameBuilder;
    }

    @Override
    public MessageCounterManager getMessageCounterManager() {
        return this.messageCounterManager;
    }

    @Override
    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    @Override
    public HornetQServerControlImpl registerServer(PostOffice postOffice, StorageManager storageManager, Configuration configuration, HierarchicalRepository<AddressSettings> addressSettingsRepository, HierarchicalRepository<Set<Role>> securityRepository, ResourceManager resourceManager, RemotingService remotingService, HornetQServer messagingServer, QueueFactory queueFactory, ScheduledExecutorService scheduledThreadPool, PagingManager pagingManager, boolean backup) throws Exception {
        this.postOffice = postOffice;
        this.addressSettingsRepository = addressSettingsRepository;
        this.securityRepository = securityRepository;
        this.storageManager = storageManager;
        this.messagingServer = messagingServer;
        this.pagingManager = pagingManager;
        this.messageCounterManager = new MessageCounterManagerImpl(scheduledThreadPool);
        this.messageCounterManager.setMaxDayCount(configuration.getMessageCounterMaxDayHistory());
        this.messageCounterManager.reschedule(configuration.getMessageCounterSamplePeriod());
        this.messagingServerControl = new HornetQServerControlImpl(postOffice, configuration, resourceManager, remotingService, messagingServer, this.messageCounterManager, storageManager, this.broadcaster);
        ObjectName objectName = this.objectNameBuilder.getHornetQServerObjectName();
        this.registerInJMX(objectName, this.messagingServerControl);
        this.registerInRegistry("core.server", this.messagingServerControl);
        return this.messagingServerControl;
    }

    @Override
    public synchronized void unregisterServer() throws Exception {
        ObjectName objectName = this.objectNameBuilder.getHornetQServerObjectName();
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("core.server");
    }

    @Override
    public synchronized void registerAddress(SimpleString address) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getAddressObjectName(address);
        AddressControlImpl addressControl = new AddressControlImpl(address, this.postOffice, this.pagingManager, this.storageManager, this.securityRepository);
        this.registerInJMX(objectName, addressControl);
        this.registerInRegistry("core.address." + address, addressControl);
        if (log.isDebugEnabled()) {
            log.debug("registered address " + objectName);
        }
    }

    @Override
    public synchronized void unregisterAddress(SimpleString address) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getAddressObjectName(address);
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("core.address." + address);
    }

    @Override
    public synchronized void registerQueue(Queue queue, SimpleString address, StorageManager storageManager) throws Exception {
        QueueControlImpl queueControl = new QueueControlImpl(queue, address.toString(), this.postOffice, storageManager, this.addressSettingsRepository);
        if (this.messageCounterManager != null) {
            MessageCounter counter = new MessageCounter(queue.getName().toString(), null, queueControl, false, queue.isDurable(), this.messageCounterManager.getMaxDayCount());
            queueControl.setMessageCounter(counter);
            this.messageCounterManager.registerMessageCounter(queue.getName().toString(), counter);
        }
        ObjectName objectName = this.objectNameBuilder.getQueueObjectName(address, queue.getName());
        this.registerInJMX(objectName, queueControl);
        this.registerInRegistry("core.queue." + queue.getName(), queueControl);
        if (log.isDebugEnabled()) {
            log.debug("registered queue " + objectName);
        }
    }

    @Override
    public synchronized void unregisterQueue(SimpleString name, SimpleString address) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getQueueObjectName(address, name);
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("core.queue." + name);
        this.messageCounterManager.unregisterMessageCounter(name.toString());
    }

    @Override
    public synchronized void registerDivert(Divert divert, DivertConfiguration config) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getDivertObjectName(divert.getUniqueName());
        DivertControlImpl divertControl = new DivertControlImpl(divert, this.storageManager, config);
        this.registerInJMX(objectName, new StandardMBean(divertControl, DivertControl.class));
        this.registerInRegistry("core.divert." + config.getName(), divertControl);
        if (log.isDebugEnabled()) {
            log.debug("registered divert " + objectName);
        }
    }

    @Override
    public synchronized void unregisterDivert(SimpleString name) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getDivertObjectName(name);
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("core.divert." + name);
    }

    @Override
    public synchronized void registerAcceptor(Acceptor acceptor, TransportConfiguration configuration) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getAcceptorObjectName(configuration.getName());
        AcceptorControlImpl control = new AcceptorControlImpl(acceptor, this.storageManager, configuration);
        this.registerInJMX(objectName, new StandardMBean(control, AcceptorControl.class));
        this.registerInRegistry("core.acceptor." + configuration.getName(), control);
    }

    @Override
    public void unregisterAcceptors() {
        ArrayList<String> acceptors = new ArrayList<String>();
        for (String resourceName : this.registry.keySet()) {
            if (!resourceName.startsWith("core.acceptor.")) continue;
            acceptors.add(resourceName);
        }
        for (String acceptor : acceptors) {
            String name = acceptor.substring("core.acceptor.".length());
            try {
                this.unregisterAcceptor(name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void unregisterAcceptor(String name) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getAcceptorObjectName(name);
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("core.acceptor." + name);
    }

    @Override
    public synchronized void registerBroadcastGroup(BroadcastGroup broadcastGroup, BroadcastGroupConfiguration configuration) throws Exception {
        broadcastGroup.setNotificationService(this);
        ObjectName objectName = this.objectNameBuilder.getBroadcastGroupObjectName(configuration.getName());
        BroadcastGroupControlImpl control = new BroadcastGroupControlImpl(broadcastGroup, this.storageManager, configuration);
        this.registerInJMX(objectName, new StandardMBean(control, BroadcastGroupControl.class));
        this.registerInRegistry("core.broadcastgroup." + configuration.getName(), control);
    }

    @Override
    public synchronized void unregisterBroadcastGroup(String name) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getBroadcastGroupObjectName(name);
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("core.broadcastgroup." + name);
    }

    @Override
    public synchronized void registerDiscoveryGroup(DiscoveryGroup discoveryGroup, DiscoveryGroupConfiguration configuration) throws Exception {
        discoveryGroup.setNotificationService(this);
        ObjectName objectName = this.objectNameBuilder.getDiscoveryGroupObjectName(configuration.getName());
        DiscoveryGroupControlImpl control = new DiscoveryGroupControlImpl(discoveryGroup, this.storageManager, configuration);
        this.registerInJMX(objectName, new StandardMBean(control, DiscoveryGroupControl.class));
        this.registerInRegistry("core.discovery." + configuration.getName(), control);
    }

    @Override
    public synchronized void unregisterDiscoveryGroup(String name) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getDiscoveryGroupObjectName(name);
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("core.discovery." + name);
    }

    @Override
    public synchronized void registerBridge(Bridge bridge, BridgeConfiguration configuration) throws Exception {
        bridge.setNotificationService(this);
        ObjectName objectName = this.objectNameBuilder.getBridgeObjectName(configuration.getName());
        BridgeControlImpl control = new BridgeControlImpl(bridge, this.storageManager, configuration);
        this.registerInJMX(objectName, new StandardMBean(control, BridgeControl.class));
        this.registerInRegistry("core.bridge." + configuration.getName(), control);
    }

    @Override
    public synchronized void unregisterBridge(String name) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getBridgeObjectName(name);
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("core.bridge." + name);
    }

    @Override
    public synchronized void registerCluster(ClusterConnection cluster, ClusterConnectionConfiguration configuration) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getClusterConnectionObjectName(configuration.getName());
        ClusterConnectionControlImpl control = new ClusterConnectionControlImpl(cluster, this.storageManager, configuration);
        this.registerInJMX(objectName, new StandardMBean(control, ClusterConnectionControl.class));
        this.registerInRegistry("core.clusterconnection." + configuration.getName(), control);
    }

    @Override
    public synchronized void unregisterCluster(String name) throws Exception {
        ObjectName objectName = this.objectNameBuilder.getClusterConnectionObjectName(name);
        this.unregisterFromJMX(objectName);
        this.unregisterFromRegistry("core.clusterconnection." + name);
    }

    @Override
    public ServerMessage handleMessage(ServerMessage message) throws Exception {
        ServerMessageImpl reply;
        block11: {
            String operation;
            reply = new ServerMessageImpl(this.storageManager.generateUniqueID(), 512);
            String resourceName = message.getStringProperty(ManagementHelper.HDR_RESOURCE_NAME);
            if (log.isDebugEnabled()) {
                log.debug("handling management message for " + resourceName);
            }
            if ((operation = message.getStringProperty(ManagementHelper.HDR_OPERATION_NAME)) != null) {
                Object[] params = ManagementHelper.retrieveOperationParameters(message);
                if (params == null) {
                    params = new Object[]{};
                }
                try {
                    Object result = this.invokeOperation(resourceName, operation, params);
                    ManagementHelper.storeResult(reply, result);
                    reply.putBooleanProperty(ManagementHelper.HDR_OPERATION_SUCCEEDED, true);
                }
                catch (Exception e) {
                    log.warn("exception while invoking " + operation + " on " + resourceName, e);
                    reply.putBooleanProperty(ManagementHelper.HDR_OPERATION_SUCCEEDED, false);
                    String exceptionMessage = e.getMessage();
                    if (e instanceof InvocationTargetException) {
                        exceptionMessage = ((InvocationTargetException)e).getTargetException().getMessage();
                    }
                    if (e != null) {
                        ManagementHelper.storeResult(reply, exceptionMessage);
                    }
                    break block11;
                }
            }
            String attribute = message.getStringProperty(ManagementHelper.HDR_ATTRIBUTE);
            if (attribute != null) {
                try {
                    Object result = this.getAttribute(resourceName, attribute);
                    ManagementHelper.storeResult(reply, result);
                }
                catch (Exception e) {
                    log.warn("exception while retrieving attribute " + attribute + " on " + resourceName, e);
                    reply.putBooleanProperty(ManagementHelper.HDR_OPERATION_SUCCEEDED, false);
                    String exceptionMessage = e.getMessage();
                    if (e instanceof InvocationTargetException) {
                        exceptionMessage = ((InvocationTargetException)e).getTargetException().getMessage();
                    }
                    if (e == null) break block11;
                    ManagementHelper.storeResult(reply, exceptionMessage);
                }
            }
        }
        return reply;
    }

    @Override
    public Object getResource(String resourceName) {
        return this.registry.get(resourceName);
    }

    @Override
    public Object[] getResources(Class<?> resourceType) {
        ArrayList<Object> resources = new ArrayList<Object>();
        for (Object entry : this.registry.values()) {
            if (!resourceType.isAssignableFrom(entry.getClass())) continue;
            resources.add(entry);
        }
        return resources.toArray(new Object[resources.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInJMX(ObjectName objectName, Object managedResource) throws Exception {
        if (!this.jmxManagementEnabled) {
            return;
        }
        MBeanServer mBeanServer = this.mbeanServer;
        synchronized (mBeanServer) {
            this.unregisterFromJMX(objectName);
            this.mbeanServer.registerMBean(managedResource, objectName);
            this.registeredNames.add(objectName);
        }
    }

    @Override
    public synchronized void registerInRegistry(String resourceName, Object managedResource) {
        this.unregisterFromRegistry(resourceName);
        this.registry.put(resourceName, managedResource);
    }

    @Override
    public void unregisterFromRegistry(String resourceName) {
        this.registry.remove(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterFromJMX(ObjectName objectName) throws Exception {
        if (!this.jmxManagementEnabled) {
            return;
        }
        MBeanServer mBeanServer = this.mbeanServer;
        synchronized (mBeanServer) {
            if (this.mbeanServer.isRegistered(objectName)) {
                this.mbeanServer.unregisterMBean(objectName);
                this.registeredNames.remove(objectName);
            }
        }
    }

    @Override
    public void addNotificationListener(NotificationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public SimpleString getManagementAddress() {
        return this.managementAddress;
    }

    @Override
    public SimpleString getManagementNotificationAddress() {
        return this.managementNotificationAddress;
    }

    @Override
    public void start() throws Exception {
        if (this.messageCounterEnabled) {
            this.messageCounterManager.start();
        }
        this.started = true;
    }

    @Override
    public synchronized void stop() throws Exception {
        HashSet<String> resourceNames = new HashSet<String>(this.registry.keySet());
        for (String resourceName : resourceNames) {
            this.unregisterFromRegistry(resourceName);
        }
        if (this.jmxManagementEnabled && !this.registeredNames.isEmpty()) {
            ArrayList<String> unexpectedResourceNames = new ArrayList<String>();
            for (String name : resourceNames) {
                if (name.startsWith("core.address.") || name.startsWith("core.queue.")) continue;
                unexpectedResourceNames.add(name);
            }
            if (!unexpectedResourceNames.isEmpty()) {
                log.warn("On ManagementService stop, there are " + unexpectedResourceNames.size() + " unexpected registered MBeans: " + unexpectedResourceNames);
            }
            for (ObjectName on : this.registeredNames) {
                try {
                    this.mbeanServer.unregisterMBean(on);
                }
                catch (Exception ignore) {}
            }
        }
        if (this.messageCounterManager != null) {
            this.messageCounterManager.stop();
            this.messageCounterManager.resetAllCounters();
            this.messageCounterManager.resetAllCounterHistories();
            this.messageCounterManager.clear();
        }
        this.registeredNames.clear();
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendNotification(Notification notification) throws Exception {
        if (this.messagingServerControl != null && this.notificationsEnabled) {
            ManagementServiceImpl managementServiceImpl = this;
            synchronized (managementServiceImpl) {
                Object object = this.postOffice.getNotificationLock();
                synchronized (object) {
                    for (NotificationListener listener : this.listeners) {
                        try {
                            listener.onNotification(notification);
                        }
                        catch (Exception e) {
                            log.error("Failed to call listener", e);
                        }
                    }
                    if (this.messagingServer == null || !this.messagingServer.getRemotingService().isStarted()) {
                        return;
                    }
                    long messageID = this.storageManager.generateUniqueID();
                    ServerMessageImpl notificationMessage = new ServerMessageImpl(messageID, 512);
                    notificationMessage.setDurable(true);
                    notificationMessage.setAddress(this.managementNotificationAddress);
                    if (notification.getProperties() != null) {
                        TypedProperties props = notification.getProperties();
                        for (SimpleString name : notification.getProperties().getPropertyNames()) {
                            notificationMessage.putObjectProperty(name, props.getProperty(name));
                        }
                    }
                    notificationMessage.putStringProperty(ManagementHelper.HDR_NOTIFICATION_TYPE, new SimpleString(notification.getType().toString()));
                    notificationMessage.putLongProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP, System.currentTimeMillis());
                    if (notification.getUID() != null) {
                        notificationMessage.putStringProperty(new SimpleString("foobar"), new SimpleString(notification.getUID()));
                    }
                    this.postOffice.route(notificationMessage);
                }
            }
        }
    }

    @Override
    public void enableNotifications(boolean enabled) {
        this.notificationsEnabled = enabled;
    }

    public Object getAttribute(String resourceName, String attribute) {
        try {
            Object resource = this.registry.get(resourceName);
            if (resource == null) {
                throw new IllegalArgumentException("Cannot find resource with name " + resourceName);
            }
            Method method = null;
            String upperCaseAttribute = attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
            try {
                method = resource.getClass().getMethod("get" + upperCaseAttribute, new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    method = resource.getClass().getMethod("is" + upperCaseAttribute, new Class[0]);
                }
                catch (NoSuchMethodException nsme2) {
                    throw new IllegalArgumentException("no getter method for " + attribute);
                }
            }
            return method.invoke(resource, new Object[0]);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Problem while retrieving attribute " + attribute, t);
        }
    }

    private Object invokeOperation(String resourceName, String operation, Object[] params) throws Exception {
        Method[] methods;
        Object resource = this.registry.get(resourceName);
        if (resource == null) {
            throw new IllegalArgumentException("Cannot find resource with name " + resourceName);
        }
        Method method = null;
        for (Method m : methods = resource.getClass().getMethods()) {
            if (!m.getName().equals(operation) || m.getParameterTypes().length != params.length) continue;
            boolean match = true;
            Class<?>[] paramTypes = m.getParameterTypes();
            for (int i = 0; i < paramTypes.length; ++i) {
                if (params[i] == null || paramTypes[i].isAssignableFrom(params[i].getClass()) || paramTypes[i] == Long.TYPE && params[i].getClass() == Integer.class || paramTypes[i] == Double.TYPE && params[i].getClass() == Integer.class || paramTypes[i] == Long.TYPE && params[i].getClass() == Long.class || paramTypes[i] == Double.TYPE && params[i].getClass() == Double.class || paramTypes[i] == Integer.TYPE && params[i].getClass() == Integer.class || paramTypes[i] == Boolean.TYPE && params[i].getClass() == Boolean.class) continue;
                match = false;
                break;
            }
            if (!match) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new IllegalArgumentException("no operation " + operation + "/" + params.length);
        }
        Object result = method.invoke(resource, params);
        return result;
    }
}

