/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.BaseNode;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.AsyncCompositeObjectSinkAdapter;
import org.drools.reteoo.AsyncSingleObjectSinkAdapter;
import org.drools.reteoo.CompositeObjectSinkAdapter;
import org.drools.reteoo.EmptyObjectSinkAdapter;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkPropagator;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.SingleObjectSinkAdapter;
import org.drools.spi.PropagationContext;

public abstract class ObjectSource
extends BaseNode
implements Externalizable {
    protected ObjectSinkPropagator sink;
    protected ObjectSource source;
    private int alphaNodeHashingThreshold;

    public ObjectSource() {
    }

    ObjectSource(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled) {
        this(id, partitionId, partitionsEnabled, null, 3);
    }

    ObjectSource(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, ObjectSource objectSource, int alphaNodeHashingThreshold) {
        super(id, partitionId, partitionsEnabled);
        this.source = objectSource;
        this.alphaNodeHashingThreshold = alphaNodeHashingThreshold;
        this.sink = EmptyObjectSinkAdapter.getInstance();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sink = (ObjectSinkPropagator)in.readObject();
        this.source = (ObjectSource)in.readObject();
        this.alphaNodeHashingThreshold = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.sink);
        out.writeObject(this.source);
        out.writeInt(this.alphaNodeHashingThreshold);
    }

    public ObjectSource getParentObjectSource() {
        return this.source;
    }

    public void addObjectSink(ObjectSink objectSink) {
        if (this.sink instanceof EmptyObjectSinkAdapter) {
            this.sink = this.partitionsEnabled && !this.getPartitionId().equals(objectSink.getPartitionId()) ? new AsyncSingleObjectSinkAdapter(this.getPartitionId(), objectSink) : new SingleObjectSinkAdapter(this.getPartitionId(), objectSink);
        } else if (this.sink instanceof SingleObjectSinkAdapter) {
            CompositeObjectSinkAdapter sinkAdapter = this.partitionsEnabled ? new AsyncCompositeObjectSinkAdapter(this.getPartitionId(), this.alphaNodeHashingThreshold) : new CompositeObjectSinkAdapter(this.getPartitionId(), this.alphaNodeHashingThreshold);
            sinkAdapter.addObjectSink(this.sink.getSinks()[0]);
            sinkAdapter.addObjectSink(objectSink);
            this.sink = sinkAdapter;
        } else {
            ((CompositeObjectSinkAdapter)this.sink).addObjectSink(objectSink);
        }
    }

    protected void removeObjectSink(ObjectSink objectSink) {
        if (this.sink instanceof EmptyObjectSinkAdapter) {
            throw new IllegalArgumentException("Cannot remove a sink, when the list of sinks is null");
        }
        if (this.sink instanceof SingleObjectSinkAdapter) {
            this.sink = EmptyObjectSinkAdapter.getInstance();
        } else {
            CompositeObjectSinkAdapter sinkAdapter = (CompositeObjectSinkAdapter)this.sink;
            sinkAdapter.removeObjectSink(objectSink);
            if (sinkAdapter.size() == 1) {
                this.sink = this.partitionsEnabled && !this.getPartitionId().equals(sinkAdapter.getSinks()[0].getPartitionId()) ? new AsyncSingleObjectSinkAdapter(this.getPartitionId(), sinkAdapter.getSinks()[0]) : new SingleObjectSinkAdapter(this.getPartitionId(), sinkAdapter.getSinks()[0]);
            }
        }
    }

    public abstract void updateSink(ObjectSink var1, PropagationContext var2, InternalWorkingMemory var3);

    public void networkUpdated() {
        this.source.networkUpdated();
    }

    public ObjectSinkPropagator getSinkPropagator() {
        return this.sink;
    }

    public boolean isInUse() {
        return this.sink.size() > 0;
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeObjectSink((ObjectSink)((Object)node));
        }
        if (!this.isInUse() && this instanceof NodeMemory) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                workingMemory.clearNodeMemory((NodeMemory)((Object)this));
            }
        }
        this.source.remove(context, builder, this, workingMemories);
    }
}

