/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.drools.base.mvel.MVELCompileable;
import org.drools.base.mvel.MVELEnabledExpression;
import org.drools.base.mvel.MVELSalienceExpression;
import org.drools.common.AgendaItem;
import org.drools.common.BaseNode;
import org.drools.common.EventSupport;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.ScheduledAgendaItem;
import org.drools.event.rule.ActivationCancelledCause;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleTerminalNode
extends BaseNode
implements TerminalNode,
Externalizable {
    private int sequence = -1;
    private static final long serialVersionUID = 510L;
    private Rule rule;
    private GroupElement subrule;
    private int subruleIndex;
    private LeftTupleSource tupleSource;
    private Declaration[] declarations;
    private Declaration[] salienceDeclarations;
    private Declaration[] enabledDeclarations;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private boolean fireDirect;

    public RuleTerminalNode() {
    }

    public RuleTerminalNode(int id, LeftTupleSource source, Rule rule, GroupElement subrule, int subruleIndex, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.rule = rule;
        this.tupleSource = source;
        this.subrule = subrule;
        this.subruleIndex = subruleIndex;
        Map<String, Declaration> decls = this.subrule.getOuterDeclarations();
        this.declarations = new Declaration[rule.getRequiredDeclarations().length];
        int i = 0;
        for (String str : rule.getRequiredDeclarations()) {
            this.declarations[i++] = decls.get(str);
        }
        Arrays.sort(this.declarations, SortDeclarations.instance);
        this.setDeclarations(decls);
        this.fireDirect = rule.getActivationListener().equals("direct");
    }

    public void setDeclarations(Map<String, Declaration> decls) {
        int i;
        Declaration[] declrs;
        MVELCompileable expr;
        if (this.rule.getSalience() instanceof MVELSalienceExpression) {
            expr = (MVELSalienceExpression)this.rule.getSalience();
            declrs = ((MVELSalienceExpression)expr).getMVELCompilationUnit().getPreviousDeclarations();
            this.salienceDeclarations = new Declaration[declrs.length];
            i = 0;
            for (Declaration declr : declrs) {
                this.salienceDeclarations[i++] = decls.get(declr.getIdentifier());
            }
            Arrays.sort(this.salienceDeclarations, SortDeclarations.instance);
        }
        if (this.rule.getEnabled() instanceof MVELEnabledExpression) {
            expr = (MVELEnabledExpression)this.rule.getEnabled();
            declrs = ((MVELEnabledExpression)expr).getMVELCompilationUnit().getPreviousDeclarations();
            this.enabledDeclarations = new Declaration[declrs.length];
            i = 0;
            for (Declaration declr : declrs) {
                this.enabledDeclarations[i++] = decls.get(declr.getIdentifier());
            }
            Arrays.sort(this.enabledDeclarations, SortDeclarations.instance);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sequence = in.readInt();
        this.rule = (Rule)in.readObject();
        this.subrule = (GroupElement)in.readObject();
        this.subruleIndex = in.readInt();
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.declarations = (Declaration[])in.readObject();
        this.salienceDeclarations = (Declaration[])in.readObject();
        this.enabledDeclarations = (Declaration[])in.readObject();
        this.fireDirect = this.rule.getActivationListener().equals("direct");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.sequence);
        out.writeObject(this.rule);
        out.writeObject(this.subrule);
        out.writeInt(this.subruleIndex);
        out.writeObject(this.tupleSource);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
        out.writeObject(this.declarations);
        out.writeObject(this.salienceDeclarations);
        out.writeObject(this.enabledDeclarations);
    }

    public Rule getRule() {
        return this.rule;
    }

    public GroupElement getSubRule() {
        return this.subrule;
    }

    public void setSequence(int seq) {
        this.sequence = seq;
    }

    public int getSequence() {
        return this.sequence;
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.tupleSource;
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (!this.rule.isEffective(leftTuple, this, workingMemory) || this.rule.isNoLoop() && this.rule.equals(context.getRuleOrigin())) {
            leftTuple.setObject(Boolean.TRUE);
            return;
        }
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        boolean fire = agenda.createActivation(leftTuple, context, workingMemory, this, false);
        if (fire && !this.fireDirect) {
            agenda.addActivation((AgendaItem)leftTuple.getObject());
        }
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        boolean fire;
        AgendaItem match;
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        Object o = leftTuple.getObject();
        if (o != Boolean.TRUE && (match = (AgendaItem)o) != null && match.isActivated()) {
            agenda.modifyActivation(match, true);
            return;
        }
        if (!this.rule.isEffective(leftTuple, this, workingMemory) || this.rule.isNoLoop() && this.rule.equals(context.getRuleOrigin())) {
            agenda.increaseDormantActivations();
            return;
        }
        boolean reuseActivation = true;
        if (o == Boolean.TRUE) {
            reuseActivation = false;
            leftTuple.setObject(null);
        }
        if ((fire = agenda.createActivation(leftTuple, context, workingMemory, this, reuseActivation)) && !this.isFireDirect()) {
            agenda.decreaseDormantActivations();
            agenda.modifyActivation((AgendaItem)leftTuple.getObject(), false);
        }
    }

    @Override
    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple leftTuple = modifyPreviousTuples.removeLeftTuple(this);
        if (leftTuple != null) {
            leftTuple.reAdd();
            this.modifyLeftTuple(leftTuple, context, workingMemory);
        } else {
            this.assertLeftTuple(this.createLeftTuple(factHandle, (LeftTupleSink)this, true), context, workingMemory);
        }
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object obj = leftTuple.getObject();
        if (obj == null || obj == Boolean.TRUE) {
            return;
        }
        Activation activation = (Activation)leftTuple.getObject();
        activation.setMatched(false);
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        agenda.cancelActivation(leftTuple, context, workingMemory, activation, this);
    }

    @Override
    public String toString() {
        return "[RuleTerminalNode(" + this.getId() + "): rule=" + this.rule.getName() + "]";
    }

    public void ruleAttached() {
    }

    @Override
    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    @Override
    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void networkUpdated() {
        this.tupleSource.networkUpdated();
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        RuleRemovalContext.CleanupAdapter adapter = context.getCleanupAdapter();
        context.setCleanupAdapter(new RTNCleanupAdapter(this));
        this.tupleSource.remove(context, builder, this, workingMemories);
        for (InternalWorkingMemory workingMemory : workingMemories) {
            workingMemory.executeQueuedActions();
        }
        context.setCleanupAdapter(adapter);
    }

    @Override
    public boolean isInUse() {
        return false;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
    }

    public Declaration[] getDeclarations() {
        return this.declarations;
    }

    public Declaration[] getSalienceDeclarations() {
        return this.salienceDeclarations;
    }

    public void setSalienceDeclarations(Declaration[] salienceDeclarations) {
        this.salienceDeclarations = salienceDeclarations;
    }

    public Declaration[] getEnabledDeclarations() {
        return this.enabledDeclarations;
    }

    public void setEnabledDeclarations(Declaration[] enabledDeclarations) {
        this.enabledDeclarations = enabledDeclarations;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public int hashCode() {
        return this.rule.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof RuleTerminalNode)) {
            return false;
        }
        RuleTerminalNode other = (RuleTerminalNode)object;
        return this.rule.equals(other.rule);
    }

    @Override
    public short getType() {
        return 9;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    public boolean isFireDirect() {
        return this.fireDirect;
    }

    public static class RTNCleanupAdapter
    implements RuleRemovalContext.CleanupAdapter {
        private RuleTerminalNode node;

        public RTNCleanupAdapter(RuleTerminalNode node) {
            this.node = node;
        }

        public void cleanUp(LeftTuple leftTuple, InternalWorkingMemory workingMemory) {
            if (leftTuple.getLeftTupleSink() != this.node) {
                return;
            }
            Activation activation = (Activation)leftTuple.getObject();
            if (activation instanceof ScheduledAgendaItem) {
                ScheduledAgendaItem scheduled = (ScheduledAgendaItem)activation;
                workingMemory.getTimerService().removeJob(scheduled.getJobHandle());
                scheduled.getJobHandle().setCancel(true);
            }
            if (activation.isActivated()) {
                activation.remove();
                ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCancelled(activation, workingMemory, ActivationCancelledCause.CLEAR);
            }
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 4, null, null, null);
            workingMemory.getTruthMaintenanceSystem().removeLogicalDependencies(activation, propagationContext, this.node.getRule());
            leftTuple.unlinkFromLeftParent();
            leftTuple.unlinkFromRightParent();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortDeclarations
    implements Comparator<Declaration> {
        public static final SortDeclarations instance = new SortDeclarations();

        @Override
        public int compare(Declaration d1, Declaration d2) {
            return d1.getIdentifier().compareTo(d2.getIdentifier());
        }
    }
}

