/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.drools.RuntimeDroolsException;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.ArrayUtils;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.rule.MutableTypeConstraint;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.Constraint;

public abstract class AbstractCompositeConstraint
extends MutableTypeConstraint {
    protected AlphaNodeFieldConstraint[] alphaConstraints = new AlphaNodeFieldConstraint[0];
    protected BetaNodeFieldConstraint[] betaConstraints = new BetaNodeFieldConstraint[0];
    protected Declaration[] requiredDeclarations = new Declaration[0];

    public AbstractCompositeConstraint() {
        this.setType(Constraint.ConstraintType.ALPHA);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.alphaConstraints = (AlphaNodeFieldConstraint[])in.readObject();
        this.betaConstraints = (BetaNodeFieldConstraint[])in.readObject();
        this.requiredDeclarations = (Declaration[])in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.alphaConstraints);
        out.writeObject(this.betaConstraints);
        out.writeObject(this.requiredDeclarations);
    }

    public AlphaNodeFieldConstraint[] getAlphaConstraints() {
        return this.alphaConstraints;
    }

    public BetaNodeFieldConstraint[] getBetaConstraints() {
        return this.betaConstraints;
    }

    public boolean isTemporal() {
        for (AlphaNodeFieldConstraint alphaNodeFieldConstraint : this.alphaConstraints) {
            if (!alphaNodeFieldConstraint.isTemporal()) continue;
            return true;
        }
        for (Constraint constraint : this.betaConstraints) {
            if (!constraint.isTemporal()) continue;
            return true;
        }
        return false;
    }

    public void addAlphaConstraint(AlphaNodeFieldConstraint constraint) {
        if (constraint != null) {
            AlphaNodeFieldConstraint[] tmp = this.alphaConstraints;
            this.alphaConstraints = new AlphaNodeFieldConstraint[tmp.length + 1];
            System.arraycopy(tmp, 0, this.alphaConstraints, 0, tmp.length);
            this.alphaConstraints[this.alphaConstraints.length - 1] = constraint;
            this.updateRequiredDeclarations(constraint);
        }
    }

    public void addBetaConstraint(BetaNodeFieldConstraint constraint) {
        if (constraint != null) {
            BetaNodeFieldConstraint[] tmp = this.betaConstraints;
            this.betaConstraints = new BetaNodeFieldConstraint[tmp.length + 1];
            System.arraycopy(tmp, 0, this.betaConstraints, 0, tmp.length);
            this.betaConstraints[this.betaConstraints.length - 1] = constraint;
            this.updateRequiredDeclarations(constraint);
            this.setType(Constraint.ConstraintType.BETA);
        }
    }

    public void addConstraint(Constraint constraint) {
        if (Constraint.ConstraintType.ALPHA.equals((Object)constraint.getType())) {
            this.addAlphaConstraint((AlphaNodeFieldConstraint)constraint);
        } else if (Constraint.ConstraintType.BETA.equals((Object)constraint.getType())) {
            this.addBetaConstraint((BetaNodeFieldConstraint)constraint);
        } else {
            throw new RuntimeDroolsException("Constraint type MUST be known in advance.");
        }
    }

    protected void updateRequiredDeclarations(Constraint constraint) {
        Declaration[] decs = constraint.getRequiredDeclarations();
        if (decs != null && decs.length > 0) {
            for (int i = 0; i < decs.length; ++i) {
                Declaration dec = decs[i];
                for (int j = 0; j < this.requiredDeclarations.length; ++j) {
                    if (!dec.equals(this.requiredDeclarations[j])) continue;
                    dec = null;
                    break;
                }
                if (dec == null) continue;
                Declaration[] tmp = this.requiredDeclarations;
                this.requiredDeclarations = new Declaration[tmp.length + 1];
                System.arraycopy(tmp, 0, this.requiredDeclarations, 0, tmp.length);
                this.requiredDeclarations[this.requiredDeclarations.length - 1] = dec;
            }
        }
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        int i;
        for (i = 0; i < this.alphaConstraints.length; ++i) {
            this.alphaConstraints[i].replaceDeclaration(oldDecl, newDecl);
        }
        for (i = 0; i < this.betaConstraints.length; ++i) {
            this.betaConstraints[i].replaceDeclaration(oldDecl, newDecl);
        }
        for (i = 0; i < this.requiredDeclarations.length; ++i) {
            if (this.requiredDeclarations[i] != oldDecl) continue;
            this.requiredDeclarations[i] = newDecl;
        }
    }

    public ContextEntry createContextEntry() {
        return new MultiFieldConstraintContextEntry(this.alphaConstraints, this.betaConstraints);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + ArrayUtils.hashCode(this.alphaConstraints);
        result = 31 * result + ArrayUtils.hashCode(this.betaConstraints);
        result = 31 * result + ArrayUtils.hashCode(this.requiredDeclarations);
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != AbstractCompositeConstraint.class) {
            return false;
        }
        AbstractCompositeConstraint other = (AbstractCompositeConstraint)object;
        return Arrays.equals(this.alphaConstraints, other.alphaConstraints) && Arrays.equals(this.betaConstraints, other.betaConstraints) && Arrays.equals(this.requiredDeclarations, other.requiredDeclarations);
    }

    public abstract Object clone();

    protected static class MultiFieldConstraintContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 510L;
        public ContextEntry[] alphas;
        public ContextEntry[] betas;
        public ContextEntry next;
        public InternalWorkingMemory workingMemory;
        public InternalFactHandle handle;

        public MultiFieldConstraintContextEntry() {
        }

        public MultiFieldConstraintContextEntry(AlphaNodeFieldConstraint[] alphas, BetaNodeFieldConstraint[] betas) {
            int i;
            this.alphas = new ContextEntry[alphas.length];
            for (i = 0; i < alphas.length; ++i) {
                this.alphas[i] = alphas[i].createContextEntry();
            }
            this.betas = new ContextEntry[betas.length];
            for (i = 0; i < betas.length; ++i) {
                this.betas[i] = betas[i].createContextEntry();
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.alphas = (ContextEntry[])in.readObject();
            this.betas = (ContextEntry[])in.readObject();
            this.next = (ContextEntry)in.readObject();
            this.workingMemory = (InternalWorkingMemory)in.readObject();
            this.handle = (InternalFactHandle)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.alphas);
            out.writeObject(this.betas);
            out.writeObject(this.next);
            out.writeObject(this.workingMemory);
            out.writeObject(this.handle);
        }

        public ContextEntry getNext() {
            return this.next;
        }

        public void setNext(ContextEntry entry) {
            this.next = entry;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            int i;
            this.workingMemory = workingMemory;
            this.handle = handle;
            for (i = 0; i < this.alphas.length; ++i) {
                if (this.alphas[i] == null) continue;
                this.alphas[i].updateFromFactHandle(workingMemory, handle);
            }
            for (i = 0; i < this.betas.length; ++i) {
                this.betas[i].updateFromFactHandle(workingMemory, handle);
            }
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            int i;
            this.workingMemory = workingMemory;
            for (i = 0; i < this.alphas.length; ++i) {
                if (this.alphas[i] == null) continue;
                this.alphas[i].updateFromTuple(workingMemory, tuple);
            }
            for (i = 0; i < this.betas.length; ++i) {
                this.betas[i].updateFromTuple(workingMemory, tuple);
            }
        }

        public void resetTuple() {
            int i;
            this.workingMemory = null;
            int length = this.alphas.length;
            for (i = 0; i < length; ++i) {
                if (this.alphas[i] == null) continue;
                this.alphas[i].resetTuple();
            }
            length = this.betas.length;
            for (i = 0; i < length; ++i) {
                this.betas[i].resetTuple();
            }
        }

        public void resetFactHandle() {
            int i;
            this.workingMemory = null;
            this.handle = null;
            int length = this.alphas.length;
            for (i = 0; i < length; ++i) {
                if (this.alphas[i] == null) continue;
                this.alphas[i].resetFactHandle();
            }
            length = this.betas.length;
            for (i = 0; i < length; ++i) {
                this.betas[i].resetFactHandle();
            }
        }
    }
}

