/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.twopc;

import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.utils.Decoder;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.xa.XAException;

public class PhaseException
extends Exception {
    private List exceptions = new ArrayList();
    private List resourceStates = new ArrayList();

    public PhaseException(List exceptions, List resourceStates) {
        this.exceptions = exceptions;
        this.resourceStates = resourceStates;
    }

    public String getMessage() {
        StringBuffer errorMessage = new StringBuffer();
        errorMessage.append("collected ");
        errorMessage.append(this.exceptions.size());
        errorMessage.append(" exception(s):");
        for (int i = 0; i < this.exceptions.size(); ++i) {
            errorMessage.append(System.getProperty("line.separator"));
            Throwable throwable = (Throwable)this.exceptions.get(i);
            String message = throwable.getMessage();
            XAResourceHolderState holderState = (XAResourceHolderState)this.resourceStates.get(i);
            if (holderState != null) {
                errorMessage.append(" [");
                errorMessage.append(holderState.getUniqueName());
                errorMessage.append(" - ");
            }
            errorMessage.append(throwable.getClass().getName());
            if (throwable instanceof XAException) {
                XAException xaEx = (XAException)throwable;
                errorMessage.append("(");
                errorMessage.append(Decoder.decodeXAExceptionErrorCode(xaEx));
                errorMessage.append(")");
            }
            errorMessage.append(" - ");
            errorMessage.append(message);
            errorMessage.append("]");
        }
        return errorMessage.toString();
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public List getResourceStates() {
        return this.resourceStates;
    }
}

