/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.jms;

import java.io.IOException;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.jms.JMSTaskServerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJMSTaskServer
extends TaskServer {
    private static final Logger logger = LoggerFactory.getLogger(BaseJMSTaskServer.class);
    private JMSTaskServerHandler handler;
    private Properties connectionProperties;
    private Context context;
    private Queue queue;
    private Queue responseQueue;
    private QueueConnection connection;
    private boolean running;
    private QueueSession session;
    private MessageConsumer consumer;

    public BaseJMSTaskServer(JMSTaskServerHandler handler, Properties properties, Context context) {
        this.handler = handler;
        this.connectionProperties = properties;
        this.context = context;
    }

    @Override
    public void run() {
        try {
            this.start();
            while (this.running) {
                Message clientMessage = this.consumer.receive();
                if (clientMessage == null) continue;
                Object object = this.readMessage(clientMessage);
                String selector = this.readSelector(clientMessage);
                this.handler.messageReceived(this.session, object, (Destination)this.responseQueue, selector);
            }
        }
        catch (JMSException e) {
            if ("102".equals(e.getErrorCode())) {
                logger.info(e.getMessage());
            } else {
                logger.error(e.getMessage());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error leyendo mensaje", e);
        }
    }

    private Object readMessage(Message msgReceived) throws IOException {
        ObjectMessage strmMsgReceived = (ObjectMessage)msgReceived;
        try {
            return strmMsgReceived.getObject();
        }
        catch (JMSException e) {
            throw new IOException("Error reading message");
        }
    }

    private String readSelector(Message msgReceived) throws JMSException {
        return msgReceived.getStringProperty("taskClientId");
    }

    @Override
    public void start() throws Exception {
        Context ctx = this.context;
        if (this.context == null) {
            ctx = new InitialContext();
        }
        String connFactoryName = this.connectionProperties.getProperty("JMSTaskServer.connectionFactory");
        boolean transacted = Boolean.valueOf(this.connectionProperties.getProperty("JMSTaskServer.transacted"));
        String ackModeString = this.connectionProperties.getProperty("JMSTaskServer.acknowledgeMode");
        String queueName = this.connectionProperties.getProperty("JMSTaskServer.queueName");
        String responseQueueName = this.connectionProperties.getProperty("JMSTaskServer.responseQueueName");
        int ackMode = 3;
        if ("AUTO_ACKNOWLEDGE".equals(ackModeString)) {
            ackMode = 1;
        } else if ("CLIENT_ACKNOWLEDGE".equals(ackModeString)) {
            ackMode = 2;
        }
        QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup(connFactoryName);
        try {
            this.connection = factory.createQueueConnection();
            this.session = this.connection.createQueueSession(transacted, ackMode);
            this.queue = this.session.createQueue(queueName);
            this.responseQueue = this.session.createQueue(responseQueueName);
            this.consumer = this.session.createConsumer((Destination)this.queue);
            this.connection.start();
        }
        catch (JMSException e) {
            throw new RuntimeException("No se pudo levantar la cola servidora del JMSTaskServer", e);
        }
        this.running = true;
    }

    @Override
    public void stop() throws Exception {
        if (this.running) {
            this.running = false;
            this.closeAll();
        }
    }

    private void closeAll() throws JMSException {
        this.consumer.close();
        this.session.close();
        this.connection.close();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }
}

