/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.HashMap;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.KnowledgeBase;
import org.drools.SystemEventListenerFactory;
import org.drools.impl.EnvironmentFactory;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItemHandler;
import org.h2.tools.Server;
import org.jbpm.process.workitem.wsht.CommandBasedWSHumanTaskHandler;
import org.jbpm.process.workitem.wsht.WSHumanTaskHandler;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.mina.MinaTaskServer;
import org.jbpm.test.KnowledgeSessionCleanup;

public final class JBPMHelper {
    public static String[] processStateName = new String[]{"PENDING", "ACTIVE", "COMPLETED", "ABORTED", "SUSPENDED"};
    public static String[] txStateName = new String[]{"ACTIVE", "MARKED_ROLLBACK", "PREPARED", "COMMITTED", "ROLLEDBACK", "UNKNOWN", "NO_TRANSACTION", "PREPARING", "COMMITTING", "ROLLING_BACK"};

    private JBPMHelper() {
    }

    public static void startUp() {
        Properties properties = JBPMHelper.getProperties();
        String driverClassName = properties.getProperty("persistence.datasource.driverClassName", "org.h2.Driver");
        if (driverClassName.startsWith("org.h2")) {
            JBPMHelper.startH2Server();
        }
        String persistenceEnabled = properties.getProperty("persistence.enabled", "false");
        String humanTaskEnabled = properties.getProperty("taskservice.enabled", "false");
        if ("true".equals(persistenceEnabled) || "true".equals(humanTaskEnabled)) {
            JBPMHelper.setupDataSource();
        }
        if ("true".equals(humanTaskEnabled)) {
            JBPMHelper.startTaskService();
        }
    }

    public static Server startH2Server() {
        try {
            Server server = Server.createTcpServer((String[])new String[0]);
            server.start();
            return server;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not start H2 server", t);
        }
    }

    public static PoolingDataSource setupDataSource() {
        Properties properties = JBPMHelper.getProperties();
        PoolingDataSource pds = new PoolingDataSource();
        pds.setUniqueName(properties.getProperty("persistence.datasource.name", "jdbc/jbpm-ds"));
        pds.setClassName("bitronix.tm.resource.jdbc.lrc.LrcXADataSource");
        pds.setMaxPoolSize(5);
        pds.setAllowLocalTransactions(true);
        pds.getDriverProperties().put("user", properties.getProperty("persistence.datasource.user", "sa"));
        pds.getDriverProperties().put("password", properties.getProperty("persistence.datasource.password", ""));
        pds.getDriverProperties().put("url", properties.getProperty("persistence.datasource.url", "jdbc:h2:tcp://localhost/~/jbpm-db;MVCC=TRUE"));
        pds.getDriverProperties().put("driverClassName", properties.getProperty("persistence.datasource.driverClassName", "org.h2.Driver"));
        pds.init();
        return pds;
    }

    public static TaskService startTaskService() {
        Properties properties = JBPMHelper.getProperties();
        String dialect = properties.getProperty("persistence.persistenceunit.dialect", "org.hibernate.dialect.H2Dialect");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hibernate.dialect", dialect);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)properties.getProperty("taskservice.datasource.name", "org.jbpm.task"), map);
        System.setProperty("jbpm.usergroup.callback", properties.getProperty("taskservice.usergroupcallback", "org.jbpm.task.service.DefaultUserGroupCallbackImpl"));
        TaskService taskService = new TaskService(emf, SystemEventListenerFactory.getSystemEventListener());
        String transport = properties.getProperty("taskservice.transport", "mina");
        if (!"mina".equals(transport)) {
            throw new RuntimeException("Unknown task service transport " + transport);
        }
        MinaTaskServer taskServer = new MinaTaskServer(taskService);
        Thread thread = new Thread((Runnable)taskServer);
        thread.start();
        return taskService;
    }

    public static void registerTaskService(StatefulKnowledgeSession ksession) {
        Properties properties = JBPMHelper.getProperties();
        String transport = properties.getProperty("taskservice.transport", "mina");
        if (!"mina".equals(transport)) {
            throw new RuntimeException("Unknown task service transport " + transport);
        }
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new CommandBasedWSHumanTaskHandler((KnowledgeRuntime)ksession));
    }

    protected static Environment createEnvironment(EntityManagerFactory emf) {
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
        env.set("drools.transaction.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        return env;
    }

    public static StatefulKnowledgeSession newStatefulKnowledgeSession(KnowledgeBase kbase) {
        return JBPMHelper.loadStatefulKnowledgeSession(kbase, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatefulKnowledgeSession loadStatefulKnowledgeSession(KnowledgeBase kbase, int sessionId) {
        StatefulKnowledgeSession ksession;
        Properties properties = JBPMHelper.getProperties();
        String persistenceEnabled = properties.getProperty("persistence.enabled", "false");
        if ("true".equals(persistenceEnabled)) {
            String dialect = properties.getProperty("persistence.persistenceunit.dialect", "org.hibernate.dialect.H2Dialect");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hibernate.dialect", dialect);
            EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)properties.getProperty("persistence.persistenceunit.name", "org.jbpm.persistence.jpa"), map);
            Environment env = JBPMHelper.createEnvironment(emf);
            ksession = sessionId == -1 ? JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env) : JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KnowledgeBase)kbase, null, (Environment)env);
            String humanTaskEnabled = properties.getProperty("taskservice.enabled", "false");
            if ("true".equals(humanTaskEnabled)) {
                String transport = properties.getProperty("taskservice.transport", "mina");
                if (!"mina".equals(transport)) throw new RuntimeException("Unknown task service transport " + transport);
                ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new CommandBasedWSHumanTaskHandler((KnowledgeRuntime)ksession));
            }
        } else {
            ksession = kbase.newStatefulKnowledgeSession();
            String humanTaskEnabled = properties.getProperty("taskservice.enabled", "false");
            if ("true".equals(humanTaskEnabled)) {
                String transport = properties.getProperty("taskservice.transport", "mina");
                if (!"mina".equals(transport)) throw new RuntimeException("Unknown task service transport " + transport);
                ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new WSHumanTaskHandler((KnowledgeRuntime)ksession));
            }
        }
        KnowledgeSessionCleanup.knowledgeSessionSetLocal.get().add(ksession);
        return ksession;
    }

    public static Properties getProperties() {
        Properties properties = new Properties();
        try {
            properties.load(JBPMHelper.class.getResourceAsStream("/jBPM.properties"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return properties;
    }
}

