/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.event;

import java.util.Iterator;
import java.util.List;
import org.jbpm.eventmessaging.EventKeys;
import org.jbpm.eventmessaging.EventTriggerTransport;
import org.jbpm.task.event.EventPayload;
import org.jbpm.task.event.TaskClaimedEvent;
import org.jbpm.task.event.TaskCompletedEvent;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.event.TaskEventListener;
import org.jbpm.task.event.TaskFailedEvent;
import org.jbpm.task.event.TaskSkippedEvent;

public class MessagingTaskEventListener
implements TaskEventListener {
    private EventKeys keys;

    public MessagingTaskEventListener(EventKeys keys) {
        this.keys = keys;
    }

    @Override
    public void taskClaimed(TaskClaimedEvent event) {
        TaskEventKey key = new TaskEventKey(TaskClaimedEvent.class, event.getTaskId());
        List<EventTriggerTransport> targets = this.keys.getTargets(key);
        if (targets == null) {
            return;
        }
        EventPayload payload = new EventPayload(event);
        Iterator<EventTriggerTransport> it = targets.iterator();
        while (it.hasNext()) {
            EventTriggerTransport target = it.next();
            target.trigger(payload);
            if (!target.isRemove()) continue;
            it.remove();
        }
        if (targets.isEmpty()) {
            this.keys.removeKey(key);
        }
    }

    @Override
    public void taskCompleted(TaskCompletedEvent event) {
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, event.getTaskId());
        List<EventTriggerTransport> targets = this.keys.getTargets(key);
        if (targets == null) {
            key = new TaskEventKey(TaskCompletedEvent.class, -1L);
            targets = this.keys.getTargets(key);
            if (targets == null) {
                return;
            }
        } else {
            key = new TaskEventKey(TaskCompletedEvent.class, -1L);
            List<EventTriggerTransport> additionalTargets = this.keys.getTargets(key);
            if (additionalTargets != null) {
                targets.addAll(additionalTargets);
            }
        }
        EventPayload payload = new EventPayload(event);
        Iterator<EventTriggerTransport> it = targets.iterator();
        while (it.hasNext()) {
            EventTriggerTransport target = it.next();
            target.trigger(payload);
            if (!target.isRemove()) continue;
            it.remove();
        }
        if (targets.isEmpty()) {
            this.keys.removeKey(key);
        }
    }

    @Override
    public void taskFailed(TaskFailedEvent event) {
        TaskEventKey key = new TaskEventKey(TaskFailedEvent.class, event.getTaskId());
        List<EventTriggerTransport> targets = this.keys.getTargets(key);
        if (targets == null) {
            key = new TaskEventKey(TaskFailedEvent.class, -1L);
            targets = this.keys.getTargets(key);
            if (targets == null) {
                return;
            }
        } else {
            key = new TaskEventKey(TaskFailedEvent.class, -1L);
            List<EventTriggerTransport> additionalTargets = this.keys.getTargets(key);
            if (additionalTargets != null) {
                targets.addAll(additionalTargets);
            }
        }
        EventPayload payload = new EventPayload(event);
        Iterator<EventTriggerTransport> it = targets.iterator();
        while (it.hasNext()) {
            EventTriggerTransport target = it.next();
            target.trigger(payload);
            if (!target.isRemove()) continue;
            it.remove();
        }
        if (targets.isEmpty()) {
            this.keys.removeKey(key);
        }
    }

    @Override
    public void taskSkipped(TaskSkippedEvent event) {
        TaskEventKey key = new TaskEventKey(TaskSkippedEvent.class, event.getTaskId());
        List<EventTriggerTransport> targets = this.keys.getTargets(key);
        if (targets == null) {
            key = new TaskEventKey(TaskSkippedEvent.class, -1L);
            targets = this.keys.getTargets(key);
            if (targets == null) {
                return;
            }
        } else {
            key = new TaskEventKey(TaskSkippedEvent.class, -1L);
            List<EventTriggerTransport> additionalTargets = this.keys.getTargets(key);
            if (additionalTargets != null) {
                targets.addAll(additionalTargets);
            }
        }
        EventPayload payload = new EventPayload(event);
        Iterator<EventTriggerTransport> it = targets.iterator();
        while (it.hasNext()) {
            EventTriggerTransport target = it.next();
            target.trigger(payload);
            if (!target.isRemove()) continue;
            it.remove();
        }
        if (targets.isEmpty()) {
            this.keys.removeKey(key);
        }
    }
}

