/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.internal;

import bitronix.tm.BitronixXid;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.BitronixXAException;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.utils.Scheduler;
import bitronix.tm.utils.Uid;
import bitronix.tm.utils.UidGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAResourceManager {
    private static final Logger log = LoggerFactory.getLogger(XAResourceManager.class);
    private Uid gtrid;
    private Scheduler resources = new Scheduler();

    public XAResourceManager(Uid gtrid) {
        this.gtrid = gtrid;
    }

    public void enlist(XAResourceHolderState xaResourceHolderState) throws XAException, BitronixSystemException {
        List alwaysLastResources;
        int flag;
        BitronixXid xid;
        XAResourceHolderState alreadyEnlistedHolder = this.findXAResourceHolderState(xaResourceHolderState.getXAResource());
        if (alreadyEnlistedHolder != null && !alreadyEnlistedHolder.isEnded()) {
            xaResourceHolderState.setXid(alreadyEnlistedHolder.getXid());
            log.warn("ignoring enlistment of already enlisted but not ended resource " + xaResourceHolderState);
            return;
        }
        XAResourceHolderState toBeJoinedHolderState = null;
        if (alreadyEnlistedHolder != null) {
            if (log.isDebugEnabled()) {
                log.debug("resource already enlisted but has been ended eligible for join: " + alreadyEnlistedHolder);
            }
            toBeJoinedHolderState = this.getManagedResourceWithSameRM(xaResourceHolderState);
        }
        if (toBeJoinedHolderState != null) {
            if (log.isDebugEnabled()) {
                log.debug("joining " + xaResourceHolderState + " with " + toBeJoinedHolderState);
            }
            xid = toBeJoinedHolderState.getXid();
            flag = 0x200000;
        } else {
            xid = UidGenerator.generateXid(this.gtrid);
            if (log.isDebugEnabled()) {
                log.debug("creating new branch with " + xid);
            }
            flag = 0;
        }
        if (flag != 0x200000 && xaResourceHolderState.getTwoPcOrderingPosition() == Integer.MAX_VALUE && !TransactionManagerServices.getConfiguration().isAllowMultipleLrc() && (alwaysLastResources = this.resources.getByNaturalOrderForPosition(Scheduler.ALWAYS_LAST_POSITION_KEY)) != null && !alwaysLastResources.isEmpty()) {
            throw new BitronixSystemException("cannot enlist more than one non-XA resource, tried enlisting " + xaResourceHolderState + ", already enlisted: " + alwaysLastResources.get(0));
        }
        xaResourceHolderState.setXid(xid);
        xaResourceHolderState.start(flag);
        if (toBeJoinedHolderState != null) {
            this.resources.remove(toBeJoinedHolderState);
        }
        this.resources.add(xaResourceHolderState, xaResourceHolderState.getTwoPcOrderingPosition());
    }

    public boolean delist(XAResourceHolderState xaResourceHolderState, int flag) throws XAException, BitronixSystemException {
        if (this.findXAResourceHolderState(xaResourceHolderState.getXAResource()) != null) {
            if (log.isDebugEnabled()) {
                log.debug("delisting resource " + xaResourceHolderState);
            }
            xaResourceHolderState.end(flag);
            return true;
        }
        log.warn("trying to delist resource that has not been previously enlisted: " + xaResourceHolderState);
        return false;
    }

    public void suspend() throws XAException {
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            XAResourceHolderState xaResourceHolderState = (XAResourceHolderState)it.next();
            if (xaResourceHolderState.isEnded()) continue;
            if (log.isDebugEnabled()) {
                log.debug("suspending " + xaResourceHolderState);
            }
            xaResourceHolderState.end(0x4000000);
        }
    }

    public void resume() throws XAException {
        ArrayList<XAResourceHolderState> toBeReEnlisted = new ArrayList<XAResourceHolderState>();
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            XAResourceHolderState xaResourceHolderState = (XAResourceHolderState)it.next();
            if (log.isDebugEnabled()) {
                log.debug("resuming " + xaResourceHolderState);
            }
            toBeReEnlisted.add(new XAResourceHolderState(xaResourceHolderState));
        }
        if (toBeReEnlisted.size() > 0 && log.isDebugEnabled()) {
            log.debug("re-enlisting " + toBeReEnlisted.size() + " resource(s)");
        }
        for (int i = 0; i < toBeReEnlisted.size(); ++i) {
            XAResourceHolderState xaResourceHolderState = (XAResourceHolderState)toBeReEnlisted.get(i);
            if (log.isDebugEnabled()) {
                log.debug("re-enlisting resource " + xaResourceHolderState);
            }
            try {
                this.enlist(xaResourceHolderState);
                xaResourceHolderState.getXAResourceHolder().putXAResourceHolderState(xaResourceHolderState.getXid(), xaResourceHolderState);
                continue;
            }
            catch (BitronixSystemException ex) {
                throw new BitronixXAException("error re-enlisting resource during resume: " + xaResourceHolderState, -3, (Throwable)((Object)ex));
            }
        }
    }

    public XAResourceHolderState findXAResourceHolderState(XAResource xaResource) throws BitronixSystemException {
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            XAResourceHolderState xaResourceHolderState = (XAResourceHolderState)it.next();
            if (xaResourceHolderState.getXAResource() != xaResource) continue;
            return xaResourceHolderState;
        }
        return null;
    }

    private XAResourceHolderState getManagedResourceWithSameRM(XAResourceHolderState xaResourceHolderState) throws XAException {
        if (!xaResourceHolderState.getUseTmJoin()) {
            if (log.isDebugEnabled()) {
                log.debug("join disabled on resource " + xaResourceHolderState);
            }
            return null;
        }
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            XAResourceHolderState alreadyEnlistedHolderState = (XAResourceHolderState)it.next();
            if (log.isDebugEnabled()) {
                log.debug("checking joinability of " + xaResourceHolderState + " with " + alreadyEnlistedHolderState);
            }
            if (alreadyEnlistedHolderState.isEnded() && !alreadyEnlistedHolderState.isSuspended() && xaResourceHolderState.getXAResource().isSameRM(alreadyEnlistedHolderState.getXAResource())) {
                if (log.isDebugEnabled()) {
                    log.debug("resources are joinable");
                }
                return alreadyEnlistedHolderState;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("resources are not joinable");
        }
        if (log.isDebugEnabled()) {
            log.debug("no joinable resource found for " + xaResourceHolderState);
        }
        return null;
    }

    public void clearXAResourceHolderStates() {
        if (log.isDebugEnabled()) {
            log.debug("clearing XAResourceHolder states on " + this.resources.size() + " resource(s)");
        }
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            XAResourceHolderState xaResourceHolderState = (XAResourceHolderState)it.next();
            XAResourceHolder resourceHolder = xaResourceHolderState.getXAResourceHolder();
            resourceHolder.removeXAResourceHolderState(xaResourceHolderState.getXid());
            Map statesForGtrid = resourceHolder.getXAResourceHolderStatesForGtrid(this.gtrid);
            if (statesForGtrid != null) {
                log.warn("resource " + resourceHolder + " did not clean up " + statesForGtrid.size() + "transaction states for GTRID [" + this.gtrid + "]");
            } else if (log.isDebugEnabled()) {
                log.debug("resource " + resourceHolder + " cleaned up all transaction states for GTRID [" + this.gtrid + "]");
            }
            it.remove();
        }
    }

    public Set collectUniqueNames() {
        HashSet<String> names = new HashSet<String>();
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            XAResourceHolderState xaResourceHolderState = (XAResourceHolderState)it.next();
            names.add(xaResourceHolderState.getUniqueName());
        }
        return names;
    }

    public SortedSet getNaturalOrderPositions() {
        return this.resources.getNaturalOrderPositions();
    }

    public SortedSet getReverseOrderPositions() {
        return this.resources.getReverseOrderPositions();
    }

    public List getNaturalOrderResourcesForPosition(Object positionKey) {
        return this.resources.getByNaturalOrderForPosition(positionKey);
    }

    public List getReverseOrderResourcesForPosition(Object positionKey) {
        return this.resources.getByReverseOrderForPosition(positionKey);
    }

    public List getAllResources() {
        ArrayList result = new ArrayList();
        for (Object positionKey : this.resources.getNaturalOrderPositions()) {
            result.addAll(this.resources.getByNaturalOrderForPosition(positionKey));
        }
        return result;
    }

    public int size() {
        return this.resources.size();
    }

    public Uid getGtrid() {
        return this.gtrid;
    }

    public String toString() {
        return "a XAResourceManager with GTRID [" + this.gtrid + "] and " + this.resources;
    }
}

