/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.impl;

import java.util.Collection;
import org.drools.command.CommandService;
import org.drools.command.runtime.GetFactCountInEntryPointCommand;
import org.drools.command.runtime.rule.GetFactHandleInEntryPointCommand;
import org.drools.command.runtime.rule.GetFactHandlesInEntryPointCommand;
import org.drools.command.runtime.rule.GetObjectInEntryPointCommand;
import org.drools.command.runtime.rule.GetObjectsInEntryPointCommand;
import org.drools.command.runtime.rule.InsertObjectInEntryPointCommand;
import org.drools.command.runtime.rule.RetractFromEntryPointCommand;
import org.drools.command.runtime.rule.UpdateInEntryPointCommand;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandBasedWorkingMemoryEntryPoint
implements WorkingMemoryEntryPoint {
    private final CommandService commandService;
    private final String entryPoint;

    public CommandBasedWorkingMemoryEntryPoint(CommandService commandService, String entryPoint) {
        this.commandService = commandService;
        this.entryPoint = entryPoint;
    }

    public String getEntryPointId() {
        return this.entryPoint;
    }

    public FactHandle insert(Object object) {
        return (FactHandle)this.commandService.execute(new InsertObjectInEntryPointCommand(object, this.entryPoint));
    }

    public void retract(FactHandle handle) {
        this.commandService.execute(new RetractFromEntryPointCommand(handle, this.entryPoint));
    }

    public void update(FactHandle handle, Object object) {
        this.commandService.execute(new UpdateInEntryPointCommand(handle, object, this.entryPoint));
    }

    public FactHandle getFactHandle(Object object) {
        return (FactHandle)this.commandService.execute(new GetFactHandleInEntryPointCommand(object, this.entryPoint));
    }

    public Object getObject(FactHandle factHandle) {
        return this.commandService.execute(new GetObjectInEntryPointCommand(factHandle, this.entryPoint));
    }

    public Collection<Object> getObjects() {
        return (Collection)this.commandService.execute(new GetObjectsInEntryPointCommand(null, this.entryPoint));
    }

    public Collection<Object> getObjects(ObjectFilter filter) {
        return (Collection)this.commandService.execute(new GetObjectsInEntryPointCommand(filter, this.entryPoint));
    }

    public <T extends FactHandle> Collection<T> getFactHandles() {
        return (Collection)this.commandService.execute(new GetFactHandlesInEntryPointCommand(this.entryPoint));
    }

    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return (Collection)this.commandService.execute(new GetFactHandlesInEntryPointCommand(this.entryPoint, filter));
    }

    public long getFactCount() {
        return (Long)this.commandService.execute(new GetFactCountInEntryPointCommand(this.entryPoint));
    }
}

