/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import org.drools.ChangeSet;
import org.drools.SystemEventListener;
import org.drools.SystemEventListenerFactory;
import org.drools.concurrent.ExecutorProviderFactory;
import org.drools.io.Resource;
import org.drools.io.ResourceChangeNotifier;
import org.drools.io.ResourceChangeScanner;
import org.drools.io.ResourceChangeScannerConfiguration;
import org.drools.io.impl.ChangeSetImpl;
import org.drools.io.impl.ResourceChangeScannerConfigurationImpl;
import org.drools.io.internal.InternalResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceChangeScannerImpl
implements ResourceChangeScanner {
    private final Map<Resource, Set<ResourceChangeNotifier>> resources;
    private final Set<Resource> directories;
    private SystemEventListener listener = SystemEventListenerFactory.getSystemEventListener();
    private int interval;
    private Future<Boolean> scannerSchedulerExecutor;
    private ProcessChangeSet scannerScheduler;

    public ResourceChangeScannerImpl() {
        this.resources = new HashMap<Resource, Set<ResourceChangeNotifier>>();
        this.directories = new HashSet<Resource>();
        this.setInterval(60);
        this.listener.info("ResourceChangeScanner created with default interval=60");
    }

    public void setSystemEventListener(SystemEventListener listener) {
        this.listener = listener;
    }

    public void configure(ResourceChangeScannerConfiguration configuration) {
        this.setInterval(((ResourceChangeScannerConfigurationImpl)configuration).getInterval());
        this.listener.info("ResourceChangeScanner reconfigured with interval=" + this.getInterval());
        if (this.scannerScheduler != null && this.scannerScheduler.isRunning()) {
            this.stop();
            this.start();
        }
    }

    public ResourceChangeScannerConfiguration newResourceChangeScannerConfiguration() {
        return new ResourceChangeScannerConfigurationImpl();
    }

    public ResourceChangeScannerConfiguration newResourceChangeScannerConfiguration(Properties properties) {
        return new ResourceChangeScannerConfigurationImpl(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeNotifier(ResourceChangeNotifier notifier, Resource resource) {
        Map<Resource, Set<ResourceChangeNotifier>> map = this.resources;
        synchronized (map) {
            Set<ResourceChangeNotifier> notifiers;
            if (((InternalResource)resource).isDirectory()) {
                this.directories.add(resource);
            }
            if ((notifiers = this.resources.get(resource)) == null) {
                notifiers = new HashSet<ResourceChangeNotifier>();
                this.resources.put(resource, notifiers);
            }
            this.listener.debug("ResourceChangeScanner subcribing notifier=" + notifier + " to resource=" + resource);
            notifiers.add(notifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeNotifier(ResourceChangeNotifier notifier, Resource resource) {
        Map<Resource, Set<ResourceChangeNotifier>> map = this.resources;
        synchronized (map) {
            Set<ResourceChangeNotifier> notifiers = this.resources.get(resource);
            if (notifiers == null) {
                return;
            }
            this.listener.debug("ResourceChangeScanner unsubcribing notifier=" + notifier + " to resource=" + resource);
            notifiers.remove(notifier);
            if (notifiers.isEmpty()) {
                this.listener.debug("ResourceChangeScanner resource=" + resource + " now has no subscribers");
                this.resources.remove(resource);
                this.directories.remove(resource);
            }
        }
    }

    public Map<Resource, Set<ResourceChangeNotifier>> getResources() {
        return this.resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan() {
        this.listener.debug("ResourceChangeScanner attempt to scan " + this.resources.size() + " resources");
        Map<Resource, Set<ResourceChangeNotifier>> map = this.resources;
        synchronized (map) {
            HashMap<ResourceChangeNotifier, ChangeSetImpl> notifications = new HashMap<ResourceChangeNotifier, ChangeSetImpl>();
            ArrayList<Resource> removed = new ArrayList<Resource>();
            for (Resource resource : this.directories) {
                this.listener.debug("ResourceChangeScanner scanning directory=" + resource);
                for (Resource child : ((InternalResource)resource).listResources()) {
                    if (((InternalResource)child).isDirectory() || this.resources.containsKey(child)) continue;
                    this.listener.debug("ResourceChangeScanner new resource=" + child);
                    ((InternalResource)child).setResourceType(((InternalResource)resource).getResourceType());
                    Set<ResourceChangeNotifier> notifiers = this.resources.get(resource);
                    for (ResourceChangeNotifier notifier : notifiers) {
                        ChangeSetImpl changeSet = (ChangeSetImpl)notifications.get(notifier);
                        if (changeSet == null) {
                            changeSet = new ChangeSetImpl();
                            notifications.put(notifier, changeSet);
                        }
                        if (changeSet.getResourcesAdded().isEmpty()) {
                            changeSet.setResourcesAdded(new ArrayList<Resource>());
                        }
                        changeSet.getResourcesAdded().add(child);
                        notifier.subscribeChildResource(resource, child);
                    }
                }
            }
            for (Map.Entry entry : this.resources.entrySet()) {
                ChangeSetImpl changeSet;
                Resource resource = (Resource)entry.getKey();
                Set notifiers = (Set)entry.getValue();
                if (((InternalResource)resource).isDirectory()) continue;
                long lastModified = ((InternalResource)resource).getLastModified();
                long lastRead = ((InternalResource)resource).getLastRead();
                if (lastModified == 0L) {
                    this.listener.debug("ResourceChangeScanner removed resource=" + resource);
                    removed.add(resource);
                    for (ResourceChangeNotifier notifier : notifiers) {
                        changeSet = (ChangeSetImpl)notifications.get(notifier);
                        if (changeSet == null) {
                            changeSet = new ChangeSetImpl();
                            notifications.put(notifier, changeSet);
                        }
                        if (changeSet.getResourcesRemoved().isEmpty()) {
                            changeSet.setResourcesRemoved(new ArrayList<Resource>());
                        }
                        changeSet.getResourcesRemoved().add(resource);
                    }
                    continue;
                }
                if (lastRead >= lastModified) continue;
                this.listener.debug("ResourceChangeScanner modified resource=" + resource + " : " + lastRead + " : " + lastModified);
                for (ResourceChangeNotifier notifier : notifiers) {
                    changeSet = (ChangeSetImpl)notifications.get(notifier);
                    if (changeSet == null) {
                        changeSet = new ChangeSetImpl();
                        notifications.put(notifier, changeSet);
                    }
                    if (changeSet.getResourcesModified().isEmpty()) {
                        changeSet.setResourcesModified(new ArrayList<Resource>());
                    }
                    changeSet.getResourcesModified().add(resource);
                }
            }
            for (Resource resource : removed) {
                this.resources.remove(resource);
            }
            for (Map.Entry entry : notifications.entrySet()) {
                ResourceChangeNotifier notifier = (ResourceChangeNotifier)entry.getKey();
                ChangeSet changeSet = (ChangeSet)entry.getValue();
                notifier.publishChangeSet(changeSet);
            }
        }
    }

    public void setInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("Invalid interval time: " + interval + ". It should be a positive number bigger than 0");
        }
        this.interval = interval;
        this.listener.info("ResourceChangeScanner reconfigured with interval=" + this.getInterval());
        if (this.scannerScheduler != null && this.scannerScheduler.isRunning()) {
            this.stop();
            this.start();
        }
    }

    public int getInterval() {
        return this.interval;
    }

    public void start() {
        this.scannerScheduler = new ProcessChangeSet(this.resources, this, this.listener, this.interval);
        this.scannerSchedulerExecutor = ExecutorProviderFactory.getExecutorProvider().getCompletionService().submit(this.scannerScheduler, true);
    }

    public void stop() {
        if (this.scannerScheduler != null && this.scannerScheduler.isRunning()) {
            this.scannerScheduler.stop();
            this.scannerSchedulerExecutor.cancel(true);
            this.scannerScheduler = null;
        }
    }

    public void reset() {
        this.resources.clear();
        this.directories.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProcessChangeSet
    implements Runnable {
        private volatile boolean scan;
        private final ResourceChangeScannerImpl scanner;
        private final long interval;
        private final Map<Resource, Set<ResourceChangeNotifier>> resources;
        private final SystemEventListener listener;

        ProcessChangeSet(Map<Resource, Set<ResourceChangeNotifier>> resources, ResourceChangeScannerImpl scanner, SystemEventListener listener, int interval) {
            this.resources = resources;
            this.scanner = scanner;
            this.listener = listener;
            this.interval = interval;
            this.scan = true;
        }

        public int getInterval() {
            return (int)this.interval;
        }

        public void stop() {
            this.scan = false;
        }

        public boolean isRunning() {
            return this.scan;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProcessChangeSet processChangeSet = this;
            synchronized (processChangeSet) {
                if (this.scan) {
                    this.listener.info("ResourceChangeNotification scanner has started");
                }
                while (this.scan) {
                    try {
                        Map<Resource, Set<ResourceChangeNotifier>> map = this.resources;
                        synchronized (map) {
                            this.scanner.scan();
                        }
                    }
                    catch (RuntimeException e) {
                        this.listener.exception((Throwable)e);
                    }
                    catch (Error e) {
                        this.listener.exception((Throwable)e);
                    }
                    try {
                        this.listener.debug("ResourceChangeScanner thread is waiting for " + this.interval + " seconds.");
                        this.wait(this.interval * 1000L);
                    }
                    catch (InterruptedException e) {
                        if (!this.scan) continue;
                        this.listener.exception((Throwable)new RuntimeException("ResourceChangeNotification ChangeSet scanning thread was interrupted, but shutdown was not requested", e));
                    }
                }
                this.listener.info("ResourceChangeNotification scanner has stopped");
            }
        }
    }
}

