/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.drools.base.DroolsQuery;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.UpdateContext;
import org.drools.reteoo.AbstractTerminalNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.spi.PropagationContext;

public final class QueryTerminalNode
extends AbstractTerminalNode
implements LeftTupleSinkNode {
    private static final long serialVersionUID = 510L;
    public static final short type = 8;
    private Query query;
    private GroupElement subrule;
    private int subruleIndex;
    private Declaration[] declarations;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private int leftInputOtnId;

    public QueryTerminalNode() {
    }

    public QueryTerminalNode(int id, LeftTupleSource source, Rule rule, GroupElement subrule, int subruleIndex, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), source);
        this.query = (Query)rule;
        this.subrule = subrule;
        this.subruleIndex = subruleIndex;
        this.initDeclaredMask(context);
        this.initInferredMask();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.query = (Query)in.readObject();
        this.subrule = (GroupElement)in.readObject();
        this.subruleIndex = in.readInt();
        this.leftInputOtnId = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.query);
        out.writeObject(this.subrule);
        out.writeInt(this.subruleIndex);
        out.writeLong(this.leftInputOtnId);
    }

    public Rule getRule() {
        return this.query;
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple entry = leftTuple;
        while (entry.getParent() != null) {
            entry = entry.getParent();
        }
        DroolsQuery query = (DroolsQuery)entry.getLastHandle().getObject();
        query.setQuery(this.query);
        query.getQueryResultCollector().rowAdded(this.query, leftTuple, context, workingMemory);
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple entry = leftTuple;
        while (entry.getParent() != null) {
            entry = entry.getParent();
        }
        DroolsQuery query = (DroolsQuery)entry.getLastHandle().getObject();
        query.setQuery(this.query);
        query.getQueryResultCollector().rowRemoved(this.query, leftTuple, context, workingMemory);
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple entry = leftTuple;
        while (entry.getParent() != null) {
            entry = entry.getParent();
        }
        DroolsQuery query = (DroolsQuery)entry.getLastHandle().getObject();
        query.setQuery(this.query);
        query.getQueryResultCollector().rowUpdated(this.query, leftTuple, context, workingMemory);
    }

    public String toString() {
        return "[QueryTerminalNode(" + this.getId() + "): query=" + this.query.getName() + "]";
    }

    public void attach(BuildContext context) {
        this.getLeftTupleSource().addTupleSink(this, context);
        if (context == null) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.getLeftTupleSource().updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated(UpdateContext updateContext) {
        this.getLeftTupleSource().networkUpdated(updateContext);
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        this.getLeftTupleSource().remove(context, builder, this, workingMemories);
    }

    public boolean isInUse() {
        return false;
    }

    public void updateNewNode(InternalWorkingMemory workingMemory, PropagationContext context) {
    }

    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
    }

    public GroupElement getSubrule() {
        return this.subrule;
    }

    public Declaration[] getDeclarations() {
        if (this.declarations == null) {
            this.declarations = new Declaration[this.query.getParameters().length];
            Map<String, Declaration> declMap = this.subrule.getOuterDeclarations();
            int i = 0;
            for (Declaration declr : this.query.getParameters()) {
                this.declarations[i++] = declMap.get(declr.getIdentifier());
            }
        }
        return this.declarations;
    }

    public int getSubruleIndex() {
        return this.subruleIndex;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public short getType() {
        return 8;
    }

    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, sink, leftTupleMemoryEnabled);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    public int getLeftInputOtnId() {
        return this.leftInputOtnId;
    }

    public void setLeftInputOtnId(int leftInputOtnId) {
        this.leftInputOtnId = leftInputOtnId;
    }
}

