/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.Date;
import java.util.List;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.UserTransaction;
import org.drools.WorkingMemory;
import org.drools.audit.WorkingMemoryLogger;
import org.drools.audit.event.LogEvent;
import org.drools.audit.event.RuleFlowLogEvent;
import org.drools.audit.event.RuleFlowNodeLogEvent;
import org.drools.audit.event.RuleFlowVariableLogEvent;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.impl.StatelessKnowledgeSessionImpl;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeRuntime;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAWorkingMemoryDbLogger
extends WorkingMemoryLogger {
    private static Logger logger = LoggerFactory.getLogger(JPAWorkingMemoryDbLogger.class);
    protected Environment env;

    public JPAWorkingMemoryDbLogger(WorkingMemory workingMemory) {
        super(workingMemory);
        this.env = workingMemory.getEnvironment();
    }

    public JPAWorkingMemoryDbLogger(KnowledgeRuntimeEventManager session) {
        super(session);
        if (session instanceof KnowledgeRuntime) {
            this.env = ((KnowledgeRuntime)session).getEnvironment();
        } else if (session instanceof StatelessKnowledgeSessionImpl) {
            this.env = ((StatelessKnowledgeSessionImpl)session).getEnvironment();
        } else {
            throw new IllegalArgumentException("Not supported session in logger: " + session.getClass());
        }
    }

    public void logEventCreated(LogEvent logEvent) {
        switch (logEvent.getType()) {
            case 8: {
                RuleFlowLogEvent processEvent = (RuleFlowLogEvent)logEvent;
                this.addProcessLog(processEvent.getProcessInstanceId(), processEvent.getProcessId());
                break;
            }
            case 11: {
                RuleFlowLogEvent processEvent = (RuleFlowLogEvent)logEvent;
                this.updateProcessLog(processEvent.getProcessInstanceId());
                break;
            }
            case 24: {
                RuleFlowNodeLogEvent nodeEvent = (RuleFlowNodeLogEvent)logEvent;
                this.addNodeEnterLog(nodeEvent.getProcessInstanceId(), nodeEvent.getProcessId(), nodeEvent.getNodeInstanceId(), nodeEvent.getNodeId(), nodeEvent.getNodeName());
                break;
            }
            case 26: {
                RuleFlowNodeLogEvent nodeEvent = (RuleFlowNodeLogEvent)logEvent;
                this.addNodeExitLog(nodeEvent.getProcessInstanceId(), nodeEvent.getProcessId(), nodeEvent.getNodeInstanceId(), nodeEvent.getNodeId(), nodeEvent.getNodeName());
                break;
            }
            case 33: {
                RuleFlowVariableLogEvent variableEvent = (RuleFlowVariableLogEvent)logEvent;
                this.addVariableLog(variableEvent.getProcessInstanceId(), variableEvent.getProcessId(), variableEvent.getVariableInstanceId(), variableEvent.getVariableId(), variableEvent.getObjectToString());
                break;
            }
        }
    }

    private void addProcessLog(long processInstanceId, String processId) {
        ProcessInstanceLog log = new ProcessInstanceLog(processInstanceId, processId);
        this.persist(log);
    }

    private void updateProcessLog(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        UserTransaction ut = JPAWorkingMemoryDbLogger.joinTransaction(em);
        List result = em.createQuery("from ProcessInstanceLog as log where log.processInstanceId = ? and log.end is null").setParameter(1, (Object)processInstanceId).getResultList();
        if (result != null && result.size() != 0) {
            ProcessInstanceLog log = (ProcessInstanceLog)result.get(result.size() - 1);
            log.setEnd(new Date());
            em.merge((Object)log);
        }
        JPAWorkingMemoryDbLogger.flush(em, ut);
    }

    private void addNodeEnterLog(long processInstanceId, String processId, String nodeInstanceId, String nodeId, String nodeName) {
        NodeInstanceLog log = new NodeInstanceLog(0, processInstanceId, processId, nodeInstanceId, nodeId, nodeName);
        this.persist(log);
    }

    private void addNodeExitLog(long processInstanceId, String processId, String nodeInstanceId, String nodeId, String nodeName) {
        NodeInstanceLog log = new NodeInstanceLog(1, processInstanceId, processId, nodeInstanceId, nodeId, nodeName);
        this.persist(log);
    }

    private void addVariableLog(long processInstanceId, String processId, String variableInstanceId, String variableId, String objectToString) {
        VariableInstanceLog log = new VariableInstanceLog(processInstanceId, processId, variableInstanceId, variableId, objectToString);
        this.persist(log);
    }

    public void dispose() {
    }

    private EntityManager getEntityManager() {
        EntityManagerFactory emf = (EntityManagerFactory)this.env.get("drools.persistence.jpa.EntityManagerFactory");
        return emf.createEntityManager();
    }

    private void persist(Object entity) {
        EntityManager em = this.getEntityManager();
        UserTransaction ut = JPAWorkingMemoryDbLogger.joinTransaction(em);
        em.persist(entity);
        JPAWorkingMemoryDbLogger.flush(em, ut);
    }

    private static UserTransaction joinTransaction(EntityManager em) {
        boolean newTx = false;
        UserTransaction ut = null;
        try {
            ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
            if (ut.getStatus() == 6) {
                ut.begin();
                newTx = true;
            }
        }
        catch (Exception e) {
            logger.error("Unable to find or open a transaction: " + e.getMessage());
            e.printStackTrace();
        }
        em.joinTransaction();
        if (newTx) {
            return ut;
        }
        return null;
    }

    private static void flush(EntityManager em, UserTransaction ut) {
        em.flush();
        em.clear();
        em.close();
        try {
            if (ut != null) {
                ut.commit();
            }
        }
        catch (Exception e) {
            logger.error("Unable to commit transaction: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

