/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.example.discard;

import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.WriteCompletionEvent;

public class DiscardClientHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = Logger.getLogger(DiscardClientHandler.class.getName());
    private final AtomicLong transferredBytes = new AtomicLong();
    private final byte[] content;

    public DiscardClientHandler(int messageSize) {
        if (messageSize <= 0) {
            throw new IllegalArgumentException("messageSize: " + messageSize);
        }
        this.content = new byte[messageSize];
    }

    public long getTransferredBytes() {
        return this.transferredBytes.get();
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent && ((ChannelStateEvent)e).getState() != ChannelState.INTEREST_OPS) {
            logger.info(e.toString());
        }
        super.handleUpstream(ctx, e);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.generateTraffic(e);
    }

    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.generateTraffic(e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) {
        this.transferredBytes.addAndGet(e.getWrittenAmount());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", e.getCause());
        e.getChannel().close();
    }

    private void generateTraffic(ChannelStateEvent e) {
        ChannelBuffer m;
        Channel channel = e.getChannel();
        while (channel.isWritable() && (m = this.nextMessage()) != null) {
            channel.write(m);
        }
    }

    private ChannelBuffer nextMessage() {
        return ChannelBuffers.wrappedBuffer(this.content);
    }
}

