/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManagerFactory;
import org.drools.SystemEventListener;
import org.jbpm.eventmessaging.EventKeys;
import org.jbpm.task.AccessType;
import org.jbpm.task.AllowedToDelegate;
import org.jbpm.task.Attachment;
import org.jbpm.task.BooleanExpression;
import org.jbpm.task.Comment;
import org.jbpm.task.Content;
import org.jbpm.task.Deadline;
import org.jbpm.task.Deadlines;
import org.jbpm.task.Delegation;
import org.jbpm.task.EmailNotification;
import org.jbpm.task.EmailNotificationHeader;
import org.jbpm.task.Escalation;
import org.jbpm.task.Group;
import org.jbpm.task.I18NText;
import org.jbpm.task.Notification;
import org.jbpm.task.NotificationType;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Reassignment;
import org.jbpm.task.Status;
import org.jbpm.task.StatusChange;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.WorkItemNotification;
import org.jbpm.task.admin.TasksAdmin;
import org.jbpm.task.event.MessagingTaskEventListener;
import org.jbpm.task.event.TaskEventListener;
import org.jbpm.task.event.TaskEventSupport;
import org.jbpm.task.query.DeadlineSummary;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.Allowed;
import org.jbpm.task.service.Command;
import org.jbpm.task.service.CommandName;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.DefaultEscalatedDeadlineHandler;
import org.jbpm.task.service.EscalatedDeadlineHandler;
import org.jbpm.task.service.Operation;
import org.jbpm.task.service.OperationCommand;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.persistence.TaskSessionFactory;
import org.jbpm.task.service.persistence.TaskSessionFactoryImpl;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskService {
    private TaskSessionFactory sessionFactory;
    private ScheduledThreadPoolExecutor scheduler;
    private EscalatedDeadlineHandler escalatedDeadlineHandler;
    private UserInfo userInfo;
    private TaskEventSupport eventSupport;
    private EventKeys eventKeys;
    private static final Logger logger = LoggerFactory.getLogger(TaskService.class);
    private SystemEventListener systemEventListener;
    private Map<Operation, List<OperationCommand>> operations;
    private static Map<String, Class<?>> inputs = new HashMap();

    public TaskService(EntityManagerFactory emf, SystemEventListener systemEventListener) {
        this.initialize(emf, systemEventListener, null);
    }

    public TaskService(EntityManagerFactory emf, SystemEventListener systemEventListener, EscalatedDeadlineHandler escalationHandler) {
        this.initialize(emf, systemEventListener, escalationHandler);
    }

    private void initialize(EntityManagerFactory emf, SystemEventListener systemEventListener, EscalatedDeadlineHandler escalationHandler) {
        this.sessionFactory = new TaskSessionFactoryImpl(this, emf);
        this.systemEventListener = systemEventListener;
        this.escalatedDeadlineHandler = escalationHandler != null ? escalationHandler : new DefaultEscalatedDeadlineHandler();
        this.initialize();
    }

    public void initialize() {
        this.eventSupport = new TaskEventSupport();
        this.eventKeys = new EventKeys();
        this.eventSupport.addEventListener(new MessagingTaskEventListener(this.eventKeys));
        this.scheduler = new ScheduledThreadPoolExecutor(3);
        TaskServiceSession session = this.createSession();
        session.scheduleUnescalatedDeadlines();
        session.dispose();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        InputStream is = null;
        for (Class<?> c = this.getClass(); c != null && (is = c.getResourceAsStream("operations-dsl.mvel")) == null; c = c.getSuperclass()) {
        }
        if (is == null) {
            throw new RuntimeException("Unable To initialise TaskService, could not find Operations DSL");
        }
        InputStreamReader reader = new InputStreamReader(is);
        try {
            this.operations = (Map)TaskService.eval(TaskService.toString(reader), vars);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable To initialise TaskService, could not load Operations DSL");
        }
    }

    public TaskService() {
    }

    public void setSystemEventListener(SystemEventListener systemEventListener) {
        this.systemEventListener = systemEventListener;
    }

    public void setTaskSessionFactory(TaskSessionFactory taskSessionFactory) {
        this.sessionFactory = taskSessionFactory;
    }

    public TaskServiceSession createSession() {
        return this.sessionFactory.createTaskServiceSession();
    }

    public TasksAdmin createTaskAdmin() {
        return this.sessionFactory.createTaskAdmin();
    }

    public void schedule(ScheduledTaskDeadline deadline, long delay) {
        this.scheduler.schedule(deadline, delay, TimeUnit.MILLISECONDS);
    }

    public Map<Operation, List<OperationCommand>> getOperations() {
        return this.operations;
    }

    public List<OperationCommand> getCommandsForOperation(Operation operation) {
        return this.operations.get((Object)operation);
    }

    public EventKeys getEventKeys() {
        return this.eventKeys;
    }

    public void addEventListener(TaskEventListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removeEventListener(TaskEventListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    public List<TaskEventListener> getWorkingMemoryEventListeners() {
        return this.eventSupport.getEventListeners();
    }

    public TaskEventSupport getEventSupport() {
        return this.eventSupport;
    }

    public UserInfo getUserinfo() {
        return this.userInfo;
    }

    public void setUserinfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public void setEscalatedDeadlineHandler(EscalatedDeadlineHandler escalatedDeadlineHandler) {
        this.escalatedDeadlineHandler = escalatedDeadlineHandler;
    }

    public synchronized void executeEscalatedDeadline(long taskId, long deadlineId) {
        TaskServiceSession session = this.createSession();
        session.executeEscalatedDeadline(this.escalatedDeadlineHandler, this, taskId, deadlineId);
        session.dispose();
    }

    public void addUsersAndGroups(Map<String, User> users, Map<String, Group> groups) {
        TaskServiceSession taskSession = this.createSession();
        for (User user : users.values()) {
            taskSession.addUser(user);
        }
        for (Group group : groups.values()) {
            taskSession.addGroup(group);
        }
        taskSession.dispose();
    }

    public static String toString(Reader reader) throws IOException {
        int charValue;
        StringBuffer sb = new StringBuffer(1024);
        while ((charValue = reader.read()) != -1) {
            sb.append((char)charValue);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Class<?>> getInputs() {
        Map<String, Class<?>> map = inputs;
        synchronized (map) {
            if (inputs.isEmpty()) {
                inputs.put("AccessType", AccessType.class);
                inputs.put("AllowedToDelegate", AllowedToDelegate.class);
                inputs.put("Attachment", Attachment.class);
                inputs.put("BooleanExpression", BooleanExpression.class);
                inputs.put("Comment", Comment.class);
                inputs.put("Content", Content.class);
                inputs.put("Deadline", Deadline.class);
                inputs.put("Deadlines", Deadlines.class);
                inputs.put("Delegation", Delegation.class);
                inputs.put("EmailNotification", EmailNotification.class);
                inputs.put("EmailNotificationHeader", EmailNotificationHeader.class);
                inputs.put("Escalation", Escalation.class);
                inputs.put("Group", Group.class);
                inputs.put("I18NText", I18NText.class);
                inputs.put("Notification", Notification.class);
                inputs.put("NotificationType", NotificationType.class);
                inputs.put("OrganizationalEntity", OrganizationalEntity.class);
                inputs.put("PeopleAssignments", PeopleAssignments.class);
                inputs.put("Reassignment", Reassignment.class);
                inputs.put("Status", Status.class);
                inputs.put("StatusChange", StatusChange.class);
                inputs.put("Task", Task.class);
                inputs.put("TaskData", TaskData.class);
                inputs.put("User", User.class);
                inputs.put("UserInfo", UserInfo.class);
                inputs.put("WorkItemNotification", WorkItemNotification.class);
                inputs.put("Allowed", Allowed.class);
                inputs.put("Command", Command.class);
                inputs.put("CommandName", CommandName.class);
                inputs.put("ContentData", ContentData.class);
                inputs.put("Operation", Operation.class);
                inputs.put("Operation.Claim", Operation.class);
                inputs.put("OperationCommand", OperationCommand.class);
                inputs.put("DeadlineSummary", DeadlineSummary.class);
                inputs.put("TaskSummary", TaskSummary.class);
            }
            return inputs;
        }
    }

    public static Object eval(Reader reader) {
        try {
            return TaskService.eval(TaskService.toString(reader), null);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception Thrown", e);
        }
    }

    public static Object eval(Reader reader, Map<String, Object> vars) {
        try {
            return TaskService.eval(TaskService.toString(reader), vars);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception Thrown", e);
        }
    }

    public static Object eval(String str, Map<String, Object> vars) {
        ParserConfiguration pconf = new ParserConfiguration();
        pconf.addPackageImport("org.jbpm.task");
        pconf.addPackageImport("org.jbpm.task.service");
        pconf.addPackageImport("org.jbpm.task.query");
        pconf.addPackageImport("java.util");
        for (String entry : TaskService.getInputs().keySet()) {
            pconf.addImport(entry, TaskService.getInputs().get(entry));
        }
        ParserContext context = new ParserContext(pconf);
        Serializable s = MVEL.compileExpression((String)str.trim(), (ParserContext)context);
        if (vars != null) {
            return MVEL.executeExpression((Object)s, vars);
        }
        return MVEL.executeExpression((Object)s);
    }

    public static class ScheduledTaskDeadline
    implements Callable {
        private long taskId;
        private long deadlineId;
        private TaskService service;

        public ScheduledTaskDeadline(long taskId, long deadlineId, TaskService service) {
            this.taskId = taskId;
            this.deadlineId = deadlineId;
            this.service = service;
        }

        public long getTaskId() {
            return this.taskId;
        }

        public long getDeadlineId() {
            return this.deadlineId;
        }

        public Object call() throws Exception {
            try {
                this.service.executeEscalatedDeadline(this.taskId, this.deadlineId);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.deadlineId ^ this.deadlineId >>> 32);
            result = 31 * result + (int)(this.taskId ^ this.taskId >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ScheduledTaskDeadline)) {
                return false;
            }
            ScheduledTaskDeadline other = (ScheduledTaskDeadline)obj;
            if (this.deadlineId != other.deadlineId) {
                return false;
            }
            return this.taskId == other.taskId;
        }
    }
}

