/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.persistence;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.jbpm.task.Group;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.query.DeadlineSummary;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.IncorrectParametersException;
import org.jbpm.task.service.TaskException;
import org.jbpm.task.service.persistence.TaskLocalTransactionManager;
import org.jbpm.task.service.persistence.TaskTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPersistenceManager {
    private static Logger logger = LoggerFactory.getLogger(TaskPersistenceManager.class);
    private TaskTransactionManager ttxm;
    private EntityManager em;
    public static final String FIRST_RESULT = "firstResult";
    public static final String MAX_RESULTS = "maxResults";

    TaskPersistenceManager(EntityManager em) {
        this.em = em;
        this.ttxm = new TaskLocalTransactionManager();
    }

    TaskPersistenceManager(EntityManager entityManager, TaskTransactionManager ttxm) {
        this.em = entityManager;
        this.ttxm = ttxm;
    }

    public boolean beginTransaction() {
        boolean txOwner = this.ttxm.begin(this.em);
        this.ttxm.attachPersistenceContext(this.em);
        return txOwner;
    }

    public void endTransaction(boolean txOwner) {
        try {
            this.ttxm.commit(this.em, txOwner);
        }
        catch (RuntimeException re) {
            logger.error("Unable to commit, rolling back transaction.", (Throwable)re);
            this.ttxm.rollback(this.em, txOwner);
            throw re;
        }
    }

    public void rollBackTransaction(boolean txOwner) {
        try {
            this.ttxm.rollback(this.em, txOwner);
        }
        catch (RuntimeException re) {
            logger.error("Unable to rollback transaction (or to mark as 'to rollback')!", (Throwable)re);
        }
    }

    public void dispose() {
        this.endPersistenceContext();
    }

    public void endPersistenceContext() {
        if (this.em == null) {
            this.ttxm = null;
            return;
        }
        boolean closeEm = this.em.isOpen();
        if (closeEm) {
            try {
                this.ttxm.dispose();
                this.em.clear();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                this.em.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.em = null;
        this.ttxm = null;
    }

    public List<DeadlineSummary> getUnescalatedDeadlines() {
        boolean txOwner = this.beginTransaction();
        List<DeadlineSummary> resultList = this.getUnescalatedDeadlinesList();
        this.endTransaction(txOwner);
        return resultList;
    }

    public void setTaskStatusInTransaction(Object taskId, Status taskStatus) {
        boolean txOwner = this.beginTransaction();
        Task task = (Task)this.em.find(Task.class, taskId);
        task.getTaskData().setStatus(Status.Completed);
        this.em.persist((Object)task);
        this.endTransaction(txOwner);
    }

    public List<DeadlineSummary> getUnescalatedDeadlinesList() {
        Object result = this.queryInTransaction("UnescalatedDeadlines");
        return (List)result;
    }

    public Object findEntity(Class<?> entityClass, Object primaryKey) {
        return this.em.find(entityClass, primaryKey);
    }

    public void deleteEntity(Object entity) {
        this.em.remove(entity);
    }

    public void saveEntity(Object entity) {
        this.em.persist(entity);
    }

    public Query createNewQuery(String queryString) {
        return this.em.createQuery(queryString);
    }

    public boolean userExists(String userId) {
        return this.em.find(User.class, (Object)userId) != null;
    }

    public boolean groupExists(String groupId) {
        return this.em.find(Group.class, (Object)groupId) != null;
    }

    public List<TaskSummary> queryTasksWithUserIdAndLanguage(String queryName, String userId, String language) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("language", language);
        Object resultListObject = this.queryWithParametersInTransaction(queryName, params);
        return (List)resultListObject;
    }

    public List<TaskSummary> queryTasksWithUserIdStatusAndLanguage(String queryName, String userId, List<Status> status, String language) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("status", status);
        params.put("language", language);
        Object resultListObject = this.queryWithParametersInTransaction(queryName, params);
        return (List)resultListObject;
    }

    public Object queryWithParametersInTransaction(String queryName, Map<String, Object> params, boolean singleResult) {
        Object result = null;
        boolean txOwner = false;
        boolean operationSuccessful = false;
        boolean txStarted = false;
        try {
            txOwner = this.beginTransaction();
            txStarted = true;
            result = this.queryWithParameters(queryName, params, singleResult);
            operationSuccessful = true;
            this.endTransaction(txOwner);
        }
        catch (Exception e) {
            this.rollBackTransaction(txOwner);
            String message = !txStarted ? "Could not start transaction." : (!operationSuccessful ? "Operation failed" : "Could not commit transaction");
            if (e instanceof TaskException) {
                throw (TaskException)e;
            }
            throw new RuntimeException(message, e);
        }
        return result;
    }

    public Object queryWithParametersInTransaction(String queryName, Map<String, Object> params) {
        return this.queryWithParametersInTransaction(queryName, params, false);
    }

    public Object queryInTransaction(String queryName) {
        return this.queryWithParametersInTransaction(queryName, null, false);
    }

    private Object queryWithParameters(String queryName, Map<String, Object> params, boolean singleResult) {
        Query query = this.em.createNamedQuery(queryName);
        if (params != null && !params.isEmpty()) {
            for (String name : params.keySet()) {
                if (FIRST_RESULT.equals(name)) {
                    query.setFirstResult(((Integer)params.get(name)).intValue());
                    continue;
                }
                if (MAX_RESULTS.equals(name)) {
                    query.setMaxResults(((Integer)params.get(name)).intValue());
                    continue;
                }
                query.setParameter(name, params.get(name));
            }
        }
        if (singleResult) {
            return query.getSingleResult();
        }
        return query.getResultList();
    }

    public static HashMap<String, Object> addParametersToMap(Object ... parameterValues) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (parameterValues.length % 2 != 0) {
            throw new IncorrectParametersException("Expected an even number of parameters, not " + parameterValues.length);
        }
        for (int i = 0; i < parameterValues.length; ++i) {
            String parameterName = null;
            if (!(parameterValues[i] instanceof String)) {
                throw new IncorrectParametersException("Expected a String as the parameter name, not a " + parameterValues[i].getClass().getSimpleName());
            }
            parameterName = (String)parameterValues[i];
            parameters.put(parameterName, parameterValues[++i]);
        }
        return parameters;
    }
}

