/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.jms;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.service.BaseClientHandler;
import org.jbpm.task.service.BaseHandler;
import org.jbpm.task.service.Command;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.jms.JMSTaskClientHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSTaskClientConnector
implements TaskClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(JMSTaskClientConnector.class);
    protected final BaseClientHandler handler;
    protected final String name;
    protected AtomicInteger counter;
    private MessageProducer producer;
    private Properties connectionProperties;
    private Context context;
    private boolean transactedQueue = false;
    private boolean enableLog = false;
    private String selector;
    protected QueueConnection connection;
    protected QueueSession producerSession;
    protected QueueSession consumerSession;
    protected Queue taskServerQueue;
    protected Queue responseQueue;

    public JMSTaskClientConnector(String name, BaseClientHandler handler, Properties connectionProperties, Context context) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        this.name = name;
        this.handler = handler;
        this.connectionProperties = connectionProperties;
        this.context = context;
        this.counter = new AtomicInteger();
        if (System.getProperty("enableLog") != null) {
            this.enableLog = Boolean.parseBoolean(System.getProperty("enableLog"));
        }
    }

    public boolean connect(String address, int port) {
        return this.connect();
    }

    public boolean connect() {
        if (this.producerSession != null) {
            return true;
        }
        try {
            String connFactoryName = this.connectionProperties.getProperty("JMSTaskClient.connectionFactory");
            String transactedQueueString = this.connectionProperties.getProperty("JMSTaskClient.transactedQueue");
            String acknowledgeModeString = this.connectionProperties.getProperty("JMSTaskClient.acknowledgeMode");
            String taskServerQueueName = this.connectionProperties.getProperty("JMSTaskClient.queueName");
            String responseQueueName = this.connectionProperties.getProperty("JMSTaskClient.responseQueueName");
            this.transactedQueue = Boolean.valueOf(transactedQueueString);
            int acknowledgeMode = 3;
            if ("AUTO_ACKNOWLEDGE".equals(acknowledgeModeString)) {
                acknowledgeMode = 1;
            } else if ("CLIENT_ACKNOWLEDGE".equals(acknowledgeModeString)) {
                acknowledgeMode = 2;
            }
            Context ctx = this.context;
            if (ctx == null) {
                ctx = new InitialContext();
            }
            QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup(connFactoryName);
            this.connection = factory.createQueueConnection();
            this.producerSession = this.connection.createQueueSession(this.transactedQueue, acknowledgeMode);
            this.consumerSession = this.connection.createQueueSession(this.transactedQueue, acknowledgeMode);
            this.taskServerQueue = this.producerSession.createQueue(taskServerQueueName);
            this.responseQueue = this.consumerSession.createQueue(responseQueueName);
            this.producer = this.producerSession.createProducer((Destination)this.taskServerQueue);
            this.connection.start();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private Object readMessage(ObjectMessage serverMessage) throws JMSException {
        return serverMessage.getObject();
    }

    public void disconnect() {
        try {
            if (this.producer != null) {
                this.producer.close();
            }
            if (this.producerSession != null) {
                this.producerSession.close();
            }
            if (this.consumerSession != null) {
                this.consumerSession.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object object) {
        try {
            ObjectMessage message = this.producerSession.createObjectMessage();
            this.selector = UUID.randomUUID().toString();
            Command cObj = (Command)object;
            List<Object> args = cObj.getArguments();
            boolean removeEvent = true;
            if (args.get(0) instanceof TaskEventKey) {
                TaskEventKey eventKey = (TaskEventKey)args.get(0);
                removeEvent = (Boolean)args.get(1);
                logger.info("write() registering following taskEventKey with Human Task Server :\n\t" + eventKey.getEvent() + "\n\tremoveEvent = " + removeEvent + "\n\tselector = " + this.selector);
            } else if (this.enableLog) {
                logger.info("write() selector = " + this.selector + " : command = " + args.get(0));
            }
            Thread responseThread = new Thread(new Responder(this.selector, removeEvent));
            responseThread.start();
            message.setStringProperty("taskClientId", this.selector);
            message.setObject((Serializable)object);
            MessageProducer messageProducer = this.producer;
            synchronized (messageProducer) {
                this.producer.send((Message)message);
                if (this.transactedQueue) {
                    this.producerSession.commit();
                }
            }
        }
        catch (Throwable e) {
            logger.error("write() exception when attempting to write to : " + this.taskServerQueue);
            throw new RuntimeException("Error creating message", e);
        }
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    public BaseHandler getHandler() {
        return this.handler;
    }

    public String getName() {
        return this.name;
    }

    protected class Responder
    implements Runnable {
        private final String selector;
        private final boolean removeEvent;

        protected Responder(String selector, boolean removeEvent) {
            this.selector = selector;
            this.removeEvent = removeEvent;
        }

        private void handleMessage(ObjectMessage serverMessage) throws Exception {
            if (serverMessage == null) {
                throw new RuntimeException("handleMessage() message received from Human Task Server is null!");
            }
            ((JMSTaskClientHandler)JMSTaskClientConnector.this.handler).messageReceived((Session)JMSTaskClientConnector.this.consumerSession, JMSTaskClientConnector.this.readMessage(serverMessage), (Destination)JMSTaskClientConnector.this.responseQueue, this.selector);
        }

        public void run() {
            block13: {
                MessageConsumer consumer = null;
                try {
                    consumer = JMSTaskClientConnector.this.consumerSession.createConsumer((Destination)JMSTaskClientConnector.this.responseQueue, " taskClientId like '" + this.selector + "%' ");
                    ObjectMessage serverMessage = null;
                    if (this.removeEvent) {
                        serverMessage = (ObjectMessage)consumer.receive();
                        this.handleMessage(serverMessage);
                        if (JMSTaskClientConnector.this.transactedQueue) {
                            JMSTaskClientConnector.this.consumerSession.commit();
                        }
                        break block13;
                    }
                    while (true) {
                        serverMessage = (ObjectMessage)consumer.receive();
                        this.handleMessage(serverMessage);
                        if (!JMSTaskClientConnector.this.transactedQueue) continue;
                        JMSTaskClientConnector.this.consumerSession.commit();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (consumer != null) {
                        try {
                            consumer.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

