/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.persistence;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jbpm.task.service.persistence.TaskTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskJTATransactionManager
extends TaskTransactionManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private UserTransaction ut = this.findUserTransaction();
    private TransactionManager tm = this.findTransactionManager(this.ut);
    private Object tsr = this.findTransactionSynchronizationRegistry(this.ut, this.tm);
    private static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    private static final String[] FALLBACK_TRANSACTION_MANAGER_NAMES = new String[]{"java:comp/TransactionManager", "java:appserver/TransactionManager", "java:pm/TransactionManager", "java:/TransactionManager"};
    private static final String DEFAULT_TRANSACTION_SYNCHRONIZATION_REGISTRY_NAME = "java:comp/TransactionSynchronizationRegistry";
    private static final String TRANSACTION_SYNCHRONIZATION_REGISTRY_CLASS_NAME = "javax.transaction.TransactionSynchronizationRegistry";
    private static Class<?> transactionSynchronizationRegistryClass;

    TaskJTATransactionManager() {
    }

    boolean ownsTransaction(EntityManager em) {
        return this.getStatus(em) == TaskTransactionManager.TransactionStatus.NO_TRANSACTION;
    }

    void attachPersistenceContext(EntityManager em) {
        em.joinTransaction();
    }

    void begin(EntityManager em) {
        try {
            this.ut.begin();
        }
        catch (Exception e) {
            this.logger.warn("Unable to begin transaction", (Throwable)e);
            throw new RuntimeException("Unable to begin transaction", e);
        }
    }

    void commit(EntityManager em) {
        try {
            this.ut.commit();
        }
        catch (Exception e) {
            this.logger.warn("Unable to commit transaction", (Throwable)e);
            throw new RuntimeException("Unable to commit transaction", e);
        }
    }

    void rollback(EntityManager em, boolean txOwner) {
        try {
            if (txOwner) {
                this.ut.rollback();
            } else {
                this.ut.setRollbackOnly();
            }
        }
        catch (Exception e) {
            this.logger.warn("Unable to rollback transaction", (Throwable)e);
            throw new RuntimeException("Unable to rollback transaction", e);
        }
    }

    TaskTransactionManager.TransactionStatus getStatus(EntityManager em) {
        int status;
        try {
            status = this.ut.getStatus();
        }
        catch (SystemException e) {
            throw new RuntimeException("Unable to get status for transaction", e);
        }
        switch (status) {
            case 0: {
                return TaskTransactionManager.TransactionStatus.ACTIVE;
            }
            case 3: {
                return TaskTransactionManager.TransactionStatus.COMMITTED;
            }
            case 4: {
                return TaskTransactionManager.TransactionStatus.ROLLEDBACK;
            }
            case 1: {
                return TaskTransactionManager.TransactionStatus.MARKED_ROLLBACK;
            }
            case 6: {
                return TaskTransactionManager.TransactionStatus.NO_TRANSACTION;
            }
        }
        return TaskTransactionManager.TransactionStatus.UNKNOWN;
    }

    void registerTransactionSynchronization(TaskTransactionManager.TransactionSynchronization ts) {
    }

    private UserTransaction findUserTransaction() {
        try {
            InitialContext context = new InitialContext();
            return (UserTransaction)context.lookup(DEFAULT_USER_TRANSACTION_NAME);
        }
        catch (NamingException ex) {
            this.logger.debug("No UserTransaction found at JNDI location [{}]", (Object)DEFAULT_USER_TRANSACTION_NAME, (Object)ex);
            return null;
        }
    }

    private TransactionManager findTransactionManager(UserTransaction ut) {
        if (ut instanceof TransactionManager) {
            this.logger.debug("JTA UserTransaction object [{}] implements TransactionManager", (Object)ut);
            return (TransactionManager)ut;
        }
        InitialContext context = null;
        try {
            context = new InitialContext();
        }
        catch (NamingException ex) {
            this.logger.debug("Could not initialise JNDI InitialContext", (Throwable)ex);
            return null;
        }
        for (String jndiName : FALLBACK_TRANSACTION_MANAGER_NAMES) {
            try {
                TransactionManager tm = (TransactionManager)context.lookup(jndiName);
                this.logger.debug("JTA TransactionManager found at fallback JNDI location [{}]", (Object)jndiName);
                return tm;
            }
            catch (NamingException ex) {
                this.logger.debug("No JTA TransactionManager found at fallback JNDI location [{}]", (Object)jndiName, (Object)ex);
            }
        }
        return null;
    }

    private Object findTransactionSynchronizationRegistry(UserTransaction ut, TransactionManager tm) {
        if (transactionSynchronizationRegistryClass == null) {
            this.logger.debug("JTA 1.1 [{}] API not available", (Object)TRANSACTION_SYNCHRONIZATION_REGISTRY_CLASS_NAME);
            return null;
        }
        String jndiName = DEFAULT_TRANSACTION_SYNCHRONIZATION_REGISTRY_NAME;
        try {
            InitialContext context = new InitialContext();
            context.lookup(jndiName);
            this.logger.debug("JTA TransactionSynchronizationRegistry found at default JNDI location [{}]", (Object)jndiName);
            return this.tsr;
        }
        catch (NamingException ex) {
            this.logger.debug("No JTA TransactionSynchronizationRegistry found at default JNDI location [{}]", (Object)jndiName, (Object)ex);
            if (transactionSynchronizationRegistryClass.isInstance(ut)) {
                return ut;
            }
            if (transactionSynchronizationRegistryClass.isInstance(tm)) {
                return tm;
            }
            return null;
        }
    }

    static {
        ClassLoader cl = TaskJTATransactionManager.class.getClassLoader();
        try {
            transactionSynchronizationRegistryClass = cl.loadClass(TRANSACTION_SYNCHRONIZATION_REGISTRY_CLASS_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

