/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.persistence;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.jbpm.task.service.persistence.TaskTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskLocalTransactionManager
extends TaskTransactionManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    TaskLocalTransactionManager() {
    }

    boolean ownsTransaction(EntityManager em) {
        TaskTransactionManager.TransactionStatus status = this.getStatus(em);
        return status != TaskTransactionManager.TransactionStatus.ACTIVE && status != TaskTransactionManager.TransactionStatus.MARKED_ROLLBACK;
    }

    void attachPersistenceContext(EntityManager em) {
    }

    synchronized void begin(EntityManager em) {
        try {
            em.getTransaction().begin();
        }
        catch (Exception e) {
            this.logger.warn("Unable to begin transaction", (Throwable)e);
            throw new RuntimeException("Unable to begin transaction", e);
        }
    }

    void commit(EntityManager em) {
        try {
            em.getTransaction().commit();
        }
        catch (Exception e) {
            this.logger.warn("Unable to begin transaction", (Throwable)e);
            throw new RuntimeException("Unable to commit transaction", e);
        }
    }

    void rollback(EntityManager em, boolean txOwner) {
        if (!em.getTransaction().isActive()) {
            return;
        }
        try {
            if (txOwner) {
                em.getTransaction().rollback();
            } else {
                em.getTransaction().setRollbackOnly();
            }
        }
        catch (Exception e) {
            this.logger.warn("Unable to rollback transaction", (Throwable)e);
            throw new RuntimeException("Unable to rollback transaction", e);
        }
    }

    TaskTransactionManager.TransactionStatus getStatus(EntityManager em) {
        EntityTransaction tx = em.getTransaction();
        if (tx.isActive()) {
            if (tx.getRollbackOnly()) {
                return TaskTransactionManager.TransactionStatus.MARKED_ROLLBACK;
            }
            return TaskTransactionManager.TransactionStatus.ACTIVE;
        }
        return TaskTransactionManager.TransactionStatus.COMMITTED;
    }

    void registerTransactionSynchronization(TaskTransactionManager.TransactionSynchronization ts) {
    }
}

