/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.persistence;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.query.DeadlineSummary;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.persistence.TaskPersistenceManagerFactory;
import org.jbpm.task.service.persistence.TaskTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPersistenceManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private TaskTransactionManager ttxm;
    private EntityManager em;
    private final EntityManagerFactory emf;

    TaskPersistenceManager(EntityManagerFactory entityManagerFactory) {
        this.emf = entityManagerFactory;
        this.ttxm = TaskTransactionManager.getInstance(this.emf);
        this.em = this.emf.createEntityManager();
    }

    TaskPersistenceManager(TaskPersistenceManager tpm) {
        this.emf = tpm.emf;
        this.ttxm = TaskTransactionManager.getInstance(this.emf);
        this.em = this.emf.createEntityManager();
    }

    public boolean beginTransaction() {
        boolean txOwner = this.ttxm.ownsTransaction(this.em);
        if (txOwner) {
            this.ttxm.begin(this.em);
        }
        this.ttxm.attachPersistenceContext(this.em);
        return txOwner;
    }

    public void endTransaction(boolean txOwner) {
        if (txOwner) {
            boolean rollbackAttempted = false;
            try {
                if (this.ttxm.getStatus(this.em) == TaskTransactionManager.TransactionStatus.MARKED_ROLLBACK) {
                    rollbackAttempted = true;
                    this.ttxm.rollback(this.em, txOwner);
                }
                this.ttxm.commit(this.em);
            }
            catch (RuntimeException re) {
                String action = rollbackAttempted ? "rollback" : "commit";
                this.logger.error("Unable to " + action + ".", (Throwable)re);
                re.printStackTrace();
                if (!rollbackAttempted) {
                    this.ttxm.rollback(this.em, txOwner);
                }
                throw re;
            }
        }
    }

    public void rollBackTransaction(boolean txOwner) {
        try {
            if (this.ttxm.getStatus(this.em) == TaskTransactionManager.TransactionStatus.ACTIVE) {
                this.ttxm.rollback(this.em, txOwner);
            }
        }
        catch (RuntimeException e) {
            this.logger.error("Unable to (mark as or) rollback transaction!", e.getCause());
            e.printStackTrace();
        }
    }

    public void endPersistenceContext() {
        if (this.em == null) {
            this.ttxm = null;
            return;
        }
        boolean closeEm = this.em.isOpen();
        if (closeEm) {
            try {
                if (this.em.getTransaction().isActive()) {
                    this.endTransaction(true);
                }
                this.em.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.em = null;
        this.ttxm = null;
    }

    public List<DeadlineSummary> getUnescalatedDeadlines() {
        boolean txOwner = this.beginTransaction();
        List<DeadlineSummary> resultList = this.getUnescalatedDeadlinesList();
        this.endTransaction(txOwner);
        return resultList;
    }

    public void setTaskStatusInTransaction(Object taskId, Status taskStatus) {
        boolean txOwner = this.beginTransaction();
        Task task = (Task)this.em.find(Task.class, taskId);
        task.getTaskData().setStatus(Status.Completed);
        this.em.persist((Object)task);
        this.endTransaction(txOwner);
    }

    public List<DeadlineSummary> getUnescalatedDeadlinesList() {
        return this.em.createNamedQuery("UnescalatedDeadlines").getResultList();
    }

    public Object findEntity(Class<?> entityClass, Object primaryKey) {
        return this.em.find(entityClass, primaryKey);
    }

    public void deleteEntity(Object entity) {
        this.em.remove(entity);
    }

    public void saveEntity(Object entity) {
        this.em.persist(entity);
    }

    public Query createQuery(String queryName) {
        return this.em.createNamedQuery(queryName);
    }

    public Query createNewQuery(String queryString) {
        return this.em.createQuery(queryString);
    }

    public boolean userExists(String userId) {
        return this.em.find(User.class, (Object)userId) != null;
    }

    public List<TaskSummary> queryTasksWithUserIdAndLanguage(String queryName, String userId, String language) {
        Query query = this.createQuery(queryName);
        query.setParameter("userId", (Object)userId);
        query.setParameter("language", (Object)language);
        List resultListObject = query.getResultList();
        return resultListObject;
    }

    static {
        TaskServiceSession.setTaskPersistenceManagerFactory(new TaskPersistenceManagerFactory());
        TaskService.setTaskPersistenceManagerFactory(new TaskPersistenceManagerFactory());
    }
}

