/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.persistence;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jbpm.task.service.persistence.TaskJTATransactionManager;
import org.jbpm.task.service.persistence.TaskLocalTransactionManager;

abstract class TaskTransactionManager {
    TaskTransactionManager() {
    }

    abstract void begin(EntityManager var1);

    abstract void commit(EntityManager var1);

    abstract void rollback(EntityManager var1, boolean var2);

    abstract void registerTransactionSynchronization(TransactionSynchronization var1);

    abstract TransactionStatus getStatus(EntityManager var1);

    abstract boolean ownsTransaction(EntityManager var1);

    abstract void attachPersistenceContext(EntityManager var1);

    static TaskTransactionManager getInstance(EntityManagerFactory emf) {
        TaskTransactionManager ttxm = null;
        EntityManager em = emf.createEntityManager();
        boolean useResourceLocalTxm = false;
        boolean useJTATxm = false;
        try {
            em.getTransaction();
            useResourceLocalTxm = true;
        }
        catch (Exception e) {
            boolean illegalStateExceptionThrown = false;
            for (Throwable cause = e; cause != null && !illegalStateExceptionThrown; cause = cause.getCause()) {
                illegalStateExceptionThrown = cause instanceof IllegalStateException;
            }
            if (illegalStateExceptionThrown) {
                useJTATxm = true;
            }
            throw new RuntimeException("Unable to determine persistence-unit type (JTA/Local)", e);
        }
        if (useJTATxm) {
            ttxm = new TaskJTATransactionManager();
        } else if (useResourceLocalTxm) {
            ttxm = new TaskLocalTransactionManager();
        } else {
            throw new RuntimeException("Unknown resource type");
        }
        return ttxm;
    }

    static interface TransactionSynchronization {
        public void beforeCompletion();

        public void afterCompletion(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TransactionStatus {
        ACTIVE,
        COMMITTED,
        MARKED_ROLLBACK,
        ROLLEDBACK,
        NO_TRANSACTION,
        UNKNOWN;

    }
}

