/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.drools.FactHandle;
import org.drools.RuntimeDroolsException;
import org.drools.base.EvaluatorWrapper;
import org.drools.base.ModifyInterceptor;
import org.drools.base.mvel.MVELCalendarCoercion;
import org.drools.base.mvel.MVELDateCoercion;
import org.drools.base.mvel.MVELDebugHandler;
import org.drools.common.AgendaItem;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.definition.rule.Rule;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.Declaration;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.spi.GlobalResolver;
import org.drools.spi.KnowledgeHelper;
import org.mvel2.ConversionHandler;
import org.mvel2.DataConversion;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.Interceptor;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.SimpleVariableSpaceModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELCompilationUnit
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 510L;
    private String name;
    private String expression;
    private String[] globalIdentifiers;
    private EvaluatorWrapper[] operators;
    private Declaration[] previousDeclarations;
    private Declaration[] localDeclarations;
    private String[] otherIdentifiers;
    private String[] inputIdentifiers;
    private String[] inputTypes;
    private int languageLevel;
    private boolean strictMode;
    private SimpleVariableSpaceModel varModel;
    private int allVarsLength;
    public static final Map<String, Interceptor> INTERCEPTORS = new InterceptorMap();
    private static final Map<String, Class<?>> primitivesMap;
    public static final Object COMPILER_LOCK;

    public MVELCompilationUnit() {
    }

    public MVELCompilationUnit(String name, String expression, String[] globalIdentifiers, EvaluatorWrapper[] operators, Declaration[] previousDeclarations, Declaration[] localDeclarations, String[] otherIdentifiers, String[] inputIdentifiers, String[] inputTypes, int languageLevel, boolean strictMode) {
        this.name = name;
        this.expression = expression;
        this.globalIdentifiers = globalIdentifiers;
        this.operators = operators;
        this.previousDeclarations = previousDeclarations;
        this.localDeclarations = localDeclarations;
        this.otherIdentifiers = otherIdentifiers;
        this.inputIdentifiers = inputIdentifiers;
        this.inputTypes = inputTypes;
        this.languageLevel = languageLevel;
        this.strictMode = strictMode;
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.expression);
        out.writeObject(this.globalIdentifiers);
        out.writeObject(this.operators);
        out.writeObject(this.previousDeclarations);
        out.writeObject(this.localDeclarations);
        out.writeObject(this.otherIdentifiers);
        out.writeObject(this.inputIdentifiers);
        out.writeObject(this.inputTypes);
        out.writeInt(this.languageLevel);
        out.writeBoolean(this.strictMode);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.expression = in.readUTF();
        this.globalIdentifiers = (String[])in.readObject();
        this.operators = (EvaluatorWrapper[])in.readObject();
        this.previousDeclarations = (Declaration[])in.readObject();
        this.localDeclarations = (Declaration[])in.readObject();
        this.otherIdentifiers = (String[])in.readObject();
        this.inputIdentifiers = (String[])in.readObject();
        this.inputTypes = (String[])in.readObject();
        this.languageLevel = in.readInt();
        this.strictMode = in.readBoolean();
    }

    public Serializable getCompiledExpression(MVELDialectRuntimeData runtimeData) {
        ParserConfiguration conf = runtimeData.getParserConfiguration();
        ParserContext parserContext = new ParserContext(conf);
        if (MVELDebugHandler.isDebugMode()) {
            parserContext.setDebugSymbols(true);
        }
        parserContext.setStrictTypeEnforcement(this.strictMode);
        parserContext.setStrongTyping(this.strictMode);
        parserContext.setIndexAllocation(true);
        if (INTERCEPTORS != null) {
            parserContext.setInterceptors(INTERCEPTORS);
        }
        parserContext.addIndexedInput(this.inputIdentifiers);
        String identifier = null;
        String type = null;
        try {
            int length = this.inputIdentifiers.length;
            for (int i = 0; i < length; ++i) {
                identifier = this.inputIdentifiers[i];
                type = this.inputTypes[i];
                Class cls = MVELCompilationUnit.loadClass((ClassLoader)runtimeData.getRootClassLoader(), this.inputTypes[i]);
                parserContext.addInput(this.inputIdentifiers[i], cls);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("Unable to resolve class '" + type + "' for identifier '" + identifier);
        }
        parserContext.setSourceFile(this.name);
        String[] varNames = parserContext.getIndexedVarNames();
        ExecutableStatement stmt = (ExecutableStatement)MVELCompilationUnit.compile(this.expression, (ClassLoader)runtimeData.getRootClassLoader(), parserContext, this.languageLevel);
        Set localNames = parserContext.getVariables().keySet();
        parserContext.addIndexedLocals(localNames);
        String[] locals = localNames.toArray(new String[localNames.size()]);
        String[] allVars = new String[varNames.length + locals.length];
        System.arraycopy(varNames, 0, allVars, 0, varNames.length);
        System.arraycopy(locals, 0, allVars, varNames.length, locals.length);
        this.varModel = new SimpleVariableSpaceModel(allVars);
        this.allVarsLength = allVars.length;
        return stmt;
    }

    public VariableResolverFactory createFactory() {
        Object[] vals = new Object[this.inputIdentifiers.length];
        VariableResolverFactory factory = this.varModel.createFactory(vals);
        DroolsVarFactory df = new DroolsVarFactory();
        factory.setNextFactory((VariableResolverFactory)df);
        return factory;
    }

    public VariableResolverFactory getFactory(Object knowledgeHelper, Rule rule, Object rightObject, LeftTuple tuples, Object[] otherVars, InternalWorkingMemory workingMemory, GlobalResolver globals) {
        VariableResolverFactory factory = this.createFactory();
        this.updateFactory(knowledgeHelper, rule, rightObject, tuples, otherVars, workingMemory, globals, factory);
        return factory;
    }

    public void updateFactory(Object knowledgeHelper, Rule rule, Object rightObject, LeftTuple tuples, Object[] otherVars, InternalWorkingMemory workingMemory, GlobalResolver globals, VariableResolverFactory factory) {
        int varLength = this.inputIdentifiers.length;
        int i = 0;
        if (rightObject != null) {
            factory.getIndexedVariableResolver(i++).setValue(rightObject);
        }
        factory.getIndexedVariableResolver(i++).setValue(knowledgeHelper);
        factory.getIndexedVariableResolver(i++).setValue(knowledgeHelper);
        factory.getIndexedVariableResolver(i++).setValue((Object)rule);
        if (this.globalIdentifiers != null) {
            int length = this.globalIdentifiers.length;
            for (int j = 0; j < length; ++j) {
                factory.getIndexedVariableResolver(i++).setValue(globals.resolveGlobal(this.globalIdentifiers[j]));
            }
        }
        InternalFactHandle[] handles = tuples != null ? tuples.toFactHandles() : new InternalFactHandle[]{};
        if (this.operators != null) {
            int length = this.operators.length;
            for (int j = 0; j < length; ++j) {
                factory.getIndexedVariableResolver(i++).setValue((Object)this.operators[j].setWorkingMemory(workingMemory));
                if (this.operators[j].getLeftBinding() != null) {
                    if (this.operators[j].getLeftBinding().getIdentifier().equals("this")) {
                        this.operators[j].setLeftHandle((InternalFactHandle)workingMemory.getFactHandle(rightObject));
                    } else {
                        this.operators[j].setLeftHandle(MVELCompilationUnit.getFactHandle(this.operators[j].getLeftBinding(), handles));
                    }
                }
                if (this.operators[j].getRightBinding() == null) continue;
                if (this.operators[j].getRightBinding().getIdentifier().equals("this")) {
                    this.operators[j].setRightHandle((InternalFactHandle)workingMemory.getFactHandle(rightObject));
                    continue;
                }
                this.operators[j].setRightHandle(MVELCompilationUnit.getFactHandle(this.operators[j].getRightBinding(), handles));
            }
        }
        IdentityHashMap<Object, FactHandle> identityMap = null;
        if (knowledgeHelper != null) {
            identityMap = new IdentityHashMap<Object, FactHandle>();
        }
        if (tuples != null && this.previousDeclarations != null && this.previousDeclarations.length > 0) {
            Declaration[] prevDecl = this.previousDeclarations;
            if (knowledgeHelper != null) {
                prevDecl = ((AgendaItem)((KnowledgeHelper)knowledgeHelper).getActivation()).getRuleTerminalNode().getDeclarations();
            }
            for (Declaration decl : prevDecl) {
                InternalFactHandle handle = MVELCompilationUnit.getFactHandle(decl, handles);
                Object o = decl.getValue(workingMemory, handle.getObject());
                if (knowledgeHelper != null && decl.isPatternDeclaration()) {
                    identityMap.put(o, handle);
                }
                factory.getIndexedVariableResolver(i++).setValue(o);
            }
        }
        if (this.localDeclarations != null && this.localDeclarations.length > 0) {
            for (Declaration decl : this.localDeclarations) {
                Object o = decl.getValue(workingMemory, rightObject);
                factory.getIndexedVariableResolver(i++).setValue(o);
            }
        }
        int otherVarsPos = 0;
        if (otherVars != null) {
            otherVarsPos = i;
            for (Object o : otherVars) {
                factory.getIndexedVariableResolver(i++).setValue(o);
            }
        }
        int otherVarsLength = i - otherVarsPos;
        for (i = varLength; i < this.allVarsLength; ++i) {
            factory.getIndexedVariableResolver(i).setValue(null);
        }
        DroolsVarFactory df = (DroolsVarFactory)factory.getNextFactory();
        df.setOtherVarsPos(otherVarsPos);
        df.setOtherVarsLength(otherVarsLength);
        if (knowledgeHelper != null && knowledgeHelper instanceof KnowledgeHelper) {
            KnowledgeHelper kh = (KnowledgeHelper)knowledgeHelper;
            kh.setIdentityMap(identityMap);
            df.setKnowledgeHelper(kh);
        }
    }

    private static InternalFactHandle getFactHandle(Declaration declaration, InternalFactHandle[] handles) {
        return handles.length >= declaration.getPattern().getOffset() ? handles[declaration.getPattern().getOffset()] : null;
    }

    public static Serializable compile(String text, ClassLoader classLoader, ParserContext parserContext, int languageLevel) {
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
        MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        if (MVELDebugHandler.isDebugMode()) {
            parserContext.setDebugSymbols(true);
        }
        return MVEL.compileExpression((String)text.trim(), (ParserContext)parserContext);
    }

    public static Class loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        Class<?> cls = primitivesMap.get(className);
        if (cls == null) {
            cls = classLoader.loadClass(className);
        }
        return cls;
    }

    public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        int i;
        if (this.previousDeclarations != null) {
            for (i = 0; i < this.previousDeclarations.length; ++i) {
                if (!this.previousDeclarations[i].equals(declaration)) continue;
                this.previousDeclarations[i] = resolved;
            }
        }
        if (this.localDeclarations != null) {
            for (i = 0; i < this.localDeclarations.length; ++i) {
                if (!this.localDeclarations[i].equals(declaration)) continue;
                this.localDeclarations[i] = resolved;
            }
        }
    }

    public MVELCompilationUnit clone() {
        Declaration[] clonedPreviousDeclarations = null;
        if (this.previousDeclarations != null) {
            clonedPreviousDeclarations = new Declaration[this.previousDeclarations.length];
            System.arraycopy(this.previousDeclarations, 0, clonedPreviousDeclarations, 0, this.previousDeclarations.length);
        }
        Declaration[] clonedLocalDeclarations = null;
        if (this.localDeclarations != null) {
            clonedLocalDeclarations = new Declaration[this.localDeclarations.length];
            System.arraycopy(this.localDeclarations, 0, clonedLocalDeclarations, 0, this.localDeclarations.length);
        }
        MVELCompilationUnit unit = new MVELCompilationUnit(this.name, this.expression, this.globalIdentifiers, this.operators, clonedPreviousDeclarations, clonedLocalDeclarations, this.otherIdentifiers, this.inputIdentifiers, this.inputTypes, this.languageLevel, this.strictMode);
        unit.varModel = this.varModel;
        return unit;
    }

    public static long getSerialversionuid() {
        return 510L;
    }

    public String getName() {
        return this.name;
    }

    public String[] getGlobalIdentifiers() {
        return this.globalIdentifiers;
    }

    public Declaration[] getPreviousDeclarations() {
        return this.previousDeclarations;
    }

    public void setPreviousDeclarations(Declaration[] previousDeclarations) {
        this.previousDeclarations = previousDeclarations;
    }

    public Declaration[] getLocalDeclarations() {
        return this.localDeclarations;
    }

    public String[] getOtherIdentifiers() {
        return this.otherIdentifiers;
    }

    public String[] getInputIdentifiers() {
        return this.inputIdentifiers;
    }

    public String[] getInputTypes() {
        return this.inputTypes;
    }

    public int getLanguageLevel() {
        return this.languageLevel;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public static Map getInterceptors() {
        return INTERCEPTORS;
    }

    public static Map<String, Class<?>> getPrimitivesmap() {
        return primitivesMap;
    }

    public static Object getCompilerLock() {
        return COMPILER_LOCK;
    }

    static {
        DataConversion.addConversionHandler(Date.class, (ConversionHandler)new MVELDateCoercion());
        DataConversion.addConversionHandler(Calendar.class, (ConversionHandler)new MVELCalendarCoercion());
        primitivesMap = new HashMap();
        primitivesMap.put("int", Integer.TYPE);
        primitivesMap.put("boolean", Boolean.TYPE);
        primitivesMap.put("float", Float.TYPE);
        primitivesMap.put("long", Long.TYPE);
        primitivesMap.put("short", Short.TYPE);
        primitivesMap.put("byte", Byte.TYPE);
        primitivesMap.put("double", Double.TYPE);
        primitivesMap.put("char", Character.TYPE);
        COMPILER_LOCK = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InterceptorMap
    implements Map<String, Interceptor> {
        private InterceptorMap() {
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return key != null && key.equals("Modify");
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Interceptor get(Object key) {
            return new ModifyInterceptor();
        }

        @Override
        public Interceptor put(String key, Interceptor value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Interceptor remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends Interceptor> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            return new HashSet<String>(){
                {
                    this.add("Modify");
                }
            };
        }

        @Override
        public Collection<Interceptor> values() {
            return new ArrayList<Interceptor>(){
                {
                    this.add(new ModifyInterceptor());
                }
            };
        }

        @Override
        public Set<Map.Entry<String, Interceptor>> entrySet() {
            return new HashSet<Map.Entry<String, Interceptor>>(){
                {
                    this.add(new Map.Entry<String, Interceptor>(){

                        @Override
                        public String getKey() {
                            return "Modify";
                        }

                        @Override
                        public Interceptor getValue() {
                            return new ModifyInterceptor();
                        }

                        @Override
                        public Interceptor setValue(Interceptor value) {
                            throw new UnsupportedOperationException();
                        }
                    });
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyHandlerFactoryFixer
    extends PropertyHandlerFactory {
        public static Map<Class, PropertyHandler> getPropertyHandlerClass() {
            return propertyHandlerClass;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DroolsVarFactory
    implements VariableResolverFactory {
        private KnowledgeHelper knowledgeHelper;
        private int otherVarsPos;
        private int otherVarsLength;

        public KnowledgeHelper getKnowledgeHelper() {
            return this.knowledgeHelper;
        }

        public void setKnowledgeHelper(KnowledgeHelper kh) {
            this.knowledgeHelper = kh;
        }

        public int getOtherVarsPos() {
            return this.otherVarsPos;
        }

        public void setOtherVarsPos(int otherVarsPos) {
            this.otherVarsPos = otherVarsPos;
        }

        public int getOtherVarsLength() {
            return this.otherVarsLength;
        }

        public void setOtherVarsLength(int otherVarsLength) {
            this.otherVarsLength = otherVarsLength;
        }

        public VariableResolver createIndexedVariable(int index, String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public VariableResolver getIndexedVariableResolver(int index) {
            throw new UnsupportedOperationException();
        }

        public VariableResolver createVariable(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public VariableResolver createVariable(String name, Object value, Class<?> type) {
            throw new UnsupportedOperationException();
        }

        public VariableResolver getVariableResolver(String name) {
            return null;
        }

        public boolean isResolveable(String name) {
            return false;
        }

        protected VariableResolver addResolver(String name, VariableResolver vr) {
            throw new UnsupportedOperationException();
        }

        private VariableResolver getResolver(String name) {
            return null;
        }

        public boolean isTarget(String name) {
            return false;
        }

        public Set<String> getKnownVariables() {
            return Collections.emptySet();
        }

        public void clear() {
        }

        public boolean isIndexedFactory() {
            return false;
        }

        public VariableResolver createIndexedVariable(int index, String name, Object value, Class<?> typee) {
            return null;
        }

        public VariableResolver setIndexedVariableResolver(int index, VariableResolver variableResolver) {
            return null;
        }

        public VariableResolverFactory getNextFactory() {
            return null;
        }

        public VariableResolverFactory setNextFactory(VariableResolverFactory resolverFactory) {
            return null;
        }

        public int variableIndexOf(String name) {
            return 0;
        }

        public boolean tiltFlag() {
            return false;
        }

        public void setTiltFlag(boolean tilt) {
        }
    }
}

