/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel;

import org.drools.RuntimeDroolsException;
import org.drools.factmodel.FieldDefinition;
import org.mvel2.asm.MethodVisitor;

public class BuildUtils {
    public static String[] getInternalTypes(String[] superClasses) {
        if (superClasses == null) {
            return null;
        }
        String[] internals = new String[superClasses.length];
        for (int j = 0; j < internals.length; ++j) {
            internals[j] = BuildUtils.getInternalType(superClasses[j]);
        }
        return internals.length > 0 ? internals : null;
    }

    public static String getGenericTypes(String[] interfaces) {
        StringBuilder sb = new StringBuilder();
        sb.append("<K:").append(BuildUtils.getTypeDescriptor(Object.class.getName())).append(">");
        sb.append(BuildUtils.getTypeDescriptor(Object.class.getName()));
        for (String intf : interfaces) {
            String temp = BuildUtils.getTypeDescriptor(intf);
            sb.append(temp.replace(";", "<TK;>;"));
        }
        return sb.toString();
    }

    public static String getInternalType(String type) {
        String internalType = null;
        if ("byte".equals(type)) {
            internalType = "B";
        } else if ("char".equals(type)) {
            internalType = "C";
        } else if ("double".equals(type)) {
            internalType = "D";
        } else if ("float".equals(type)) {
            internalType = "F";
        } else if ("int".equals(type)) {
            internalType = "I";
        } else if ("long".equals(type)) {
            internalType = "J";
        } else if ("short".equals(type)) {
            internalType = "S";
        } else if ("boolean".equals(type)) {
            internalType = "Z";
        } else if ("void".equals(type)) {
            internalType = "V";
        } else if (type != null) {
            internalType = type.replace('.', '/');
        }
        return internalType;
    }

    public static String getTypeDescriptor(String type) {
        String internalType = null;
        if ("byte".equals(type)) {
            internalType = "B";
        } else if ("char".equals(type)) {
            internalType = "C";
        } else if ("double".equals(type)) {
            internalType = "D";
        } else if ("float".equals(type)) {
            internalType = "F";
        } else if ("int".equals(type)) {
            internalType = "I";
        } else if ("long".equals(type)) {
            internalType = "J";
        } else if ("short".equals(type)) {
            internalType = "S";
        } else if ("boolean".equals(type)) {
            internalType = "Z";
        } else if ("void".equals(type)) {
            internalType = "V";
        } else if (type != null && type.startsWith("[")) {
            int j = 0;
            while (type.charAt(++j) == '[') {
            }
            internalType = type.charAt(j) == 'L' ? type.replace('.', '/') : type;
        } else if (type != null) {
            internalType = "L" + type.replace('.', '/') + ";";
        }
        return internalType;
    }

    public static String arrayType(String type) {
        if (BuildUtils.isArray(type)) {
            if (type.length() == BuildUtils.arrayDimSize(type) + 1) {
                return type;
            }
            String ans = "Ljava/lang/Object;";
            for (int j = 0; j < BuildUtils.arrayDimSize(type); ++j) {
                ans = "[" + ans;
            }
            return ans;
        }
        return null;
    }

    public static int arrayDimSize(String type) {
        int j = 0;
        while (type.charAt(j) == '[') {
            ++j;
        }
        return j;
    }

    public static boolean isPrimitive(String type) {
        boolean isPrimitive = false;
        if ("byte".equals(type) || "char".equals(type) || "double".equals(type) || "float".equals(type) || "int".equals(type) || "long".equals(type) || "short".equals(type) || "boolean".equals(type) || "void".equals(type)) {
            isPrimitive = true;
        }
        return isPrimitive;
    }

    public static boolean isArray(String type) {
        return type.startsWith("[");
    }

    public static Object getDefaultValue(FieldDefinition fld) {
        String type = fld.getTypeName();
        if ("byte".equals(type)) {
            return fld.getDefaultValueAs_byte();
        }
        if ("char".equals(type)) {
            return Character.valueOf(fld.getDefaultValueAs_char());
        }
        if ("double".equals(type)) {
            return fld.getDefaultValueAs_double();
        }
        if ("float".equals(type)) {
            return Float.valueOf(fld.getDefaultValueAs_float());
        }
        if ("int".equals(type)) {
            return fld.getDefaultValueAs_int();
        }
        if ("long".equals(type)) {
            return fld.getDefaultValueAs_long();
        }
        if ("short".equals(type)) {
            return fld.getDefaultValueAs_short();
        }
        if ("boolean".equals(type)) {
            return fld.getDefaultValueAs_boolean();
        }
        if ("java.lang.String".equals(type)) {
            return fld.getDefaultValueAsString();
        }
        if ("java.lang.Byte".equals(type) || "Byte".equals(type)) {
            return fld.getDefaultValueAsByte();
        }
        if ("java.lang.Character".equals(type) || "Character".equals(type)) {
            return fld.getDefaultValueAsChar();
        }
        if ("java.lang.Double".equals(type) || "Double".equals(type)) {
            return fld.getDefaultValueAsDouble();
        }
        if ("java.lang.Float".equals(type) || "Float".equals(type)) {
            return fld.getDefaultValueAsFloat();
        }
        if ("java.lang.Integer".equals(type) || "Integer".equals(type)) {
            return fld.getDefaultValueAsInt();
        }
        if ("java.lang.Long".equals(type) || "Long".equals(type)) {
            return fld.getDefaultValueAsLong();
        }
        if ("java.lang.Short".equals(type) || "Short".equals(type)) {
            return fld.getDefaultValueAsShort();
        }
        if ("java.lang.Boolean".equals(type) || "Boolean".equals(type)) {
            return fld.getDefaultValueAsBoolean();
        }
        return null;
    }

    public static boolean isBoxed(String type) {
        if (type == null) {
            return false;
        }
        return "java.lang.Short".equals(type) || "java.lang.Byte".equals(type) || "java.lang.Character".equals(type) || "java.lang.Double".equals(type) || "java.lang.Float".equals(type) || "java.lang.Integer".equals(type) || "java.lang.Boolean".equals(type) || "java.lang.Long".equals(type);
    }

    public static String unBox(String type) {
        if ("java.lang.Byte".equals(type) || "Byte".equals(type)) {
            return BuildUtils.getInternalType("byte");
        }
        if ("java.lang.Character".equals(type) || "Character".equals(type)) {
            return BuildUtils.getInternalType("char");
        }
        if ("java.lang.Double".equals(type) || "Double".equals(type)) {
            return BuildUtils.getInternalType("double");
        }
        if ("java.lang.Float".equals(type) || "Float".equals(type)) {
            return BuildUtils.getInternalType("float");
        }
        if ("java.lang.Integer".equals(type) || "Integer".equals(type)) {
            return BuildUtils.getInternalType("int");
        }
        if ("java.lang.Long".equals(type) || "Long".equals(type)) {
            return BuildUtils.getInternalType("long");
        }
        if ("java.lang.Short".equals(type) || "Short".equals(type)) {
            return BuildUtils.getInternalType("short");
        }
        if ("java.lang.Boolean".equals(type) || "Boolean".equals(type)) {
            return BuildUtils.getInternalType("boolean");
        }
        throw new RuntimeDroolsException("Unable to recognize boxed primitive type " + type);
    }

    public static String box(String type) {
        if ("byte".equals(type)) {
            return "java.lang.Byte";
        }
        if ("char".equals(type)) {
            return "java.lang.Character";
        }
        if ("double".equals(type)) {
            return "java.lang.Double";
        }
        if ("float".equals(type)) {
            return "java.lang.Float";
        }
        if ("int".equals(type)) {
            return "java.lang.Integer";
        }
        if ("long".equals(type)) {
            return "java.lang.Long";
        }
        if ("short".equals(type)) {
            return "java.lang.Short";
        }
        if ("boolean".equals(type)) {
            return "java.lang.Boolean";
        }
        throw new RuntimeDroolsException("Unable to recognize primitive type " + type);
    }

    public static int sizeOf(String type) {
        if ("byte".equals(type)) {
            return 1;
        }
        if ("char".equals(type)) {
            return 1;
        }
        if ("double".equals(type)) {
            return 2;
        }
        if ("float".equals(type)) {
            return 1;
        }
        if ("int".equals(type)) {
            return 1;
        }
        if ("long".equals(type)) {
            return 2;
        }
        if ("short".equals(type)) {
            return 1;
        }
        if ("boolean".equals(type)) {
            return 1;
        }
        return 1;
    }

    public static int returnType(String type) {
        if ("byte".equals(type)) {
            return 172;
        }
        if ("char".equals(type)) {
            return 172;
        }
        if ("double".equals(type)) {
            return 175;
        }
        if ("float".equals(type)) {
            return 174;
        }
        if ("int".equals(type)) {
            return 172;
        }
        if ("long".equals(type)) {
            return 173;
        }
        if ("short".equals(type)) {
            return 172;
        }
        if ("boolean".equals(type)) {
            return 172;
        }
        if ("void".equals(type)) {
            return 177;
        }
        return 176;
    }

    public static int varType(String type) {
        if ("byte".equals(type)) {
            return 21;
        }
        if ("char".equals(type)) {
            return 21;
        }
        if ("double".equals(type)) {
            return 24;
        }
        if ("float".equals(type)) {
            return 23;
        }
        if ("int".equals(type)) {
            return 21;
        }
        if ("long".equals(type)) {
            return 22;
        }
        if ("short".equals(type)) {
            return 21;
        }
        if ("boolean".equals(type)) {
            return 21;
        }
        return 25;
    }

    public static int storeType(String type) {
        if ("byte".equals(type)) {
            return 54;
        }
        if ("char".equals(type)) {
            return 54;
        }
        if ("double".equals(type)) {
            return 57;
        }
        if ("float".equals(type)) {
            return 56;
        }
        if ("int".equals(type)) {
            return 54;
        }
        if ("long".equals(type)) {
            return 55;
        }
        if ("short".equals(type)) {
            return 54;
        }
        if ("boolean".equals(type)) {
            return 54;
        }
        return 58;
    }

    public static boolean isBoolean(String type) {
        return "boolean".equals(type);
    }

    public static int zero(String type) {
        if ("byte".equals(type)) {
            return 3;
        }
        if ("char".equals(type)) {
            return 3;
        }
        if ("double".equals(type)) {
            return 14;
        }
        if ("float".equals(type)) {
            return 11;
        }
        if ("int".equals(type)) {
            return 3;
        }
        if ("long".equals(type)) {
            return 9;
        }
        if ("short".equals(type)) {
            return 3;
        }
        if ("boolean".equals(type)) {
            return 3;
        }
        return 1;
    }

    public static String getterName(String fieldName, String type) {
        String prefix = BuildUtils.isBoolean(type) ? "is" : "get";
        return prefix + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static String setterName(String fieldName, String type) {
        return "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static String extractor(String type) {
        if ("byte".equals(type)) {
            return "getByteValue";
        }
        if ("char".equals(type)) {
            return "getCharValue";
        }
        if ("double".equals(type)) {
            return "getDoubleValue";
        }
        if ("float".equals(type)) {
            return "getFloatValue";
        }
        if ("int".equals(type)) {
            return "getIntValue";
        }
        if ("long".equals(type)) {
            return "getLongValue";
        }
        if ("short".equals(type)) {
            return "getShortValue";
        }
        if ("boolean".equals(type)) {
            return "getBooleanValue";
        }
        return "getValue";
    }

    public static String injector(String type) {
        if ("byte".equals(type)) {
            return "setByteValue";
        }
        if ("char".equals(type)) {
            return "setCharValue";
        }
        if ("double".equals(type)) {
            return "setDoubleValue";
        }
        if ("float".equals(type)) {
            return "setFloatValue";
        }
        if ("int".equals(type)) {
            return "setIntValue";
        }
        if ("long".equals(type)) {
            return "setLongValue";
        }
        if ("short".equals(type)) {
            return "setShortValue";
        }
        if ("boolean".equals(type)) {
            return "setBooleanValue";
        }
        return "setValue";
    }

    public static String numericMorph(String type) {
        if ("java.lang.Byte".equals(type) || "Byte".equals(type)) {
            return "byteValue";
        }
        if ("java.lang.Double".equals(type) || "Double".equals(type)) {
            return "doubleValue";
        }
        if ("java.lang.Float".equals(type) || "Float".equals(type)) {
            return "floatValue";
        }
        if ("java.lang.Integer".equals(type) || "Integer".equals(type)) {
            return "intValue";
        }
        if ("java.lang.Long".equals(type) || "Long".equals(type)) {
            return "longValue";
        }
        if ("java.lang.Short".equals(type) || "Short".equals(type)) {
            return "shortBalue";
        }
        throw new RuntimeDroolsException("Not a numeric type " + type);
    }

    public static void pushInt(MethodVisitor mv, int j) {
        switch (j) {
            case 0: {
                mv.visitInsn(3);
                break;
            }
            case 1: {
                mv.visitInsn(4);
                break;
            }
            case 2: {
                mv.visitInsn(5);
                break;
            }
            case 3: {
                mv.visitInsn(6);
                break;
            }
            case 4: {
                mv.visitInsn(7);
                break;
            }
            case 5: {
                mv.visitInsn(8);
                break;
            }
            default: {
                mv.visitIntInsn(16, j);
            }
        }
    }
}

